/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering.wadi;

import java.net.URI;
import java.util.HashSet;
import java.util.Properties;
import org.apache.catalina.tribes.membership.StaticMember;
import org.apache.geronimo.clustering.LocalNode;
import org.apache.geronimo.clustering.Node;
import org.apache.geronimo.clustering.wadi.BasicNodeService;
import org.apache.geronimo.clustering.wadi.DispatcherHolder;
import org.apache.geronimo.clustering.wadi.NodeServiceHelper;
import org.apache.geronimo.clustering.wadi.WadiStaticMember;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.codehaus.wadi.core.reflect.ClassIndexerRegistry;
import org.codehaus.wadi.core.reflect.base.DeclaredMemberFilter;
import org.codehaus.wadi.core.reflect.base.MemberFilter;
import org.codehaus.wadi.core.reflect.jdk.JDKClassIndexerRegistry;
import org.codehaus.wadi.core.util.SimpleStreamer;
import org.codehaus.wadi.core.util.Streamer;
import org.codehaus.wadi.group.Dispatcher;
import org.codehaus.wadi.group.DispatcherRegistry;
import org.codehaus.wadi.group.EndPoint;
import org.codehaus.wadi.group.MessageExchangeException;
import org.codehaus.wadi.group.StaticDispatcherRegistry;
import org.codehaus.wadi.servicespace.ServiceSpace;
import org.codehaus.wadi.servicespace.admin.AdminServiceSpace;
import org.codehaus.wadi.tribes.TribesDispatcher;
import org.codehaus.wadi.web.impl.URIEndPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TribesDispatcherHolder
implements GBeanLifecycle,
DispatcherHolder {
    private static final Logger log = LoggerFactory.getLogger(TribesDispatcherHolder.class);
    private final URI endPointURI;
    private final String clusterName;
    private final LocalNode node;
    private final ClassLoader cl;
    private final boolean disableMCastService;
    private final int receiverPort;
    private final Properties mcastServiceProperties;
    private final WadiStaticMember staticMember;
    private final DispatcherRegistry dispatcherRegistry;
    private TribesDispatcher dispatcher;
    private AdminServiceSpace adminServiceSpace;
    public static final String GBEAN_ATTR_END_POINT_URI = "endPointURI";
    public static final String GBEAN_ATTR_CLUSTER_NAME = "clusterName";
    public static final String GBEAN_ATTR_DISABLE_MCAST = "disableMCastService";
    public static final String GBEAN_ATTR_RECEIVER_PORT = "receiverPort";
    public static final String GBEAN_ATTR_MCAST_PROPERTIES = "mcastServiceProperties";
    public static final String GBEAN_REF_STATIC_MEMBER = "staticMember";
    public static final String GBEAN_ATTR_CLUSTER_URI = "clusterUri";
    public static final String GBEAN_REF_NODE = "Node";

    public TribesDispatcherHolder(@ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader cl, @ParamAttribute(name="endPointURI") URI endPointURI, @ParamAttribute(name="clusterName") String clusterName, @ParamAttribute(name="disableMCastService") boolean disableMCastService, @ParamAttribute(name="receiverPort") int receiverPort, @ParamAttribute(name="mcastServiceProperties") Properties mcastServiceProperties, @ParamReference(name="staticMember") WadiStaticMember staticMember, @ParamReference(name="Node") LocalNode node) {
        if (null == endPointURI) {
            throw new IllegalArgumentException("endPointURI is required");
        }
        if (null == clusterName) {
            throw new IllegalArgumentException("clusterName is required");
        }
        if (null == node) {
            throw new IllegalArgumentException("node is required");
        }
        if (null == cl) {
            throw new IllegalArgumentException("cl is required");
        }
        if (receiverPort < 1) {
            receiverPort = 4000;
        }
        this.endPointURI = endPointURI;
        this.clusterName = clusterName;
        this.disableMCastService = disableMCastService;
        this.staticMember = staticMember;
        this.receiverPort = receiverPort;
        this.mcastServiceProperties = mcastServiceProperties;
        this.node = node;
        this.cl = cl;
        this.dispatcherRegistry = new StaticDispatcherRegistry();
    }

    public void doStart() throws Exception {
        HashSet<StaticMember> staticMemberCollection = new HashSet<StaticMember>();
        log.debug("Attempting to set static members");
        if (this.staticMember != null) {
            log.debug("Attempting to add static member: {}", (Object)((StaticMember)this.staticMember.getStaticMember()).getPort());
            staticMemberCollection.add((StaticMember)this.staticMember.getStaticMember());
            for (WadiStaticMember nextStaticMember = (WadiStaticMember)this.staticMember.getNextStaticMember(); nextStaticMember != null; nextStaticMember = (WadiStaticMember)nextStaticMember.getNextStaticMember()) {
                log.debug("Attempting to add static member: {}", (Object)((StaticMember)this.staticMember.getStaticMember()).getPort());
                staticMemberCollection.add((StaticMember)nextStaticMember.getStaticMember());
            }
        }
        log.debug("List of static members: {}", staticMemberCollection);
        this.dispatcher = new TribesDispatcher(this.clusterName, this.node.getName(), (EndPoint)new URIEndPoint(this.endPointURI), staticMemberCollection, this.disableMCastService, this.mcastServiceProperties, this.receiverPort);
        this.dispatcher.start();
        this.adminServiceSpace = new AdminServiceSpace((Dispatcher)this.dispatcher, (ClassIndexerRegistry)new JDKClassIndexerRegistry((MemberFilter)new DeclaredMemberFilter()), (Streamer)new SimpleStreamer(this.cl));
        this.registerCustomAdminServices();
        this.adminServiceSpace.start();
        this.dispatcherRegistry.register((Dispatcher)this.dispatcher);
    }

    public void doStop() throws Exception {
        this.adminServiceSpace.stop();
        this.dispatcherRegistry.unregister((Dispatcher)this.dispatcher);
        this.dispatcher.stop();
    }

    public void doFail() {
        if (null != this.adminServiceSpace) {
            try {
                this.adminServiceSpace.stop();
            }
            catch (Exception e) {
                log.error("see nested", (Throwable)e);
            }
        }
        if (null != this.dispatcher) {
            this.dispatcherRegistry.unregister((Dispatcher)this.dispatcher);
            try {
                this.dispatcher.stop();
            }
            catch (MessageExchangeException e) {
                log.error("see nested", (Throwable)e);
            }
        }
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    protected void registerCustomAdminServices() {
        NodeServiceHelper nodeServiceHelper = new NodeServiceHelper((ServiceSpace)this.adminServiceSpace);
        nodeServiceHelper.registerNodeService(new BasicNodeService(this.node));
    }
}

