/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.clustering.wadi;

import java.util.Map;
import org.apache.geronimo.clustering.Session;

public class WADISessionAdaptor
implements Session {
    private static final String ADAPTOR_KEY = "ADAPTOR_KEY";
    private final org.codehaus.wadi.core.session.Session session;

    public static WADISessionAdaptor retrieveAdaptor(org.codehaus.wadi.core.session.Session session) {
        WADISessionAdaptor adaptor = (WADISessionAdaptor)session.getLocalStateMap().get(ADAPTOR_KEY);
        if (null == adaptor) {
            throw new IllegalStateException("No registered adaptor");
        }
        return adaptor;
    }

    public WADISessionAdaptor(org.codehaus.wadi.core.session.Session session) {
        if (null == session) {
            throw new IllegalArgumentException("session is required");
        }
        this.session = session;
        session.getLocalStateMap().put(ADAPTOR_KEY, this);
    }

    public String getSessionId() {
        return this.session.getName();
    }

    public void release() {
        try {
            this.session.destroy();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot release session " + this.session, e);
        }
    }

    public Object addState(String key, Object value) {
        return this.session.addState((Object)key, value);
    }

    public Object getState(String key) {
        return this.session.getState((Object)key);
    }

    public Object removeState(String key) {
        return this.session.removeState((Object)key);
    }

    public Map getState() {
        return this.session.getState();
    }

    public void onEndAccess() {
        this.session.onEndProcessing();
    }
}

