/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.management.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.kernel.repository.WritableListableRepository;
import org.apache.geronimo.management.AppClientModule;
import org.apache.geronimo.management.EJBModule;
import org.apache.geronimo.management.J2EEDeployedObject;
import org.apache.geronimo.management.J2EEManagedObject;
import org.apache.geronimo.management.J2EEResource;
import org.apache.geronimo.management.geronimo.EJBManager;
import org.apache.geronimo.management.geronimo.J2EEApplication;
import org.apache.geronimo.management.geronimo.J2EEServer;
import org.apache.geronimo.management.geronimo.JMSManager;
import org.apache.geronimo.management.geronimo.JVM;
import org.apache.geronimo.management.geronimo.KeystoreManager;
import org.apache.geronimo.management.geronimo.LoginService;
import org.apache.geronimo.management.geronimo.ResourceAdapterModule;
import org.apache.geronimo.management.geronimo.SecurityRealm;
import org.apache.geronimo.management.geronimo.WebManager;
import org.apache.geronimo.management.geronimo.WebModule;
import org.apache.geronimo.system.plugin.PluginInstaller;
import org.apache.geronimo.system.plugin.PluginRepositoryList;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.system.threads.ThreadPool;

public class J2EEServerImpl
implements J2EEServer {
    private static final String SERVER_VENDOR = "The Apache Software Foundation";
    private final String objectName;
    private final ServerInfo serverInfo;
    private final Collection jvms;
    private final Collection resources;
    private final Collection j2eeApplications;
    private final Collection appClientModules;
    private final Collection webModules;
    private final Collection ejbModules;
    private final Collection resourceAdapterModules;
    private final Collection webManagers;
    private final Collection ejbManagers;
    private final Collection jmsManagers;
    private final Collection threadPools;
    private final Collection repositories;
    private final Collection pluginRepoLists;
    private final Collection writableRepos;
    private final Collection securityRealms;
    private final Collection loginServices;
    private final Collection keystoreManagers;
    private final PluginInstaller pluginInstaller;
    private final ConfigurationManager configurationManager;
    public static final GBeanInfo GBEAN_INFO;

    public J2EEServerImpl(String objectName, ServerInfo serverInfo, Collection jvms, Collection resources, Collection applications, Collection appClientModules, Collection webModules, Collection ejbModules, Collection resourceAdapterModules, Collection webManagers, Collection ejbManagers, Collection jmsManagers, Collection threadPools, Collection repositories, Collection writableRepos, Collection securityRealms, Collection loginServices, Collection keystoreManagers, PluginInstaller configurationInstaller, ConfigurationManager configurationManager, Collection pluginRepoLists) {
        this.objectName = objectName;
        ObjectName myObjectName = ObjectNameUtil.getObjectName((String)this.objectName);
        this.verifyObjectName(myObjectName);
        this.serverInfo = serverInfo;
        this.jvms = jvms;
        this.resources = resources;
        this.j2eeApplications = applications;
        this.appClientModules = appClientModules;
        this.webModules = webModules;
        this.ejbModules = ejbModules;
        this.resourceAdapterModules = resourceAdapterModules;
        this.webManagers = webManagers;
        this.ejbManagers = ejbManagers;
        this.jmsManagers = jmsManagers;
        this.threadPools = threadPools;
        this.repositories = repositories;
        this.writableRepos = writableRepos;
        this.securityRealms = securityRealms;
        this.loginServices = loginServices;
        this.keystoreManagers = keystoreManagers;
        this.pluginInstaller = configurationInstaller;
        this.configurationManager = configurationManager;
        this.pluginRepoLists = pluginRepoLists;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"J2EEServer".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("J2EEServer object name j2eeType property must be 'J2EEServer'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("J2EEServer object must contain a name property", objectName);
        }
        if (keyPropertyList.size() != 2) {
            throw new InvalidObjectNameException("J2EEServer object name can only have j2eeType, and name", objectName);
        }
    }

    public String[] getDeployedObjects() {
        return Util.getObjectNames((J2EEManagedObject[])this.getDeployedObjectInstances());
    }

    public J2EEDeployedObject[] getDeployedObjectInstances() {
        ArrayList objects = new ArrayList();
        if (this.j2eeApplications != null) {
            objects.addAll(this.j2eeApplications);
        }
        if (this.appClientModules != null) {
            objects.addAll(this.appClientModules);
        }
        if (this.ejbModules != null) {
            objects.addAll(this.ejbModules);
        }
        if (this.webModules != null) {
            objects.addAll(this.webModules);
        }
        if (this.resourceAdapterModules != null) {
            objects.addAll(this.resourceAdapterModules);
        }
        return objects.toArray(new J2EEDeployedObject[objects.size()]);
    }

    public String[] getResources() {
        return Util.getObjectNames((J2EEManagedObject[])this.getResourceInstances());
    }

    public J2EEResource[] getResourceInstances() {
        if (this.resources == null) {
            return new J2EEResource[0];
        }
        return this.resources.toArray(new J2EEResource[this.resources.size()]);
    }

    public String[] getJavaVMs() {
        return Util.getObjectNames((J2EEManagedObject[])this.getJavaVMInstances());
    }

    public JVM[] getJavaVMInstances() {
        if (this.jvms == null) {
            return new JVM[0];
        }
        return this.jvms.toArray(new JVM[this.jvms.size()]);
    }

    public J2EEApplication[] getApplications() {
        if (this.j2eeApplications == null) {
            return new J2EEApplication[0];
        }
        return this.j2eeApplications.toArray(new J2EEApplication[this.j2eeApplications.size()]);
    }

    public AppClientModule[] getAppClients() {
        if (this.appClientModules == null) {
            return new AppClientModule[0];
        }
        return this.appClientModules.toArray(new AppClientModule[this.appClientModules.size()]);
    }

    public WebModule[] getWebModules() {
        if (this.webModules == null) {
            return new WebModule[0];
        }
        return this.webModules.toArray(new WebModule[this.webModules.size()]);
    }

    public EJBModule[] getEJBModules() {
        if (this.ejbModules == null) {
            return new EJBModule[0];
        }
        return this.ejbModules.toArray(new EJBModule[this.ejbModules.size()]);
    }

    public ResourceAdapterModule[] getResourceAdapterModules() {
        if (this.resourceAdapterModules == null) {
            return new ResourceAdapterModule[0];
        }
        return this.resourceAdapterModules.toArray(new ResourceAdapterModule[this.resourceAdapterModules.size()]);
    }

    public WebManager[] getWebManagers() {
        if (this.webManagers == null) {
            return new WebManager[0];
        }
        return this.webManagers.toArray(new WebManager[this.webManagers.size()]);
    }

    public EJBManager[] getEJBManagers() {
        if (this.ejbManagers == null) {
            return new EJBManager[0];
        }
        return this.ejbManagers.toArray(new EJBManager[this.ejbManagers.size()]);
    }

    public JMSManager[] getJMSManagers() {
        if (this.jmsManagers == null) {
            return new JMSManager[0];
        }
        return this.jmsManagers.toArray(new JMSManager[this.jmsManagers.size()]);
    }

    public ThreadPool[] getThreadPools() {
        if (this.threadPools == null) {
            return new ThreadPool[0];
        }
        return this.threadPools.toArray(new ThreadPool[this.threadPools.size()]);
    }

    public ListableRepository[] getRepositories() {
        if (this.repositories == null) {
            return new ListableRepository[0];
        }
        return this.repositories.toArray(new ListableRepository[this.repositories.size()]);
    }

    public WritableListableRepository[] getWritableRepositories() {
        if (this.writableRepos == null) {
            return new WritableListableRepository[0];
        }
        return this.writableRepos.toArray(new WritableListableRepository[this.writableRepos.size()]);
    }

    public SecurityRealm[] getSecurityRealms() {
        if (this.securityRealms == null) {
            return new SecurityRealm[0];
        }
        return this.securityRealms.toArray(new SecurityRealm[this.securityRealms.size()]);
    }

    public PluginRepositoryList[] getPluginRepositoryLists() {
        if (this.pluginRepoLists == null) {
            return new PluginRepositoryList[0];
        }
        return this.pluginRepoLists.toArray(new PluginRepositoryList[this.pluginRepoLists.size()]);
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public LoginService getLoginService() {
        if (this.loginServices == null) {
            return null;
        }
        return (LoginService)this.loginServices.iterator().next();
    }

    public KeystoreManager getKeystoreManager() {
        if (this.keystoreManagers == null) {
            return null;
        }
        return (KeystoreManager)this.keystoreManagers.iterator().next();
    }

    public PluginInstaller getPluginInstaller() {
        return this.pluginInstaller;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public String getServerVendor() {
        return SERVER_VENDOR;
    }

    public String getServerVersion() {
        return this.serverInfo.getVersion();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)J2EEServerImpl.class, (String)"J2EEServer");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addReference("JVMs", JVM.class, "JVM");
        infoFactory.addReference("Resources", J2EEResource.class);
        infoFactory.addReference("Applications", J2EEApplication.class, "J2EEApplication");
        infoFactory.addReference("AppClientModules", AppClientModule.class, "AppClientModule");
        infoFactory.addReference("WebModules", WebModule.class, "WebModule");
        infoFactory.addReference("EJBModules", EJBModule.class, "EJBModule");
        infoFactory.addReference("ResourceAdapterModules", ResourceAdapterModule.class, "ResourceAdapterModule");
        infoFactory.addReference("WebManagers", WebManager.class);
        infoFactory.addReference("EJBManagers", EJBManager.class);
        infoFactory.addReference("JMSManagers", JMSManager.class);
        infoFactory.addReference("ThreadPools", ThreadPool.class);
        infoFactory.addReference("Repositories", ListableRepository.class);
        infoFactory.addReference("WritableRepos", WritableListableRepository.class);
        infoFactory.addReference("SecurityRealms", SecurityRealm.class);
        infoFactory.addReference("LoginServices", LoginService.class);
        infoFactory.addReference("KeystoreManagers", KeystoreManager.class);
        infoFactory.addReference("PluginInstaller", PluginInstaller.class);
        infoFactory.addReference("PluginRepoLists", PluginRepositoryList.class);
        infoFactory.addReference("ConfigurationManager", ConfigurationManager.class);
        infoFactory.setConstructor(new String[]{"objectName", "ServerInfo", "JVMs", "Resources", "Applications", "AppClientModules", "WebModules", "EJBModules", "ResourceAdapterModules", "WebManagers", "EJBManagers", "JMSManagers", "ThreadPools", "Repositories", "WritableRepos", "SecurityRealms", "LoginServices", "KeystoreManagers", "PluginInstaller", "ConfigurationManager", "PluginRepoLists"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

