/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.apache.geronimo.persistence.EntityManagerExtendedRegistry;
import org.apache.geronimo.persistence.InternalCMPEntityManagerExtended;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMPEntityManagerExtended
implements EntityManager {
    private final TransactionManagerImpl transactionManager;
    private final String persistenceUnit;
    private final EntityManagerFactory entityManagerFactory;
    private final Map entityManagerProperties;
    private final InternalCMPEntityManagerExtended entityManager;

    public CMPEntityManagerExtended(TransactionManagerImpl transactionManager, String persistenceUnit, EntityManagerFactory entityManagerFactory, Map entityManagerProperties) {
        this.transactionManager = transactionManager;
        this.persistenceUnit = persistenceUnit;
        this.entityManagerFactory = entityManagerFactory;
        this.entityManagerProperties = entityManagerProperties;
        this.entityManager = this.getEntityManager();
    }

    private InternalCMPEntityManagerExtended getEntityManager() {
        InternalCMPEntityManagerExtended entityManager = EntityManagerExtendedRegistry.getEntityManager(this.persistenceUnit);
        if (entityManager == null) {
            entityManager = this.createEntityManager();
            EntityManagerExtendedRegistry.putEntityManager(this.persistenceUnit, entityManager);
        }
        entityManager.registerBean();
        return entityManager;
    }

    private InternalCMPEntityManagerExtended createEntityManager() {
        EntityManager entityManager = this.entityManagerProperties == null ? this.entityManagerFactory.createEntityManager() : this.entityManagerFactory.createEntityManager(this.entityManagerProperties);
        return new InternalCMPEntityManagerExtended(entityManager, this.persistenceUnit, this.transactionManager);
    }

    public void beanRemoved() {
        this.entityManager.beanRemoved();
    }

    public void persist(Object o) {
        this.entityManager.persist(o);
    }

    public <T> T merge(T t) {
        return this.entityManager.merge(t);
    }

    public void remove(Object o) {
        this.entityManager.remove(o);
    }

    public <T> T find(Class<T> aClass, Object o) {
        return this.entityManager.find(aClass, o);
    }

    public <T> T getReference(Class<T> aClass, Object o) {
        return this.entityManager.getReference(aClass, o);
    }

    public void flush() {
        this.entityManager.flush();
    }

    public void setFlushMode(FlushModeType flushModeType) {
        this.entityManager.setFlushMode(flushModeType);
    }

    public FlushModeType getFlushMode() {
        return this.entityManager.getFlushMode();
    }

    public void lock(Object o, LockModeType lockModeType) {
        this.entityManager.lock(o, lockModeType);
    }

    public void refresh(Object o) {
        this.entityManager.refresh(o);
    }

    public void clear() {
        this.entityManager.clear();
    }

    public boolean contains(Object o) {
        return this.entityManager.contains(o);
    }

    public Query createQuery(String s) {
        return this.entityManager.createQuery(s);
    }

    public Query createNamedQuery(String s) {
        return this.entityManager.createNamedQuery(s);
    }

    public Query createNativeQuery(String s) {
        return this.entityManager.createNativeQuery(s);
    }

    public Query createNativeQuery(String s, Class aClass) {
        return this.entityManager.createNativeQuery(s, aClass);
    }

    public Query createNativeQuery(String s, String s1) {
        return this.entityManager.createNativeQuery(s, s1);
    }

    public void close() {
        throw new IllegalStateException("You cannot call close on a Container Managed Entity Manager");
    }

    public boolean isOpen() {
        return true;
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("You cannot call getTransaction on a container managed EntityManager");
    }

    public void joinTransaction() {
        throw new IllegalStateException("You cannot call joinTransaction on a container managed EntityManager");
    }

    public Object getDelegate() {
        return this.entityManager.getDelegate();
    }
}

