/**
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.geronimo.security.jaas;

/**
 * @version $Rev: 487175 $ $Date: 2006-12-14 03:10:31 -0800 (Thu, 14 Dec 2006) $
 */
public class NamedUsernamePasswordCredential extends UsernamePasswordCredential{

    private final String name;

    public NamedUsernamePasswordCredential(String username, char[] password, String name) {
        super(username, password);
        this.name = name;
        if (name == null) {
            throw new IllegalStateException("Must supply a name");
        }
    }

    public String getName() {
        return name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NamedUsernamePasswordCredential)) {
            return false;
        }
        return super.equals(o) && name.equals(((NamedUsernamePasswordCredential)o).name);
    }

    public int hashCode() {
        return name.hashCode() * 37 ^ super.hashCode();
    }

}
