/**
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.apache.geronimo.security.remoting.jmx;

import java.io.IOException;
import java.io.Serializable;

import org.activeio.Packet;
import org.activeio.RequestListener;
import org.activeio.packet.EmptyPacket;

import org.apache.geronimo.interceptor.Interceptor;
import org.apache.geronimo.interceptor.Invocation;
import org.apache.geronimo.interceptor.InvocationResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @version $Rev: 487175 $ $Date: 2006-12-14 03:10:31 -0800 (Thu, 14 Dec 2006) $
 */
public class RequestChannelInterceptorInvoker implements RequestListener {

    private static final Log log = LogFactory.getLog(RequestChannelInterceptorInvoker.class);

    private ClassLoader classloader;
    private Interceptor next;

    public RequestChannelInterceptorInvoker(Interceptor next, ClassLoader classloader) {
        this.next = next;
        this.classloader = classloader;
    }

    public static class ThrowableWrapper implements Serializable {
        private static final long serialVersionUID = 3905243428970182455L;
        ThrowableWrapper(Throwable exception) {
            this.exception = exception;
        }
        public Throwable exception;
    }

    public ClassLoader getClassloader() {
        return classloader;
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public Packet onRequest(Packet request) {
        Thread currentThread = Thread.currentThread();
        ClassLoader orig = currentThread.getContextClassLoader();
        try {

            Invocation marshalledInvocation;

            try {
                currentThread.setContextClassLoader(classloader);
                marshalledInvocation = (Invocation) RequestChannelInterceptor.deserialize(request,classloader);
            } catch (Throwable e) {
                // Could not deserialize the invocation...
                log.error("Could not deserialize the invocation", e);
                return RequestChannelInterceptor.serialize(new ThrowableWrapper(e));
            }

            try {
                InvocationResult rc = next.invoke(marshalledInvocation);
                return RequestChannelInterceptor.serialize(rc);
            } catch (Throwable e) {
                return RequestChannelInterceptor.serialize(new ThrowableWrapper(e));
            }


        } catch (IOException e) {
            // TODO: handle this.
            return EmptyPacket.EMPTY_PACKET;
        } finally {
            currentThread.setContextClassLoader(orig);
        }
    }

    public void onRquestError(IOException error) {
        log.error("Request Error", error);
    }

}
