/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.ca;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.management.geronimo.CertificateRequestStore;
import org.apache.geronimo.management.geronimo.CertificateStore;
import org.apache.geronimo.management.geronimo.CertificateStoreException;
import org.apache.geronimo.management.geronimo.CertificationAuthority;
import org.apache.geronimo.management.geronimo.CertificationAuthorityException;
import org.apache.geronimo.management.geronimo.KeystoreException;
import org.apache.geronimo.management.geronimo.KeystoreInstance;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.util.CaUtils;
import org.apache.geronimo.util.asn1.ASN1InputStream;
import org.apache.geronimo.util.asn1.DERBitString;
import org.apache.geronimo.util.asn1.DEREncodable;
import org.apache.geronimo.util.asn1.DEREncodableVector;
import org.apache.geronimo.util.asn1.DERInteger;
import org.apache.geronimo.util.asn1.DERObject;
import org.apache.geronimo.util.asn1.DERSequence;
import org.apache.geronimo.util.asn1.pkcs.PKCSObjectIdentifiers;
import org.apache.geronimo.util.asn1.x509.AlgorithmIdentifier;
import org.apache.geronimo.util.asn1.x509.SubjectPublicKeyInfo;
import org.apache.geronimo.util.asn1.x509.TBSCertificateStructure;
import org.apache.geronimo.util.asn1.x509.Time;
import org.apache.geronimo.util.asn1.x509.V3TBSCertificateGenerator;
import org.apache.geronimo.util.asn1.x509.X509Name;

public class GeronimoCertificationAuthority
implements CertificationAuthority,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)GeronimoCertificationAuthority.class);
    private ServerInfo serverInfo;
    private Kernel kernel;
    private AbstractName abstractName;
    private KeystoreInstance caKeystore = null;
    private CertificateStore certStore = null;
    private char[] password;
    private CertificateRequestStore certReqStore = null;
    private String alias;
    private PrivateKey caPrivateKey;
    private PublicKey caPublicKey;
    private Certificate caCert;
    private X509Name caName;
    public static final GBeanInfo GBEAN_INFO;

    public GeronimoCertificationAuthority(ServerInfo serverInfo, KeystoreInstance caKeystore, CertificateStore certStore, CertificateRequestStore certReqStore, Kernel kernel, AbstractName abstractName) {
        if (caKeystore == null) {
            throw new IllegalArgumentException("caKeystore is null.");
        }
        if (certStore == null) {
            throw new IllegalArgumentException("certStore is null");
        }
        if (certReqStore == null) {
            throw new IllegalArgumentException("certReqStore is null");
        }
        this.serverInfo = serverInfo;
        this.kernel = kernel;
        this.abstractName = abstractName;
        this.caKeystore = caKeystore;
        this.certStore = certStore;
        this.certReqStore = certReqStore;
    }

    public boolean isLocked() {
        return this.password == null;
    }

    public void lock() {
        try {
            this.caKeystore.lockKeystore(this.password);
        }
        catch (KeystoreException e) {
            log.error((Object)"Error locking CA.", (Throwable)e);
        }
        this.password = null;
        this.caName = null;
        this.caCert = null;
        this.caPrivateKey = null;
        this.alias = null;
    }

    public void unlock(char[] password) throws CertificationAuthorityException {
        try {
            this.password = password;
            this.caKeystore.unlockKeystore(password);
            this.alias = this.caKeystore.listPrivateKeys(password)[0];
            this.caKeystore.unlockPrivateKey(this.alias, password, password);
            this.caCert = this.caKeystore.getCertificate(this.alias, password);
            this.caName = CaUtils.getSubjectX509Name((Certificate)this.caCert);
            this.caPrivateKey = this.caKeystore.getPrivateKey(this.alias, password, password);
            this.caPublicKey = this.caCert.getPublicKey();
        }
        catch (Exception e) {
            throw new CertificationAuthorityException("Errors in unlocking CA.", (Throwable)e);
        }
    }

    public X500Principal getName() throws CertificationAuthorityException {
        if (this.isLocked()) {
            throw new CertificationAuthorityException("CA is locked.");
        }
        try {
            return new X500Principal(this.caName.getEncoded());
        }
        catch (IOException e) {
            throw new CertificationAuthorityException("Error in getting CA name.", (Throwable)e);
        }
    }

    public Certificate getCertificate() throws CertificationAuthorityException {
        if (this.caCert == null) {
            throw new CertificationAuthorityException("CA Certificate is null. CA may be locked.");
        }
        try {
            this.caCert = this.caKeystore.getCertificate(this.alias, this.password);
            return this.caCert;
        }
        catch (KeystoreException e) {
            log.error((Object)"Error getting CA's certificate.", (Throwable)e);
            return null;
        }
    }

    public void issueOwnCertificate(BigInteger sNo, Date validFromDate, Date validToDate, String algorithm) throws CertificationAuthorityException {
        if (this.isLocked()) {
            throw new CertificationAuthorityException("CA is locked.");
        }
        try {
            PublicKey publicKey = this.caCert.getPublicKey();
            Certificate cert = this.issueCertificate(this.getName(), publicKey, sNo, validFromDate, validToDate, algorithm);
            this.caKeystore.importPKCS7Certificate(this.alias, CaUtils.base64Certificate((Certificate)cert), this.password);
            this.caCert = cert;
        }
        catch (Exception e) {
            throw new CertificationAuthorityException("Error in issuing own certificate.", (Throwable)e);
        }
    }

    public Certificate issueCertificate(X500Principal subject, PublicKey publicKey, BigInteger sNo, Date validFromDate, Date validToDate, String algorithm) throws CertificationAuthorityException {
        if (this.isLocked()) {
            throw new CertificationAuthorityException("CA is locked.");
        }
        try {
            X509Name subName = CaUtils.getX509Name((X500Principal)subject);
            Certificate cert = this.issueCertificate(subName, this.caName, sNo, publicKey, this.caPrivateKey, validFromDate, validToDate, algorithm);
            cert.verify(this.caPublicKey);
            this.certStore.storeCertificate(cert);
            return cert;
        }
        catch (Exception e) {
            throw new CertificationAuthorityException("Error in issuing certificate.", (Throwable)e);
        }
    }

    public BigInteger getHighestSerialNumber() throws CertificationAuthorityException {
        if (this.isLocked()) {
            throw new CertificationAuthorityException("CA is locked.");
        }
        try {
            return this.certStore.getHighestSerialNumber();
        }
        catch (CertificateStoreException e) {
            throw new CertificationAuthorityException("Error in getting highest serial number for CA.", (Throwable)e);
        }
    }

    public boolean isCertificateIssued(BigInteger sNo) throws CertificationAuthorityException {
        if (this.isLocked()) {
            throw new CertificationAuthorityException("CA is locked.");
        }
        return this.certStore.containsCertificate(sNo);
    }

    public BigInteger getNextSerialNumber() throws CertificationAuthorityException {
        if (this.isLocked()) {
            throw new CertificationAuthorityException("CA is locked.");
        }
        try {
            return this.certStore.getNextSerialNumber();
        }
        catch (CertificateStoreException e) {
            throw new CertificationAuthorityException("Error in getting next serial number for CA.", (Throwable)e);
        }
    }

    public Certificate getCertificate(BigInteger sNo) throws CertificationAuthorityException {
        if (this.isLocked()) {
            throw new CertificationAuthorityException("CA is locked.");
        }
        try {
            return this.certStore.getCertificate(sNo);
        }
        catch (CertificateStoreException e) {
            throw new CertificationAuthorityException("Error getting certificate. serial number = " + sNo, (Throwable)e);
        }
    }

    public String getCertificateBase64Text(BigInteger sNo) throws CertificationAuthorityException {
        if (this.isLocked()) {
            throw new CertificationAuthorityException("CA is locked.");
        }
        try {
            return this.certStore.getCertificateBase64Text(sNo);
        }
        catch (CertificateStoreException e) {
            throw new CertificationAuthorityException("Error getting certificate. serial number = " + sNo, (Throwable)e);
        }
    }

    private Certificate issueCertificate(X509Name subName, X509Name caName, BigInteger serialNum, PublicKey subPubKey, PrivateKey caPriKey, Date validFromDate, Date validToDate, String algorithm) throws Exception {
        AlgorithmIdentifier algId = null;
        if ("MD2withRSA".equalsIgnoreCase(algorithm)) {
            algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.md2WithRSAEncryption);
        } else if ("MD5withRSA".equalsIgnoreCase(algorithm)) {
            algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption);
        } else if ("SHA1withRSA".equalsIgnoreCase(algorithm)) {
            algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption);
        } else {
            throw new CertificationAuthorityException("Signature algorithm " + algorithm + " is not supported.");
        }
        ASN1InputStream ais = new ASN1InputStream(subPubKey.getEncoded());
        DERObject subPubkeyDerObj = ais.readObject();
        SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)subPubkeyDerObj);
        V3TBSCertificateGenerator v3certGen = new V3TBSCertificateGenerator();
        v3certGen.setSubject(subName);
        v3certGen.setSubjectPublicKeyInfo(subPubKeyInfo);
        v3certGen.setIssuer(caName);
        v3certGen.setSerialNumber(new DERInteger(serialNum));
        v3certGen.setStartDate(new Time(validFromDate));
        v3certGen.setEndDate(new Time(validToDate));
        v3certGen.setSignature(algId);
        TBSCertificateStructure tbsCert = v3certGen.generateTBSCertificate();
        byte[] tobesigned = tbsCert.getEncoded();
        Signature signatureObj = Signature.getInstance(algorithm);
        signatureObj.initSign(caPriKey);
        signatureObj.update(tobesigned);
        byte[] signature = signatureObj.sign();
        DEREncodableVector certDerVec = new DEREncodableVector();
        certDerVec.add((DEREncodable)tbsCert);
        certDerVec.add((DEREncodable)algId);
        certDerVec.add((DEREncodable)new DERBitString(signature));
        DERSequence certDerSeq = new DERSequence(certDerVec);
        byte[] certData = certDerSeq.getEncoded();
        Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certData));
        return certificate;
    }

    public void doFail() {
    }

    public void doStart() throws Exception {
        if (this.caKeystore.isKeystoreLocked()) {
            this.lock();
        }
    }

    public void doStop() throws Exception {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)GeronimoCertificationAuthority.class, (String)"CertificationAuthority");
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("abstractName", AbstractName.class, false);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addReference("KeystoreInstance", KeystoreInstance.class, "Keystore");
        infoFactory.addReference("CertificateStore", CertificateStore.class, "CertificateStore");
        infoFactory.addReference("CertificateRequestStore", CertificateRequestStore.class, "CertificateRequestStore");
        infoFactory.addInterface(CertificationAuthority.class);
        infoFactory.setConstructor(new String[]{"ServerInfo", "KeystoreInstance", "CertificateStore", "CertificateRequestStore", "kernel", "abstractName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

