/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jacc;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.IdentificationPrincipal;
import org.apache.geronimo.security.SubjectId;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.security.jacc.PrincipalRoleMapper;

public class ApplicationPolicyConfigurationManager
implements GBeanLifecycle {
    private final Map contextIdToPolicyConfigurationMap = new HashMap();
    private final Map roleDesignates;
    private final PrincipalRoleMapper principalRoleMapper;
    public static final GBeanInfo GBEAN_INFO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationPolicyConfigurationManager(Map contextIdToPermissionsMap, Map roleDesignates, ClassLoader cl, PrincipalRoleMapper principalRoleMapper) throws PolicyContextException, ClassNotFoundException {
        PolicyConfiguration policyConfiguration;
        PolicyConfigurationFactory policyConfigurationFactory;
        this.principalRoleMapper = principalRoleMapper;
        Thread currentThread = Thread.currentThread();
        ClassLoader oldClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(cl);
        try {
            policyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        finally {
            currentThread.setContextClassLoader(oldClassLoader);
        }
        Iterator iterator = contextIdToPermissionsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String contextID = (String)entry.getKey();
            ComponentPermissions componentPermissions = (ComponentPermissions)entry.getValue();
            PolicyConfiguration policyConfiguration2 = policyConfigurationFactory.getPolicyConfiguration(contextID, true);
            this.contextIdToPolicyConfigurationMap.put(contextID, policyConfiguration2);
            policyConfiguration2.addToExcludedPolicy(componentPermissions.getExcludedPermissions());
            policyConfiguration2.addToUncheckedPolicy(componentPermissions.getUncheckedPermissions());
            Iterator roleIterator = componentPermissions.getRolePermissions().entrySet().iterator();
            while (roleIterator.hasNext()) {
                Map.Entry roleEntry = roleIterator.next();
                String roleName = (String)roleEntry.getKey();
                PermissionCollection rolePermissions = (PermissionCollection)roleEntry.getValue();
                Enumeration<Permission> permissions = rolePermissions.elements();
                while (permissions.hasMoreElements()) {
                    Permission permission = permissions.nextElement();
                    policyConfiguration2.addToRole(roleName, permission);
                }
            }
        }
        if (principalRoleMapper != null) {
            principalRoleMapper.install(contextIdToPermissionsMap.keySet());
        }
        iterator = this.contextIdToPolicyConfigurationMap.values().iterator();
        while (iterator.hasNext()) {
            policyConfiguration = (PolicyConfiguration)iterator.next();
            Iterator iterator2 = this.contextIdToPolicyConfigurationMap.values().iterator();
            while (iterator2.hasNext()) {
                PolicyConfiguration policyConfiguration2 = (PolicyConfiguration)iterator2.next();
                if (policyConfiguration == policyConfiguration2) continue;
                policyConfiguration.linkConfiguration(policyConfiguration2);
            }
        }
        iterator = this.contextIdToPolicyConfigurationMap.values().iterator();
        while (iterator.hasNext()) {
            policyConfiguration = (PolicyConfiguration)iterator.next();
            policyConfiguration.commit();
        }
        Policy policy = Policy.getPolicy();
        policy.refresh();
        Iterator iterator2 = roleDesignates.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            Subject roleDesignate = (Subject)entry.getValue();
            ContextManager.registerSubject(roleDesignate);
            SubjectId id = ContextManager.getSubjectId(roleDesignate);
            roleDesignate.getPrincipals().add(new IdentificationPrincipal(id));
        }
        this.roleDesignates = roleDesignates;
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        Iterator iterator = this.roleDesignates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Subject roleDesignate = (Subject)entry.getValue();
            ContextManager.unregisterSubject(roleDesignate);
        }
        if (this.principalRoleMapper != null) {
            this.principalRoleMapper.uninstall();
        }
        iterator = this.contextIdToPolicyConfigurationMap.values().iterator();
        while (iterator.hasNext()) {
            PolicyConfiguration policyConfiguration = (PolicyConfiguration)iterator.next();
            policyConfiguration.delete();
        }
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)ApplicationPolicyConfigurationManager.class, (String)"JACCManager");
        infoBuilder.addAttribute("contextIdToPermissionsMap", Map.class, true);
        infoBuilder.addAttribute("roleDesignates", Map.class, true);
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addReference("PrincipalRoleMapper", PrincipalRoleMapper.class, "JACCManager");
        infoBuilder.setConstructor(new String[]{"contextIdToPermissionsMap", "roleDesignates", "classLoader", "PrincipalRoleMapper"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

