/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.security.deploy.PrincipalInfo;
import org.apache.geronimo.security.jaas.ConfigurationEntryFactory;
import org.apache.geronimo.security.jaas.JaasLoginModuleChain;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.jaas.LoginModuleControlFlag;
import org.apache.geronimo.security.jaas.client.JaasLoginCoordinator;
import org.apache.geronimo.security.jaas.server.JaasLoginModuleConfiguration;
import org.apache.geronimo.security.jaas.server.JaasLoginServiceMBean;
import org.apache.geronimo.security.realm.SecurityRealm;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class GenericSecurityRealm
implements SecurityRealm,
ConfigurationEntryFactory {
    private final JaasLoginServiceMBean loginService;
    private final String realmName;
    private JaasLoginModuleConfiguration[] config;
    private final Kernel kernel;
    private final PrincipalInfo defaultPrincipalInfo;
    private String[] domains;
    private final boolean restrictPrincipalsToServer;
    private final boolean wrapPrincipals;
    private final JaasLoginModuleUse loginModuleUse;
    public static final GBeanInfo GBEAN_INFO;

    public GenericSecurityRealm(String realmName, JaasLoginModuleUse loginModuleUse, boolean restrictPrincipalsToServer, boolean wrapPrincipals, PrincipalInfo defaultPrincipalInfo, ServerInfo serverInfo, ClassLoader classLoader, Kernel kernel, JaasLoginServiceMBean loginService) {
        this.realmName = realmName;
        this.kernel = kernel;
        this.restrictPrincipalsToServer = restrictPrincipalsToServer;
        this.wrapPrincipals = wrapPrincipals;
        this.defaultPrincipalInfo = defaultPrincipalInfo;
        this.loginService = loginService;
        this.loginModuleUse = loginModuleUse;
        HashSet domainNames = new HashSet();
        ArrayList loginModuleConfigurations = new ArrayList();
        if (loginModuleUse != null) {
            loginModuleUse.configure(domainNames, loginModuleConfigurations, kernel, serverInfo, classLoader);
        }
        this.domains = domainNames.toArray(new String[domainNames.size()]);
        this.config = loginModuleConfigurations.toArray(new JaasLoginModuleConfiguration[loginModuleConfigurations.size()]);
    }

    public String getRealmName() {
        return this.realmName;
    }

    public JaasLoginModuleConfiguration[] getAppConfigurationEntries() {
        return this.config;
    }

    public JaasLoginModuleChain getLoginModuleChain() {
        return this.loginModuleUse;
    }

    public String[] getLoginDomains() {
        return this.domains;
    }

    public PrincipalInfo getDefaultPrincipal() {
        return this.defaultPrincipalInfo;
    }

    public boolean isRestrictPrincipalsToServer() {
        return this.restrictPrincipalsToServer;
    }

    public boolean isWrapPrincipals() {
        return this.wrapPrincipals;
    }

    public String getConfigurationName() {
        return this.realmName;
    }

    public JaasLoginModuleConfiguration generateConfiguration() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("realm", this.realmName);
        if (this.kernel != null) {
            options.put("kernel", this.kernel.getKernelName());
            if (this.loginService != null) {
                options.put("serviceName", this.loginService.getObjectName());
            }
        } else if (this.loginService != null) {
            options.put("serviceInstance", this.loginService);
        }
        return new JaasLoginModuleConfiguration(JaasLoginCoordinator.class.getName(), LoginModuleControlFlag.REQUIRED, options, true, this.realmName, this.wrapPrincipals, JaasLoginCoordinator.class.getClassLoader());
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)GenericSecurityRealm.class, (String)"SecurityRealm");
        infoFactory.addInterface(SecurityRealm.class);
        infoFactory.addInterface(ConfigurationEntryFactory.class);
        infoFactory.addAttribute("realmName", String.class, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("defaultPrincipal", PrincipalInfo.class, true);
        infoFactory.addAttribute("deploymentSupport", Properties.class, true);
        infoFactory.addAttribute("restrictPrincipalsToServer", Boolean.TYPE, true);
        infoFactory.addAttribute("wrapPrincipals", Boolean.TYPE, true);
        infoFactory.addReference("LoginModuleConfiguration", JaasLoginModuleUse.class, "LoginModuleUse");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addReference("LoginService", JaasLoginServiceMBean.class, "JaasLoginService");
        infoFactory.addOperation("getAppConfigurationEntries", new Class[0]);
        infoFactory.setConstructor(new String[]{"realmName", "LoginModuleConfiguration", "restrictPrincipalsToServer", "wrapPrincipals", "defaultPrincipal", "ServerInfo", "classLoader", "kernel", "LoginService"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

