/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.remoting.jmx;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.geronimo.kernel.ClassLoading;

public class MarshalledMethod
implements Serializable {
    String declaringClass;
    String signature;
    private static Map SignatureMapCache = Collections.synchronizedMap(new WeakHashMap());

    public MarshalledMethod() {
    }

    public MarshalledMethod(Method method) {
        this.declaringClass = method.getDeclaringClass().getName();
        this.signature = MarshalledMethod.getSignature(method);
    }

    public static String getSignature(Method method) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getName());
        sb.append(' ');
        Class<?>[] args = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            sb.append(' ');
            sb.append(ClassLoading.getClassName(args[i]));
        }
        return sb.toString();
    }

    public Method getMethod() throws ClassNotFoundException {
        Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(this.declaringClass);
        Map sigs = MarshalledMethod.getCachedSignatureMap(c);
        return (Method)sigs.get(this.signature);
    }

    private static Map getSignatureMapFor(Class clazz) {
        HashMap<String, Method> rc = new HashMap<String, Method>();
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            rc.put(MarshalledMethod.getSignature(method), method);
        }
        return rc;
    }

    public static Map getCachedSignatureMap(Class clazz) {
        String cacheKey = clazz.getName();
        CacheValue rc = (CacheValue)SignatureMapCache.get(cacheKey);
        if (rc == null) {
            rc = new CacheValue();
            rc.clazz = clazz;
            rc.sigs = MarshalledMethod.getSignatureMapFor(clazz);
            SignatureMapCache.put(cacheKey, rc);
            return rc.sigs;
        }
        if (rc.clazz.equals(clazz)) {
            return rc.sigs;
        }
        return MarshalledMethod.getSignatureMapFor(clazz);
    }

    static class CacheValue {
        Class clazz;
        Map sigs;

        CacheValue() {
        }
    }
}

