/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.remoting.jmx;

import java.io.IOException;
import java.io.Serializable;
import org.activeio.Packet;
import org.activeio.RequestListener;
import org.activeio.packet.EmptyPacket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.interceptor.Interceptor;
import org.apache.geronimo.interceptor.Invocation;
import org.apache.geronimo.interceptor.InvocationResult;
import org.apache.geronimo.security.remoting.jmx.RequestChannelInterceptor;

public class RequestChannelInterceptorInvoker
implements RequestListener {
    private static final Log log = LogFactory.getLog((Class)RequestChannelInterceptorInvoker.class);
    private ClassLoader classloader;
    private Interceptor next;

    public RequestChannelInterceptorInvoker(Interceptor next, ClassLoader classloader) {
        this.next = next;
        this.classloader = classloader;
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet onRequest(Packet request) {
        Thread currentThread = Thread.currentThread();
        ClassLoader orig = currentThread.getContextClassLoader();
        try {
            Invocation marshalledInvocation;
            try {
                currentThread.setContextClassLoader(this.classloader);
                marshalledInvocation = (Invocation)RequestChannelInterceptor.deserialize(request, this.classloader);
            }
            catch (Throwable e) {
                log.error((Object)"Could not deserialize the invocation", e);
                Packet packet = RequestChannelInterceptor.serialize(new ThrowableWrapper(e));
                currentThread.setContextClassLoader(orig);
                return packet;
            }
            InvocationResult rc = this.next.invoke(marshalledInvocation);
            Packet packet = RequestChannelInterceptor.serialize(rc);
            return packet;
        }
        catch (IOException e) {
            EmptyPacket emptyPacket = EmptyPacket.EMPTY_PACKET;
            return emptyPacket;
        }
        finally {
            currentThread.setContextClassLoader(orig);
        }
    }

    public void onRquestError(IOException error) {
        log.error((Object)"Request Error", (Throwable)error);
    }

    public static class ThrowableWrapper
    implements Serializable {
        private static final long serialVersionUID = 3905243428970182455L;
        public Throwable exception;

        ThrowableWrapper(Throwable exception) {
            this.exception = exception;
        }
    }
}

