/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jacc;

import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyContextException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.security.jacc.GeronimoPolicyConfiguration;
import org.apache.geronimo.security.jacc.GeronimoPolicyConfigurationFactory;
import org.apache.geronimo.security.jacc.PrincipalRoleMapper;

public class ApplicationPrincipalRoleConfigurationManager
implements PrincipalRoleMapper {
    private final Map principalRoleMap;
    public static final GBeanInfo GBEAN_INFO;

    public ApplicationPrincipalRoleConfigurationManager(Map principalRoleMap) throws PolicyContextException, ClassNotFoundException {
        this.principalRoleMap = principalRoleMap;
    }

    public void install(Set contextIds) throws PolicyContextException {
        GeronimoPolicyConfigurationFactory roleMapperFactory = GeronimoPolicyConfigurationFactory.getSingleton();
        if (roleMapperFactory == null) {
            throw new IllegalStateException("Inconsistent security setup.  GeronimoPolicyConfigurationFactory is not being used");
        }
        for (String contextID : contextIds) {
            GeronimoPolicyConfiguration geronimoPolicyConfiguration = roleMapperFactory.getGeronimoPolicyConfiguration(contextID);
            geronimoPolicyConfiguration.setPrincipalRoleMapping(this.principalRoleMap);
        }
    }

    public void uninstall() throws PolicyContextException {
    }

    public GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(ApplicationPrincipalRoleConfigurationManager.class, (String)"JACCManager");
        infoBuilder.addAttribute("principalRoleMap", Map.class, true);
        infoBuilder.addInterface(PrincipalRoleMapper.class);
        infoBuilder.setConstructor(new String[]{"principalRoleMap"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

