/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.security.jaas.ConfigurationEntryFactory;
import org.apache.geronimo.security.jaas.JaasLoginModuleChain;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.realm.SecurityRealm;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class GenericSecurityRealm
implements SecurityRealm,
ConfigurationEntryFactory {
    private final String realmName;
    private AppConfigurationEntry[] config;
    private String[] domains;
    private final boolean wrapPrincipals;
    private final JaasLoginModuleUse loginModuleUse;
    public static final GBeanInfo GBEAN_INFO;

    public GenericSecurityRealm(String realmName, JaasLoginModuleUse loginModuleUse, boolean wrapPrincipals, ServerInfo serverInfo, ClassLoader classLoader, Kernel kernel) throws ClassNotFoundException {
        this.realmName = realmName;
        this.wrapPrincipals = wrapPrincipals;
        this.loginModuleUse = loginModuleUse;
        HashSet<String> domainNames = new HashSet<String>();
        ArrayList<AppConfigurationEntry> loginModuleConfigurations = new ArrayList<AppConfigurationEntry>();
        if (loginModuleUse != null) {
            loginModuleUse.configure(domainNames, loginModuleConfigurations, realmName, kernel, serverInfo, classLoader);
        }
        this.domains = domainNames.toArray(new String[domainNames.size()]);
        this.config = loginModuleConfigurations.toArray(new AppConfigurationEntry[loginModuleConfigurations.size()]);
    }

    public String getRealmName() {
        return this.realmName;
    }

    public AppConfigurationEntry[] getAppConfigurationEntries() {
        return this.config;
    }

    public JaasLoginModuleChain getLoginModuleChain() {
        return this.loginModuleUse;
    }

    public String[] getLoginDomains() {
        return this.domains;
    }

    public boolean isWrapPrincipals() {
        return this.wrapPrincipals;
    }

    public String getConfigurationName() {
        return this.realmName;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(GenericSecurityRealm.class, (String)"SecurityRealm");
        infoFactory.addInterface(SecurityRealm.class);
        infoFactory.addInterface(ConfigurationEntryFactory.class);
        infoFactory.addAttribute("realmName", String.class, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("deploymentSupport", Properties.class, true);
        infoFactory.addAttribute("wrapPrincipals", Boolean.TYPE, true);
        infoFactory.addReference("LoginModuleConfiguration", JaasLoginModuleUse.class, "LoginModuleUse");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.setConstructor(new String[]{"realmName", "LoginModuleConfiguration", "wrapPrincipals", "ServerInfo", "classLoader", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

