/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.service;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;
import org.apache.geronimo.deployment.javabean.xbeans.BeanPropertyType;
import org.apache.geronimo.deployment.javabean.xbeans.JavabeanType;
import org.apache.geronimo.deployment.javabean.xbeans.PropertyType;
import org.apache.geronimo.deployment.service.XmlAttributeBuilder;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.xmlbeans.XmlObject;

public class JavaBeanXmlAttributeBuilder
implements XmlAttributeBuilder {
    private static final String NAMESPACE = "http://geronimo.apache.org/xml/ns/deployment/javabean-1.0";
    public static final GBeanInfo GBEAN_INFO;

    public String getNamespace() {
        return NAMESPACE;
    }

    public Object getValue(XmlObject xmlObject, String type, ClassLoader cl) throws DeploymentException {
        JavabeanType javabean = (JavabeanType)xmlObject.copy().changeType(JavabeanType.type);
        return this.getValue(javabean, type, cl);
    }

    private Object getValue(JavabeanType javabean, String className, ClassLoader cl) throws DeploymentException {
        Method m;
        Object value;
        PropertyDescriptor[] propertyDescriptors;
        Class<?> clazz = null;
        try {
            clazz = cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load alleged javabean class " + className, (Throwable)e);
        }
        Object instance = null;
        try {
            instance = clazz.newInstance();
        }
        catch (Exception e) {
            throw new DeploymentException("Could not create java bean instance", (Throwable)e);
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            propertyDescriptors = beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new DeploymentException("Could not analyze java bean class", (Throwable)e);
        }
        PropertyType[] properties = javabean.getPropertyArray();
        block12: for (int i = 0; i < properties.length; ++i) {
            PropertyType property = properties[i];
            String propertyName = Introspector.decapitalize(property.getName());
            String propertyString = property.getStringValue().trim();
            for (int j = 0; j < propertyDescriptors.length; ++j) {
                PropertyDescriptor propertyDescriptor = propertyDescriptors[j];
                if (!propertyName.equals(propertyDescriptor.getName())) continue;
                String type = propertyDescriptor.getPropertyType().getName();
                PropertyEditor propertyEditor = null;
                try {
                    propertyEditor = PropertyEditors.findEditor((String)type, (ClassLoader)cl);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException("Could not load editor for type " + type, (Throwable)e);
                }
                if (propertyEditor == null) {
                    throw new DeploymentException("Unable to find PropertyEditor for " + type);
                }
                propertyEditor.setAsText(propertyString);
                value = propertyEditor.getValue();
                m = propertyDescriptor.getWriteMethod();
                try {
                    m.invoke(instance, value);
                    continue block12;
                }
                catch (Exception e) {
                    throw new DeploymentException("Could not set property value for property named " + propertyName, (Throwable)e);
                }
            }
        }
        BeanPropertyType[] beanProperties = javabean.getBeanPropertyArray();
        block14: for (int i = 0; i < beanProperties.length; ++i) {
            BeanPropertyType beanProperty = beanProperties[i];
            String propertyName = Introspector.decapitalize(beanProperty.getName().trim());
            JavabeanType innerBean = beanProperty.getJavabean();
            for (int j = 0; j < propertyDescriptors.length; ++j) {
                PropertyDescriptor propertyDescriptor = propertyDescriptors[j];
                if (!propertyName.equals(propertyDescriptor.getName())) continue;
                String propertyType = propertyDescriptor.getPropertyType().getName();
                value = this.getValue(innerBean, propertyType, cl);
                m = propertyDescriptor.getWriteMethod();
                try {
                    m.invoke(instance, value);
                    continue block14;
                }
                catch (Exception e) {
                    throw new DeploymentException("Could not set property value for property named " + propertyName, (Throwable)e);
                }
            }
        }
        return instance;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(JavaBeanXmlAttributeBuilder.class, (String)"XmlAttributeBuilder");
        infoBuilder.addInterface(XmlAttributeBuilder.class);
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

