/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.osgi.web.extender;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.j2ee.deployment.BundleDeploymentContext;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.jndi.ApplicationJndi;
import org.apache.geronimo.j2ee.jndi.JndiScope;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.LifecycleException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.osgi.web.extender.WebContainerExtender;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplication
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebApplication.class);
    private final WebContainerExtender extender;
    private final Bundle bundle;
    private final String contextPath;
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private final AtomicBoolean running = new AtomicBoolean();
    private boolean destroyed;
    private Artifact deployedArtifact;

    public WebApplication(WebContainerExtender extender, Bundle bundle, String contextPath) {
        this.extender = extender;
        this.bundle = bundle;
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void schedule() {
        if (this.scheduled.compareAndSet(false, true)) {
            this.extender.getExecutorService().submit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.scheduled.set(false);
        AtomicBoolean atomicBoolean = this.scheduled;
        synchronized (atomicBoolean) {
            AtomicBoolean atomicBoolean2 = this.running;
            synchronized (atomicBoolean2) {
                this.running.set(true);
                try {
                    this.doRun();
                }
                finally {
                    this.running.set(false);
                    this.running.notifyAll();
                }
            }
        }
    }

    private void deploying() {
        this.extender.getEventDispatcher().deploying(this.bundle, this.contextPath);
    }

    private void deployed() {
        this.extender.getEventDispatcher().deployed(this.bundle, this.contextPath);
    }

    private void undeploying() {
        this.extender.getEventDispatcher().undeploying(this.bundle, this.contextPath);
    }

    private void undeployed() {
        this.extender.getEventDispatcher().undeployed(this.bundle, this.contextPath);
    }

    private void failed(Throwable cause) {
        this.extender.getEventDispatcher().failed(this.bundle, this.contextPath, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        if (this.destroyed) {
            return;
        }
        ConfigurationData configurationData = null;
        try {
            this.deploying();
            ConfigurationManager configurationManager = this.extender.getConfigurationManager();
            File configSer = this.bundle.getBundleContext().getDataFile("config.ser");
            if (configSer.exists() && configSer.lastModified() == this.bundle.getLastModified()) {
                LOGGER.info("Redeploying WAB {} at {}", new Object[]{this.bundle, this.contextPath});
                FileInputStream in = new FileInputStream(configSer);
                try {
                    configurationData = ConfigurationUtil.readConfigurationData((InputStream)in);
                }
                finally {
                    in.close();
                }
            }
            LOGGER.info("Deploying WAB {} at {}", new Object[]{this.bundle, this.contextPath});
            ModuleIDBuilder idBuilder = new ModuleIDBuilder();
            Kernel kernel = this.extender.getKernel();
            Naming naming = kernel.getNaming();
            ModuleBuilder webModuleBuilder = this.extender.getWebModuleBuilder();
            if (webModuleBuilder == null) {
                throw new DeploymentException("Unable to deploy " + this.bundle + " WAB. No web module builders found.");
            }
            WebModule webModule = (WebModule)webModuleBuilder.createModule(this.bundle, naming, idBuilder);
            BundleDeploymentContext deploymentContext = new BundleDeploymentContext(webModule.getEnvironment(), webModule.getType(), naming, configurationManager, this.bundle.getBundleContext(), this.extender.getServerName(), webModule.getModuleName(), this.extender.getTransactionManagerObjectName(), this.extender.getConnectionTrackerObjectName(), this.extender.getCorbaGBeanObjectName(), new HashMap(), this.bundle);
            webModule.setEarContext((EARContext)deploymentContext);
            webModule.setRootEarContext((EARContext)deploymentContext);
            deploymentContext.flush();
            deploymentContext.initializeConfiguration();
            Map contexts = (Map)NamingBuilder.JNDI_KEY.get(deploymentContext.getGeneralData());
            HashMap<String, String> app = new HashMap<String, String>();
            app.put("app/AppName", webModule.getName());
            contexts.put(JndiScope.app, app);
            webModuleBuilder.initContext((EARContext)deploymentContext, (Module)webModule, this.bundle);
            AbstractName appJndiName = naming.createChildName(deploymentContext.getModuleName(), "ApplicationJndi", "ApplicationJndi");
            deploymentContext.getGeneralData().put(EARContext.APPLICATION_JNDI_NAME_KEY, appJndiName);
            webModuleBuilder.addGBeans((EARContext)deploymentContext, (Module)webModule, this.bundle, this.extender.getRepositories());
            GBeanData appContexts = new GBeanData(appJndiName, ApplicationJndi.class);
            appContexts.setAttribute("globalContextSegment", contexts.get(JndiScope.global));
            appContexts.setAttribute("applicationContextMap", contexts.get(JndiScope.app));
            appContexts.setReferencePattern("GlobalContext", this.extender.getGlobalContextAbstractName());
            deploymentContext.addGBean(appContexts);
            configurationData = deploymentContext.getConfigurationData();
            FileOutputStream out = new FileOutputStream(configSer);
            try {
                ConfigurationUtil.writeConfigurationData((ConfigurationData)configurationData, (OutputStream)out);
            }
            finally {
                out.close();
            }
            deploymentContext.close();
            configSer.setLastModified(this.bundle.getLastModified());
            configurationData.setUseEnvironment(true);
            configurationData.setBundleContext(this.bundle.getBundleContext());
            configurationManager.loadConfiguration(configurationData);
            configurationManager.startConfiguration(configurationData.getId());
            this.deployedArtifact = configurationData.getId();
            LOGGER.info("Deployed WAB {} at {}", new Object[]{this.bundle, this.contextPath});
            this.deployed();
        }
        catch (Throwable exception) {
            LOGGER.error("Unable to start web application for bundle " + this.getBundle().getSymbolicName(), exception);
            this.failed(exception);
            if (configurationData != null) {
                this.undeploy(configurationData.getId());
            }
            this.extender.unregisterWebApplication(this);
        }
    }

    private void undeploy(Artifact artifact) {
        ConfigurationManager configurationManager = this.extender.getConfigurationManager();
        try {
            configurationManager.uninstallConfiguration(artifact);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchConfigException e) {
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        this.destroyed = true;
        AtomicBoolean atomicBoolean = this.running;
        synchronized (atomicBoolean) {
            while (this.running.get()) {
                try {
                    this.running.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.undeploying();
        if (this.deployedArtifact != null) {
            LOGGER.info("Undeploying WAB {} at {}", new Object[]{this.bundle, this.contextPath});
            this.undeploy(this.deployedArtifact);
            LOGGER.info("Undeployed WAB {} at {}", new Object[]{this.bundle, this.contextPath});
        }
        this.undeployed();
        this.extender.unregisterWebApplication(this);
    }
}

