/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.util.QueryStatus;
import org.apache.juddi.api.util.UDDIQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDDIServiceCounter
implements DynamicMBean,
Serializable {
    private static Log log = LogFactory.getLog(UDDIServiceCounter.class);
    private Hashtable<String, LongHolder> queryProcessingTime;
    private Hashtable<String, IntHolder> totalQueryCounter;
    private Hashtable<String, IntHolder> successQueryCounter;
    private Hashtable<String, IntHolder> faultQueryCounter;
    private ObjectName listObjectName = null;
    private int totalApiCounter;
    private int successApiCounter;
    private int faultApiCounter;
    private static final String PROCESSING_TIME = "processing time";
    private static final String TOTAL_QUERIES = "total queries";
    private static final String SUCCESSFUL_QUERIES = "successful queries";
    private static final String FAILED_QUERIES = "failed queries";
    private static final String TOTAL_API_QUERIES = "Total API Queries";
    private static final String SUCCESSFUL_API_QUERIES = "Successful API Queries";
    private static final String FAILED_API_QUERIES = "Failed API Queries";
    public static final String RESET_COUNTER = "resetCounts";

    public void initList(Class klass, List<String> queries) {
        try {
            this.listObjectName = new ObjectName("apache.juddi:counter=" + klass.getName());
        }
        catch (MalformedObjectNameException mone) {
            log.error((Object)mone);
        }
        this.queryProcessingTime = new Hashtable();
        this.totalQueryCounter = new Hashtable();
        this.successQueryCounter = new Hashtable();
        this.faultQueryCounter = new Hashtable();
        for (String query : queries) {
            this.queryProcessingTime.put(query + " " + PROCESSING_TIME, new LongHolder(null));
            this.totalQueryCounter.put(query + " " + TOTAL_QUERIES, new IntHolder(null));
            this.successQueryCounter.put(query + " " + SUCCESSFUL_QUERIES, new IntHolder(null));
            this.faultQueryCounter.put(query + " " + FAILED_QUERIES, new IntHolder(null));
        }
        this.totalApiCounter = 0;
        this.successApiCounter = 0;
        this.faultApiCounter = 0;
    }

    protected void registerMBean() {
        MBeanServer mbeanServer = null;
        mbeanServer = this.getServer();
        if (mbeanServer == null) {
            // empty if block
        }
        try {
            mbeanServer.registerMBean(this, this.listObjectName);
        }
        catch (InstanceAlreadyExistsException e) {
            log.warn((Object)"", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.warn((Object)"", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            log.warn((Object)"", (Throwable)e);
        }
    }

    private MBeanServer getServer() {
        MBeanServer mbserver = null;
        ArrayList<MBeanServer> mbservers = MBeanServerFactory.findMBeanServer(null);
        if (mbservers.size() > 0) {
            mbserver = mbservers.get(0);
        }
        if (mbserver != null) {
            log.info((Object)"Found MBean server");
        } else {
            mbserver = MBeanServerFactory.createMBeanServer();
        }
        return mbserver;
    }

    public void resetCounts() {
        for (String key : this.queryProcessingTime.keySet()) {
            this.queryProcessingTime.put(key, new LongHolder(null));
        }
        for (String key : this.totalQueryCounter.keySet()) {
            this.totalQueryCounter.put(key, new IntHolder(null));
        }
        for (String key : this.successQueryCounter.keySet()) {
            this.successQueryCounter.put(key, new IntHolder(null));
        }
        for (String key : this.faultQueryCounter.keySet()) {
            this.faultQueryCounter.put(key, new IntHolder(null));
        }
        this.totalApiCounter = 0;
        this.successApiCounter = 0;
        this.faultApiCounter = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void update(UDDIQuery queryObject, QueryStatus queryStatus, long procTime) {
        String query = queryObject.getQuery();
        LongHolder totalProcTime = (LongHolder)this.queryProcessingTime.get(query + " " + PROCESSING_TIME);
        if (totalProcTime == null) throw new RuntimeException("Exception in Update : " + queryObject.getQuery() + " time " + procTime + " queryprocessingtime.size() + " + this.queryProcessingTime.size());
        totalProcTime.value += procTime;
        ++this.totalApiCounter;
        IntHolder queryCounter = (IntHolder)this.totalQueryCounter.get(query + " " + TOTAL_QUERIES);
        if (queryCounter == null) throw new RuntimeException("Exception in Update : " + queryObject.getQuery() + " time " + procTime + " totalQueryCounter.size() + " + this.totalQueryCounter.size());
        ++queryCounter.value;
        if (queryStatus == QueryStatus.SUCCESS) {
            IntHolder successQuery = (IntHolder)this.successQueryCounter.get(query + " " + SUCCESSFUL_QUERIES);
            if (successQuery == null) throw new RuntimeException("Exception in Update : " + queryObject.getQuery() + " time " + procTime + " successQueryCounter.size() " + this.successQueryCounter.size());
            ++successQuery.value;
            ++this.successApiCounter;
            return;
        } else {
            if (queryStatus != QueryStatus.FAILED) return;
            IntHolder faultQuery = (IntHolder)this.faultQueryCounter.get(query + " " + FAILED_QUERIES);
            if (faultQuery == null) throw new RuntimeException("Exception in Update : " + queryObject.getQuery() + " time " + procTime + " faultQueryCounter.size() " + this.faultQueryCounter.size());
            ++faultQuery.value;
            ++this.faultApiCounter;
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.queryProcessingTime.containsKey(attribute)) {
            return this.queryProcessingTime.get(attribute);
        }
        if (this.totalQueryCounter.containsKey(attribute)) {
            return this.totalQueryCounter.get(attribute);
        }
        if (this.successQueryCounter.containsKey(attribute)) {
            return this.successQueryCounter.get(attribute);
        }
        if (this.faultQueryCounter.containsKey(attribute)) {
            return this.faultQueryCounter.get(attribute);
        }
        if (attribute.equals(TOTAL_API_QUERIES)) {
            return this.totalApiCounter;
        }
        if (attribute.equals(SUCCESSFUL_API_QUERIES)) {
            return this.successApiCounter;
        }
        if (attribute.equals(FAILED_API_QUERIES)) {
            return this.faultApiCounter;
        }
        return null;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        Attribute at;
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute(TOTAL_API_QUERIES, this.totalApiCounter));
        attributeList.add(new Attribute(SUCCESSFUL_API_QUERIES, this.successApiCounter));
        attributeList.add(new Attribute(FAILED_API_QUERIES, this.faultApiCounter));
        for (String key : this.queryProcessingTime.keySet()) {
            at = new Attribute(key, ((LongHolder)this.queryProcessingTime.get(key)).toString());
            attributeList.add(at);
        }
        for (String key : this.totalQueryCounter.keySet()) {
            at = new Attribute(key, ((IntHolder)this.totalQueryCounter.get(key)).toString());
            attributeList.add(at);
        }
        for (String key : this.successQueryCounter.keySet()) {
            at = new Attribute(key, ((IntHolder)this.successQueryCounter.get(key)).toString());
            attributeList.add(at);
        }
        for (String key : this.faultQueryCounter.keySet()) {
            at = new Attribute(key, ((IntHolder)this.faultQueryCounter.get(key)).toString());
            attributeList.add(at);
        }
        return attributeList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName.equalsIgnoreCase(RESET_COUNTER)) {
            this.resetCounts();
            return "Invoking the " + actionName + " on the lifecycle.";
        }
        throw new ReflectionException(new NoSuchMethodException(actionName));
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        int count = this.queryProcessingTime.size() + this.totalQueryCounter.size() + this.successQueryCounter.size() + this.faultQueryCounter.size() + 3;
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[count];
        int counter = 0;
        attrs[counter] = new MBeanAttributeInfo(TOTAL_API_QUERIES, "java.lang.Integer", "Property Total API Queries", true, false, false);
        attrs[++counter] = new MBeanAttributeInfo(SUCCESSFUL_API_QUERIES, "java.lang.Integer", "Property Successful API Queries", true, false, false);
        attrs[++counter] = new MBeanAttributeInfo(FAILED_API_QUERIES, "java.lang.Integer", "Property Failed API Queries", true, false, false);
        ++counter;
        for (String key : this.queryProcessingTime.keySet()) {
            attrs[counter] = new MBeanAttributeInfo(key, "java.lang.Double", "Property " + key, true, false, false);
            ++counter;
        }
        for (String key : this.totalQueryCounter.keySet()) {
            attrs[counter] = new MBeanAttributeInfo(key, "java.lang.Integer", "Property " + key, true, false, false);
            ++counter;
        }
        for (String key : this.successQueryCounter.keySet()) {
            attrs[counter] = new MBeanAttributeInfo(key, "java.lang.Integer", "Property " + key, true, false, false);
            ++counter;
        }
        for (String key : this.faultQueryCounter.keySet()) {
            attrs[counter] = new MBeanAttributeInfo(key, "java.lang.Integer", "Property " + key, true, false, false);
            ++counter;
        }
        MBeanOperationInfo[] opers = new MBeanOperationInfo[]{new MBeanOperationInfo(RESET_COUNTER, "Reset the counter", null, "void", 1)};
        return new MBeanInfo(this.getClass().getName(), "Service Counter MBean", attrs, null, opers, null);
    }
}

