/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.juddi.api_v3.Clerk;
import org.apache.juddi.api_v3.ClientSubscriptionInfo;
import org.apache.juddi.api_v3.DeleteClientSubscriptionInfo;
import org.apache.juddi.api_v3.GetAllClientSubscriptionInfoDetail;
import org.apache.juddi.api_v3.GetClientSubscriptionInfoDetail;
import org.apache.juddi.api_v3.SaveClientSubscriptionInfo;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.apache.juddi.validation.ValidateUDDIApi;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class ValidateClientSubscriptionInfo
extends ValidateUDDIApi {
    public ValidateClientSubscriptionInfo(UddiEntityPublisher publisher) {
        super(publisher);
    }

    public void validateDeleteClientSubscriptionInfo(EntityManager em, DeleteClientSubscriptionInfo body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getSubscriptionKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        for (String entityKey : entityKeyList) {
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            Object obj = em.find(org.apache.juddi.model.ClientSubscriptionInfo.class, (Object)entityKey);
            if (obj != null) continue;
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.SubscriptionKeyNotFound", entityKey));
        }
    }

    public void validateSaveClientSubscriptionInfo(EntityManager em, SaveClientSubscriptionInfo body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List clientSubscriptionInfos = body.getClientSubscriptionInfo();
        if (clientSubscriptionInfos == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.saveclientsubscriptioninfo.NoInput"));
        }
        for (ClientSubscriptionInfo clientSubscriptionInfo : body.getClientSubscriptionInfo()) {
            if (clientSubscriptionInfo.getSubscriptionKey() == null || clientSubscriptionInfo.getSubscriptionKey().equals("")) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.saveclientsubscriptionKey.NoInput"));
            }
            this.validateClerk(em, clientSubscriptionInfo.getFromClerk());
        }
    }

    public void validateClerk(EntityManager em, Clerk clerk) throws DispositionReportFaultMessage {
        if (clerk == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.clerk.NullInput"));
        }
        String name = clerk.getName();
        if (name == null || name.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.clerk.NoName"));
        }
        Object obj = em.find(org.apache.juddi.model.Clerk.class, (Object)name);
        if (obj == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ClerkNotFound", name));
        }
    }

    public void validateGetClientSubscriptionInfoDetail(GetClientSubscriptionInfoDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List clientSubscriptionKeyList = body.getClientSubscriptionKey();
        if (clientSubscriptionKeyList == null || clientSubscriptionKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        for (String clientSubscriptionKey : clientSubscriptionKeyList) {
            boolean inserted = dupCheck.add(clientSubscriptionKey);
            if (inserted) continue;
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", clientSubscriptionKey));
        }
    }

    public void validateGetAllClientSubscriptionDetail(GetAllClientSubscriptionInfoDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
    }
}

