/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidCombinationException;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.apache.juddi.validation.ValidateUDDIApi;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetOperationalInfo;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.api_v3.IdentifierBag;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.TModelBag;
import org.uddi.v3_service.DispositionReportFaultMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateInquiry
extends ValidateUDDIApi {
    public ValidateInquiry(UddiEntityPublisher publisher) {
        super(publisher);
    }

    public void validateGetBusinessDetail(GetBusinessDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getBusinessKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            ++i;
        }
    }

    public void validateGetServiceDetail(GetServiceDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getServiceKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            ++i;
        }
    }

    public void validateGetBindingDetail(GetBindingDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getBindingKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            ++i;
        }
    }

    public void validateGetTModelDetail(GetTModelDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getTModelKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            ++i;
        }
    }

    public void validateGetOperationalInfo(GetOperationalInfo body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getEntityKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        int i = 0;
        for (String entityKey : entityKeyList) {
            entityKey = entityKey.toLowerCase();
            entityKeyList.set(i, entityKey);
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            ++i;
        }
    }

    public void validateFindBusiness(FindBusiness body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getCategoryBag() == null && body.getFindTModel() == null && body.getTModelBag() == null && body.getName().size() == 0 && body.getIdentifierBag() == null && body.getDiscoveryURLs() == null && body.getFindRelatedBusinesses() == null) {
            throw new FatalErrorException(new ErrorMessage("errors.findbusiness.NoInput"));
        }
        this.validateNames(body.getName());
        this.validateFindQualifiers(body.getFindQualifiers());
        this.validateTModelBag(body.getTModelBag());
        this.validateFindTModel(body.getFindTModel(), true);
        this.validateFindRelatedBusinesses(body.getFindRelatedBusinesses(), true);
        this.validateDiscoveryUrls(body.getDiscoveryURLs());
        this.validateIdentifierBag(body.getIdentifierBag());
        this.validateCategoryBag(body.getCategoryBag());
    }

    public void validateFindService(FindService body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getCategoryBag() == null && body.getFindTModel() == null && body.getTModelBag() == null && body.getName().size() == 0) {
            throw new FatalErrorException(new ErrorMessage("errors.findservice.NoInput"));
        }
        this.validateNames(body.getName());
        this.validateFindQualifiers(body.getFindQualifiers());
        this.validateTModelBag(body.getTModelBag());
        this.validateFindTModel(body.getFindTModel(), true);
        this.validateCategoryBag(body.getCategoryBag());
    }

    public void validateFindBinding(FindBinding body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getCategoryBag() == null && body.getFindTModel() == null && body.getTModelBag() == null) {
            throw new FatalErrorException(new ErrorMessage("errors.findbinding.NoInput"));
        }
        this.validateFindQualifiers(body.getFindQualifiers());
        this.validateTModelBag(body.getTModelBag());
        this.validateFindTModel(body.getFindTModel(), true);
        this.validateCategoryBag(body.getCategoryBag());
    }

    public void validateFindTModel(FindTModel body, boolean nullAllowed) throws DispositionReportFaultMessage {
        if (body == null) {
            if (nullAllowed) {
                return;
            }
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getCategoryBag() == null && body.getIdentifierBag() == null && body.getName() == null) {
            throw new FatalErrorException(new ErrorMessage("errors.findtmodel.NoInput"));
        }
        this.validateFindQualifiers(body.getFindQualifiers());
        this.validateIdentifierBag(body.getIdentifierBag());
        this.validateCategoryBag(body.getCategoryBag());
    }

    public void validateFindRelatedBusinesses(FindRelatedBusinesses body, boolean nullAllowed) throws DispositionReportFaultMessage {
        KeyedReference keyedRef;
        if (body == null) {
            if (nullAllowed) {
                return;
            }
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (!(body.getBusinessKey() != null && body.getBusinessKey().length() != 0 || body.getFromKey() != null && body.getFromKey().length() != 0 || body.getToKey() != null && body.getToKey().length() != 0)) {
            throw new FatalErrorException(new ErrorMessage("errors.findrelatedbusiness.NoInput"));
        }
        boolean businessKeyExists = false;
        boolean fromKeyExists = false;
        if (body.getBusinessKey() != null && body.getBusinessKey().length() > 0) {
            businessKeyExists = true;
            body.setBusinessKey(body.getBusinessKey().toLowerCase());
        }
        if (body.getFromKey() != null && body.getFromKey().length() > 0) {
            fromKeyExists = true;
            if (businessKeyExists) {
                throw new FatalErrorException(new ErrorMessage("errors.findrelatedbusiness.MultipleInput"));
            }
            body.setFromKey(body.getFromKey().toLowerCase());
        }
        if (body.getToKey() != null && body.getToKey().length() > 0) {
            if (businessKeyExists || fromKeyExists) {
                throw new FatalErrorException(new ErrorMessage("errors.findrelatedbusiness.MultipleInput"));
            }
            body.setToKey(body.getToKey().toLowerCase());
        }
        if ((keyedRef = body.getKeyedReference()) != null) {
            if (keyedRef.getTModelKey() == null || keyedRef.getTModelKey().length() == 0 || keyedRef.getKeyName() == null || keyedRef.getKeyName().length() == 0 || keyedRef.getKeyValue() == null || keyedRef.getKeyValue().length() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.findrelatedbusiness.BlankKeyedRef"));
            }
            this.validateKeyedReference(keyedRef);
        }
    }

    public void validateNames(List<Name> names) throws DispositionReportFaultMessage {
        if (names != null) {
            for (Name n : names) {
                if (n.getValue() != null && n.getValue().length() != 0) continue;
                throw new ValueNotAllowedException(new ErrorMessage("errors.names.NoValue"));
            }
        }
    }

    public void validateTModelBag(TModelBag tmodelBag) throws DispositionReportFaultMessage {
        if (tmodelBag == null) {
            return;
        }
        if (tmodelBag.getTModelKey() == null || tmodelBag.getTModelKey().size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodelbag.NoInput"));
        }
        List keyList = tmodelBag.getTModelKey();
        int i = 0;
        for (String key : keyList) {
            key = key.toLowerCase();
            keyList.set(i, key);
            ++i;
        }
    }

    public void validateDiscoveryUrls(DiscoveryURLs discUrls) throws DispositionReportFaultMessage {
        if (discUrls == null) {
            return;
        }
        List discUrlList = discUrls.getDiscoveryURL();
        if (discUrlList == null || discUrlList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.discurls.NoInput"));
        }
    }

    public void validateCategoryBag(CategoryBag categories) throws DispositionReportFaultMessage {
        if (categories == null) {
            return;
        }
        List elems = categories.getKeyedReference();
        List krgs = categories.getKeyedReferenceGroup();
        if (!(elems != null && elems.size() != 0 || krgs != null && krgs.size() != 0)) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.categorybag.NoInput"));
        }
        for (KeyedReference elem : elems) {
            this.validateKeyedReference(elem);
        }
        for (KeyedReference elem : krgs) {
            this.validateKeyedReferenceGroup((KeyedReferenceGroup)elem);
        }
    }

    public void validateIdentifierBag(IdentifierBag identifiers) throws DispositionReportFaultMessage {
        if (identifiers == null) {
            return;
        }
        List keyedRefList = identifiers.getKeyedReference();
        if (keyedRefList == null || keyedRefList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.identifierbag.NoInput"));
        }
        for (KeyedReference keyedRef : keyedRefList) {
            this.validateKeyedReference(keyedRef);
        }
    }

    public void validateKeyedReferenceGroup(KeyedReferenceGroup krg) throws DispositionReportFaultMessage {
        if (krg.getTModelKey() == null || krg.getTModelKey().length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoTModelKey"));
        }
        krg.setTModelKey(krg.getTModelKey().toLowerCase());
        List keyedRefs = krg.getKeyedReference();
        if (keyedRefs != null && keyedRefs.size() > 0) {
            for (KeyedReference keyedRef : keyedRefs) {
                this.validateKeyedReference(keyedRef);
            }
        }
    }

    public void validateKeyedReference(KeyedReference kr) throws DispositionReportFaultMessage {
        if (kr == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NullInput"));
        }
        if (kr instanceof KeyedReference) {
            if (kr.getTModelKey() == null || kr.getTModelKey().length() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoTModelKey"));
            }
            kr.setTModelKey(kr.getTModelKey().toLowerCase());
            if (kr.getKeyValue() == null || kr.getKeyValue().length() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoKeyValue"));
            }
        }
    }

    private void validateFindQualifiers(FindQualifiers findQualifiers) throws DispositionReportFaultMessage {
        if (findQualifiers == null) {
            return;
        }
        List fqList = findQualifiers.getFindQualifier();
        if (fqList == null || fqList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.findqualifiers.NoInput"));
        }
        Hashtable<String, String> fqTable = new Hashtable<String, String>();
        for (String fq : fqList) {
            String result = fqTable.put(fq.toUpperCase(), fq.toUpperCase());
            if (result != null) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.findqualifiers.DuplicateValue", result));
            }
            if (fq.equalsIgnoreCase("andAllKeys") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:andallkeys")) {
                if (fqTable.get("orAllKeys".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:orallkeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "orAllKeys"));
                }
                if (fqTable.get("orLikeKeys".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:orlikekeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "orLikeKeys"));
                }
            } else if (fq.equalsIgnoreCase("orAllKeys") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:orallkeys")) {
                if (fqTable.get("andAllKeys".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:andallkeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "andAllKeys"));
                }
                if (fqTable.get("orLikeKeys".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:orlikekeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "orLikeKeys"));
                }
            } else if (fq.equalsIgnoreCase("orLikeKeys") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:orlikekeys")) {
                if (fqTable.get("andAllKeys".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:andallkeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "andAllKeys"));
                }
                if (fqTable.get("orAllKeys".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:orallkeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "orAllKeys"));
                }
            }
            if (fq.equalsIgnoreCase("sortByNameAsc") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:sortbynameasc")) {
                if (fqTable.get("sortByNameDesc".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:sortbynamedesc".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "sortByNameDesc"));
                }
            } else if ((fq.equalsIgnoreCase("sortByNameDesc") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:sortbynamedesc")) && (fqTable.get("sortByNameAsc".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:sortbynameasc".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "sortByNameAsc"));
            }
            if (fq.equalsIgnoreCase("sortByDateAsc") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:sortbydateasc")) {
                if (fqTable.get("sortByDateDesc".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:sortbydatedesc".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "sortByDateDesc"));
                }
            } else if ((fq.equalsIgnoreCase("sortByDateDesc") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:sortbydatedesc")) && (fqTable.get("sortByDateAsc".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:sortbydateasc".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "sortByDateAsc"));
            }
            if (fq.equalsIgnoreCase("combineCategoryBags") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:combinecategorybags")) {
                if (fqTable.get("serviceSubset".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:servicesubset".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "serviceSubset"));
                }
                if (fqTable.get("bindingSubset".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:bindingsubset".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "bindingSubset"));
                }
            } else if (fq.equalsIgnoreCase("serviceSubset") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:servicesubset")) {
                if (fqTable.get("combineCategoryBags".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:combinecategorybags".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "combineCategoryBags"));
                }
                if (fqTable.get("bindingSubset".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:bindingsubset".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "bindingSubset"));
                }
            } else if (fq.equalsIgnoreCase("bindingSubset") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:bindingsubset")) {
                if (fqTable.get("serviceSubset".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:servicesubset".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "serviceSubset"));
                }
                if (fqTable.get("combineCategoryBags".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:combinecategorybags".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "combineCategoryBags"));
                }
            }
            if (fq.equalsIgnoreCase("exactMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:exactmatch")) {
                if (fqTable.get("approximateMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:approximatematch".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "approximateMatch"));
                }
            } else if ((fq.equalsIgnoreCase("approximateMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:approximatematch")) && (fqTable.get("exactMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:exactmatch".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "exactMatch"));
            }
            if (fq.equalsIgnoreCase("exactMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:exactmatch")) {
                if (fqTable.get("caseInsensitiveMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:caseinsensitivematch".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "caseInsensitiveMatch"));
                }
            } else if ((fq.equalsIgnoreCase("caseInsensitiveMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:caseinsensitivematch")) && (fqTable.get("exactMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:exactmatch".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "exactMatch"));
            }
            if (fq.equalsIgnoreCase("binarySort") || fq.equalsIgnoreCase("uddi:uddi.org:sortorder:binarysort")) {
                if (fqTable.get("UTS-10".toUpperCase()) != null || fqTable.get("uddi:uddi.org:sortorder:uts-10".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "UTS-10"));
                }
            } else if ((fq.equalsIgnoreCase("UTS-10") || fq.equalsIgnoreCase("uddi:uddi.org:sortorder:uts-10")) && (fqTable.get("binarySort".toUpperCase()) != null || fqTable.get("uddi:uddi.org:sortorder:binarysort".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "binarySort"));
            }
            if (fq.equalsIgnoreCase("diacriticSensitiveMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:diacriticssensitivematch")) {
                if (fqTable.get("diacriticInsensitiveMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:diacriticsinsensitivematch".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "diacriticInsensitiveMatch"));
                }
            } else if ((fq.equalsIgnoreCase("diacriticInsensitiveMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:diacriticsinsensitivematch")) && (fqTable.get("diacriticSensitiveMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:diacriticssensitivematch".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "diacriticSensitiveMatch"));
            }
            if (fq.equalsIgnoreCase("exactMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:exactmatch")) {
                if (fqTable.get("diacriticInsensitiveMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:diacriticsinsensitivematch".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "diacriticInsensitiveMatch"));
                }
            } else if ((fq.equalsIgnoreCase("diacriticInsensitiveMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:diacriticsinsensitivematch")) && (fqTable.get("exactMatch".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:exactmatch".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "exactMatch"));
            }
            if (fq.equalsIgnoreCase("caseSensitiveSort") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:casesensitivesort")) {
                if (fqTable.get("caseInsensitiveSort".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:caseinsensitivesort".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "caseInsensitiveSort"));
                }
            } else if ((fq.equalsIgnoreCase("caseInsensitiveSort") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:caseinsensitivesort")) && (fqTable.get("caseSensitiveSort".toUpperCase()) != null || fqTable.get("uddi:uddi.org:findqualifier:casesensitivesort".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "caseSensitiveSort"));
            }
            if (fq.equalsIgnoreCase("caseSensitiveMatch") || fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:casesensitivematch")) {
                if (fqTable.get("caseInsensitiveMatch".toUpperCase()) == null && fqTable.get("uddi:uddi.org:findqualifier:caseinsensitivematch".toUpperCase()) == null) continue;
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "caseInsensitiveMatch"));
            }
            if (!fq.equalsIgnoreCase("caseInsensitiveMatch") && !fq.equalsIgnoreCase("uddi:uddi.org:findqualifier:caseinsensitivematch") || fqTable.get("caseSensitiveMatch".toUpperCase()) == null && fqTable.get("uddi:uddi.org:findqualifier:casesensitivematch".toUpperCase()) == null) continue;
            throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "caseSensitiveMatch"));
        }
    }
}

