/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.util.List;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.InquiryHelper;
import org.apache.juddi.api.impl.ServiceCounterLifecycleResource;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.util.InquiryQuery;
import org.apache.juddi.api.util.QueryStatus;
import org.apache.juddi.api.util.UDDIQuery;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.query.util.FindQualifiers;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.validation.ValidateInquiry;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetOperationalInfo;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.api_v3.OperationalInfo;
import org.uddi.api_v3.OperationalInfos;
import org.uddi.api_v3.RelatedBusinessesList;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelList;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDIInquiryPortType;

@WebService(serviceName="UDDIInquiryService", endpointInterface="org.uddi.v3_service.UDDIInquiryPortType", targetNamespace="urn:uddi-org:v3_service")
public class UDDIInquiryImpl
extends AuthenticatedService
implements UDDIInquiryPortType {
    private static Log log = LogFactory.getLog(UDDIInquiryImpl.class);
    private UDDIServiceCounter serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingDetail findBinding(FindBinding body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        try {
            new ValidateInquiry(null).validateFindBinding(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.FIND_BINDING, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            String serviceKey;
            BusinessService modelBusinessService;
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(body.getFindQualifiers());
            List keysFound = InquiryHelper.findBinding((FindBinding)body, (FindQualifiers)findQualifiers, (EntityManager)em);
            if (keysFound.size() == 0 && body.getServiceKey() != null && (modelBusinessService = (BusinessService)em.find(BusinessService.class, (Object)(serviceKey = body.getServiceKey()))) == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ServiceNotFound", serviceKey));
            }
            BindingDetail result = InquiryHelper.getBindingDetailFromKeys((FindBinding)body, (FindQualifiers)findQualifiers, (EntityManager)em, (List)keysFound);
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.FIND_BINDING, QueryStatus.SUCCESS, procTime);
            BindingDetail bindingDetail = result;
            return bindingDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessList findBusiness(FindBusiness body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        try {
            new ValidateInquiry(null).validateFindBusiness(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.FIND_BUSINESS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(body.getFindQualifiers());
            List keysFound = InquiryHelper.findBusiness((FindBusiness)body, (FindQualifiers)findQualifiers, (EntityManager)em);
            BusinessList result = InquiryHelper.getBusinessListFromKeys((FindBusiness)body, (FindQualifiers)findQualifiers, (EntityManager)em, (List)keysFound);
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.FIND_BUSINESS, QueryStatus.SUCCESS, procTime);
            BusinessList businessList = result;
            return businessList;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelatedBusinessesList findRelatedBusinesses(FindRelatedBusinesses body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        try {
            new ValidateInquiry(null).validateFindRelatedBusinesses(body, false);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.FIND_RELATEDBUSINESSES, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(body.getFindQualifiers());
            RelatedBusinessesList result = InquiryHelper.getRelatedBusinessesList((FindRelatedBusinesses)body, (EntityManager)em);
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.FIND_RELATEDBUSINESSES, QueryStatus.SUCCESS, procTime);
            RelatedBusinessesList relatedBusinessesList = result;
            return relatedBusinessesList;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceList findService(FindService body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        try {
            new ValidateInquiry(null).validateFindService(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.FIND_SERVICE, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            String businessKey;
            BusinessEntity modelBusinessEntity;
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(body.getFindQualifiers());
            List keysFound = InquiryHelper.findService((FindService)body, (FindQualifiers)findQualifiers, (EntityManager)em);
            if (keysFound.size() == 0 && body.getBusinessKey() != null && (modelBusinessEntity = (BusinessEntity)em.find(BusinessEntity.class, (Object)(businessKey = body.getBusinessKey()))) == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ServiceNotFound", businessKey));
            }
            ServiceList result = InquiryHelper.getServiceListFromKeys((FindService)body, (FindQualifiers)findQualifiers, (EntityManager)em, (List)keysFound);
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.FIND_SERVICE, QueryStatus.SUCCESS, procTime);
            ServiceList serviceList = result;
            return serviceList;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TModelList findTModel(FindTModel body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        try {
            new ValidateInquiry(null).validateFindTModel(body, false);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.FIND_TMODEL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(body.getFindQualifiers());
            List keysFound = InquiryHelper.findTModel((FindTModel)body, (FindQualifiers)findQualifiers, (EntityManager)em);
            TModelList result = InquiryHelper.getTModelListFromKeys((FindTModel)body, (FindQualifiers)findQualifiers, (EntityManager)em, (List)keysFound);
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.FIND_TMODEL, QueryStatus.SUCCESS, procTime);
            TModelList tModelList = result;
            return tModelList;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingDetail getBindingDetail(GetBindingDetail body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        try {
            new ValidateInquiry(null).validateGetBindingDetail(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.FIND_TMODEL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            BindingDetail result = new BindingDetail();
            List bindingKeyList = body.getBindingKey();
            for (String bindingKey : bindingKeyList) {
                BindingTemplate modelBindingTemplate = (BindingTemplate)em.find(BindingTemplate.class, (Object)bindingKey);
                if (modelBindingTemplate == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BindingTemplateNotFound", bindingKey));
                }
                org.uddi.api_v3.BindingTemplate apiBindingTemplate = new org.uddi.api_v3.BindingTemplate();
                MappingModelToApi.mapBindingTemplate((BindingTemplate)modelBindingTemplate, (org.uddi.api_v3.BindingTemplate)apiBindingTemplate);
                result.getBindingTemplate().add(apiBindingTemplate);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.GET_BINDINGDETAIL, QueryStatus.SUCCESS, procTime);
            BindingDetail bindingDetail = result;
            return bindingDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessDetail getBusinessDetail(GetBusinessDetail body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        try {
            new ValidateInquiry(null).validateGetBusinessDetail(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.GET_BUSINESSDETAIL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            BusinessDetail result = new BusinessDetail();
            List businessKeyList = body.getBusinessKey();
            for (String businessKey : businessKeyList) {
                BusinessEntity modelBusinessEntity = (BusinessEntity)em.find(BusinessEntity.class, (Object)businessKey);
                if (modelBusinessEntity == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", businessKey));
                }
                org.uddi.api_v3.BusinessEntity apiBusinessEntity = new org.uddi.api_v3.BusinessEntity();
                MappingModelToApi.mapBusinessEntity((BusinessEntity)modelBusinessEntity, (org.uddi.api_v3.BusinessEntity)apiBusinessEntity);
                result.getBusinessEntity().add(apiBusinessEntity);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.GET_BUSINESSDETAIL, QueryStatus.SUCCESS, procTime);
            BusinessDetail businessDetail = result;
            return businessDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationalInfos getOperationalInfo(GetOperationalInfo body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        try {
            new ValidateInquiry(null).validateGetOperationalInfo(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.GET_OPERATIONALINFO, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            OperationalInfos result = new OperationalInfos();
            List entityKeyList = body.getEntityKey();
            for (String entityKey : entityKeyList) {
                UddiEntity modelUddiEntity = (UddiEntity)em.find(UddiEntity.class, (Object)entityKey);
                if (modelUddiEntity == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.EntityNotFound", entityKey));
                }
                OperationalInfo apiOperationalInfo = new OperationalInfo();
                MappingModelToApi.mapOperationalInfo((UddiEntity)modelUddiEntity, (OperationalInfo)apiOperationalInfo);
                result.getOperationalInfo().add(apiOperationalInfo);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.GET_OPERATIONALINFO, QueryStatus.SUCCESS, procTime);
            OperationalInfos operationalInfos = result;
            return operationalInfos;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDetail getServiceDetail(GetServiceDetail body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        try {
            new ValidateInquiry(null).validateGetServiceDetail(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.GET_SERVICEDETAIL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            ServiceDetail result = new ServiceDetail();
            List serviceKeyList = body.getServiceKey();
            for (String serviceKey : serviceKeyList) {
                BusinessService modelBusinessService = (BusinessService)em.find(BusinessService.class, (Object)serviceKey);
                if (modelBusinessService == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ServiceNotFound", serviceKey));
                }
                org.uddi.api_v3.BusinessService apiBusinessService = new org.uddi.api_v3.BusinessService();
                MappingModelToApi.mapBusinessService((BusinessService)modelBusinessService, (org.uddi.api_v3.BusinessService)apiBusinessService);
                result.getBusinessService().add(apiBusinessService);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.GET_SERVICEDETAIL, QueryStatus.SUCCESS, procTime);
            ServiceDetail serviceDetail = result;
            return serviceDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TModelDetail getTModelDetail(GetTModelDetail body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        try {
            new ValidateInquiry(null).validateGetTModelDetail(body);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.GET_TMODELDETAIL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            TModelDetail result = new TModelDetail();
            List tmodelKeyList = body.getTModelKey();
            for (String tmodelKey : tmodelKeyList) {
                Tmodel modelTModel = (Tmodel)em.find(Tmodel.class, (Object)tmodelKey);
                if (modelTModel == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.TModelNotFound", tmodelKey));
                }
                TModel apiTModel = new TModel();
                MappingModelToApi.mapTModel((Tmodel)modelTModel, (TModel)apiTModel);
                result.getTModel().add(apiTModel);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)InquiryQuery.GET_TMODELDETAIL, QueryStatus.SUCCESS, procTime);
            TModelDetail tModelDetail = result;
            return tModelDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    private boolean isAuthenticated() {
        boolean result = false;
        try {
            result = AppConfig.getConfiguration().getBoolean("juddi.authenticate.Inquiry");
        }
        catch (ConfigurationException e) {
            log.error((Object)"Configuration exception occurred retrieving: juddi.authenticate.Inquiry", (Throwable)e);
        }
        return result;
    }
}

