/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.xml.ws.Holder;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.PublicationHelper;
import org.apache.juddi.api.impl.ServiceCounterLifecycleResource;
import org.apache.juddi.api.impl.UDDIInquiryImpl;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.util.PublicationQuery;
import org.apache.juddi.api.util.QueryStatus;
import org.apache.juddi.api.util.UDDIQuery;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.mapping.MappingApiToModel;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.PublisherAssertion;
import org.apache.juddi.model.PublisherAssertionId;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.query.DeletePublisherAssertionByBusinessQuery;
import org.apache.juddi.query.FetchBusinessEntitiesQuery;
import org.apache.juddi.query.FetchTModelsQuery;
import org.apache.juddi.query.FindBusinessByPublisherQuery;
import org.apache.juddi.query.FindPublisherAssertionByBusinessQuery;
import org.apache.juddi.query.FindTModelByPublisherQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.validation.ValidatePublish;
import org.uddi.api_v3.AddPublisherAssertions;
import org.uddi.api_v3.AssertionStatusItem;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessInfos;
import org.uddi.api_v3.CompletionStatus;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.DeleteBusiness;
import org.uddi.api_v3.DeletePublisherAssertions;
import org.uddi.api_v3.DeleteService;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.api_v3.GetRegisteredInfo;
import org.uddi.api_v3.InfoSelection;
import org.uddi.api_v3.RegisteredInfo;
import org.uddi.api_v3.SaveBinding;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInfos;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDIPublicationPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="UDDIPublicationService", endpointInterface="org.uddi.v3_service.UDDIPublicationPortType", targetNamespace="urn:uddi-org:v3_service")
public class UDDIPublicationImpl
extends AuthenticatedService
implements UDDIPublicationPortType {
    private static Log log = LogFactory.getLog(UDDIInquiryImpl.class);
    private UDDIServiceCounter serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(this.getClass());

    public void addPublisherAssertions(AddPublisherAssertions body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateAddPublisherAssertions(em, body);
            List apiPubAssertionList = body.getPublisherAssertion();
            for (org.uddi.api_v3.PublisherAssertion apiPubAssertion : apiPubAssertionList) {
                PublisherAssertion modelPubAssertion = new PublisherAssertion();
                MappingApiToModel.mapPublisherAssertion((org.uddi.api_v3.PublisherAssertion)apiPubAssertion, (PublisherAssertion)modelPubAssertion);
                PublisherAssertion existingPubAssertion = (PublisherAssertion)em.find(modelPubAssertion.getClass(), (Object)modelPubAssertion.getId());
                boolean persistNewAssertion = true;
                if (existingPubAssertion != null) {
                    if (modelPubAssertion.getTmodelKey().equalsIgnoreCase(existingPubAssertion.getTmodelKey()) && modelPubAssertion.getKeyName().equalsIgnoreCase(existingPubAssertion.getKeyName()) && modelPubAssertion.getKeyValue().equalsIgnoreCase(existingPubAssertion.getKeyValue())) {
                        if (publisher.isOwner((UddiEntity)existingPubAssertion.getBusinessEntityByFromKey())) {
                            existingPubAssertion.setFromCheck("true");
                        }
                        if (publisher.isOwner((UddiEntity)existingPubAssertion.getBusinessEntityByToKey())) {
                            existingPubAssertion.setToCheck("true");
                        }
                        persistNewAssertion = false;
                    } else {
                        em.remove((Object)existingPubAssertion);
                    }
                }
                if (!persistNewAssertion) continue;
                BusinessEntity beFrom = (BusinessEntity)em.find(BusinessEntity.class, (Object)modelPubAssertion.getId().getFromKey());
                BusinessEntity beTo = (BusinessEntity)em.find(BusinessEntity.class, (Object)modelPubAssertion.getId().getToKey());
                modelPubAssertion.setBusinessEntityByFromKey(beFrom);
                modelPubAssertion.setBusinessEntityByToKey(beTo);
                modelPubAssertion.setFromCheck("false");
                modelPubAssertion.setToCheck("false");
                em.persist((Object)modelPubAssertion);
                if (publisher.isOwner((UddiEntity)modelPubAssertion.getBusinessEntityByFromKey())) {
                    modelPubAssertion.setFromCheck("true");
                }
                if (!publisher.isOwner((UddiEntity)modelPubAssertion.getBusinessEntityByToKey())) continue;
                modelPubAssertion.setToCheck("true");
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.ADD_PUBLISHERASSERTIONS, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.ADD_PUBLISHERASSERTIONS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public void deleteBinding(DeleteBinding body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeleteBinding(em, body);
            List entityKeyList = body.getBindingKey();
            for (String entityKey : entityKeyList) {
                Object obj = em.find(BindingTemplate.class, (Object)entityKey);
                ((BindingTemplate)obj).getBusinessService().setModifiedIncludingChildren(new Date());
                ((BindingTemplate)obj).getBusinessService().getBusinessEntity().setModifiedIncludingChildren(new Date());
                em.remove(obj);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.DELETE_BINDING, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.DELETE_BINDING, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public void deleteBusiness(DeleteBusiness body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeleteBusiness(em, body);
            List entityKeyList = body.getBusinessKey();
            for (String entityKey : entityKeyList) {
                Object obj = em.find(BusinessEntity.class, (Object)entityKey);
                em.remove(obj);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.DELETE_BUSINESS, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.DELETE_BUSINESS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public void deletePublisherAssertions(DeletePublisherAssertions body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeletePublisherAssertions(em, body);
            List entityList = body.getPublisherAssertion();
            for (org.uddi.api_v3.PublisherAssertion entity : entityList) {
                PublisherAssertionId pubAssertionId = new PublisherAssertionId(entity.getFromKey(), entity.getToKey());
                Object obj = em.find(PublisherAssertion.class, (Object)pubAssertionId);
                em.remove(obj);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.DELETE_PUBLISHERASSERTIONS, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.DELETE_PUBLISHERASSERTIONS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public void deleteService(DeleteService body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeleteService(em, body);
            List entityKeyList = body.getServiceKey();
            for (String entityKey : entityKeyList) {
                Object obj = em.find(BusinessService.class, (Object)entityKey);
                ((BusinessService)obj).getBusinessEntity().setModifiedIncludingChildren(new Date());
                em.remove(obj);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.DELETE_SERVICE, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.DELETE_SERVICE, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public void deleteTModel(DeleteTModel body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeleteTModel(em, body);
            List entityKeyList = body.getTModelKey();
            for (String entityKey : entityKeyList) {
                Object obj = em.find(Tmodel.class, (Object)entityKey);
                ((Tmodel)obj).setDeleted(true);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.DELETE_TMODEL, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.DELETE_TMODEL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public List<AssertionStatusItem> getAssertionStatusReport(String authInfo, CompletionStatus completionStatus) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            List result = PublicationHelper.getAssertionStatusItemList((UddiEntityPublisher)publisher, (CompletionStatus)completionStatus, (EntityManager)em);
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.GET_ASSERTIONSTATUSREPORT, QueryStatus.SUCCESS, procTime);
            List list = result;
            return list;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.GET_ASSERTIONSTATUSREPORT, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public List<org.uddi.api_v3.PublisherAssertion> getPublisherAssertions(String authInfo) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            ArrayList<org.uddi.api_v3.PublisherAssertion> result = new ArrayList<org.uddi.api_v3.PublisherAssertion>(0);
            List businessKeysFound = null;
            businessKeysFound = FindBusinessByPublisherQuery.select((EntityManager)em, null, (UddiEntityPublisher)publisher, businessKeysFound);
            List pubAssertionList = FindPublisherAssertionByBusinessQuery.select((EntityManager)em, (List)businessKeysFound, null);
            for (PublisherAssertion modelPubAssertion : pubAssertionList) {
                org.uddi.api_v3.PublisherAssertion apiPubAssertion = new org.uddi.api_v3.PublisherAssertion();
                MappingModelToApi.mapPublisherAssertion((PublisherAssertion)modelPubAssertion, (org.uddi.api_v3.PublisherAssertion)apiPubAssertion);
                result.add(apiPubAssertion);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.GET_PUBLISHERASSERTIONS, QueryStatus.SUCCESS, procTime);
            ArrayList<org.uddi.api_v3.PublisherAssertion> arrayList = result;
            return arrayList;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.GET_PUBLISHERASSERTIONS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public RegisteredInfo getRegisteredInfo(GetRegisteredInfo body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateRegisteredInfo(body);
            List businessKeysFound = null;
            businessKeysFound = FindBusinessByPublisherQuery.select((EntityManager)em, null, (UddiEntityPublisher)publisher, businessKeysFound);
            List tmodelKeysFound = null;
            tmodelKeysFound = body.getInfoSelection().equals((Object)InfoSelection.HIDDEN) ? FindTModelByPublisherQuery.select((EntityManager)em, null, (UddiEntityPublisher)publisher, (List)tmodelKeysFound, (DynamicQuery.Parameter[])new DynamicQuery.Parameter[]{new DynamicQuery.Parameter("t.deleted", (Object)new Boolean(true), DynamicQuery.PREDICATE_EQUALS)}) : (body.getInfoSelection().equals((Object)InfoSelection.VISIBLE) ? FindTModelByPublisherQuery.select((EntityManager)em, null, (UddiEntityPublisher)publisher, (List)tmodelKeysFound, (DynamicQuery.Parameter[])new DynamicQuery.Parameter[]{new DynamicQuery.Parameter("t.deleted", (Object)new Boolean(false), DynamicQuery.PREDICATE_EQUALS)}) : FindTModelByPublisherQuery.select((EntityManager)em, null, (UddiEntityPublisher)publisher, tmodelKeysFound, (DynamicQuery.Parameter[])new DynamicQuery.Parameter[0]));
            RegisteredInfo result = new RegisteredInfo();
            List queryResults = FetchBusinessEntitiesQuery.select((EntityManager)em, (FindQualifiers)new FindQualifiers(), (List)businessKeysFound, null, null, null, (DynamicQuery.Parameter[])new DynamicQuery.Parameter[0]);
            result.setBusinessInfos(new BusinessInfos());
            for (Object item : queryResults) {
                BusinessEntity modelBusinessEntity = (BusinessEntity)item;
                BusinessInfo apiBusinessInfo = new BusinessInfo();
                MappingModelToApi.mapBusinessInfo((BusinessEntity)modelBusinessEntity, (BusinessInfo)apiBusinessInfo);
                result.getBusinessInfos().getBusinessInfo().add(apiBusinessInfo);
            }
            queryResults = FetchTModelsQuery.select((EntityManager)em, (FindQualifiers)new FindQualifiers(), (List)tmodelKeysFound, null, null, null, (DynamicQuery.Parameter[])new DynamicQuery.Parameter[0]);
            result.setTModelInfos(new TModelInfos());
            for (Object item : queryResults) {
                Tmodel modelTModel = (Tmodel)item;
                TModelInfo apiTModelInfo = new TModelInfo();
                MappingModelToApi.mapTModelInfo((Tmodel)modelTModel, (TModelInfo)apiTModelInfo);
                result.getTModelInfos().getTModelInfo().add(apiTModelInfo);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.GET_REGISTEREDINFO, QueryStatus.SUCCESS, procTime);
            RegisteredInfo registeredInfo = result;
            return registeredInfo;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.GET_REGISTEREDINFO, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public BindingDetail saveBinding(SaveBinding body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateSaveBinding(em, body, null);
            BindingDetail result = new BindingDetail();
            List apiBindingTemplateList = body.getBindingTemplate();
            for (org.uddi.api_v3.BindingTemplate apiBindingTemplate : apiBindingTemplateList) {
                BindingTemplate modelBindingTemplate = new BindingTemplate();
                BusinessService modelBusinessService = new BusinessService();
                modelBusinessService.setEntityKey(apiBindingTemplate.getServiceKey());
                MappingApiToModel.mapBindingTemplate((org.uddi.api_v3.BindingTemplate)apiBindingTemplate, (BindingTemplate)modelBindingTemplate, (BusinessService)modelBusinessService);
                this.setOperationalInfo(em, modelBindingTemplate, publisher, false);
                em.persist((Object)modelBindingTemplate);
                result.getBindingTemplate().add(apiBindingTemplate);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.SAVE_BINDING, QueryStatus.SUCCESS, procTime);
            BindingDetail bindingDetail = result;
            return bindingDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.SAVE_BINDING, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public BusinessDetail saveBusiness(SaveBusiness body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateSaveBusiness(em, body, null);
            BusinessDetail result = new BusinessDetail();
            List apiBusinessEntityList = body.getBusinessEntity();
            for (org.uddi.api_v3.BusinessEntity apiBusinessEntity : apiBusinessEntityList) {
                BusinessEntity modelBusinessEntity = new BusinessEntity();
                MappingApiToModel.mapBusinessEntity((org.uddi.api_v3.BusinessEntity)apiBusinessEntity, (BusinessEntity)modelBusinessEntity);
                this.setOperationalInfo(em, modelBusinessEntity, publisher);
                em.persist((Object)modelBusinessEntity);
                result.getBusinessEntity().add(apiBusinessEntity);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.SAVE_BUSINESS, QueryStatus.SUCCESS, procTime);
            BusinessDetail businessDetail = result;
            return businessDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.SAVE_BUSINESS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public ServiceDetail saveService(SaveService body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateSaveService(em, body, null);
            ServiceDetail result = new ServiceDetail();
            List apiBusinessServiceList = body.getBusinessService();
            for (org.uddi.api_v3.BusinessService apiBusinessService : apiBusinessServiceList) {
                BusinessService modelBusinessService = new BusinessService();
                BusinessEntity modelBusinessEntity = new BusinessEntity();
                modelBusinessEntity.setEntityKey(apiBusinessService.getBusinessKey());
                MappingApiToModel.mapBusinessService((org.uddi.api_v3.BusinessService)apiBusinessService, (BusinessService)modelBusinessService, (BusinessEntity)modelBusinessEntity);
                this.setOperationalInfo(em, modelBusinessService, publisher, false);
                em.persist((Object)modelBusinessService);
                result.getBusinessService().add(apiBusinessService);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.SAVE_SERVICE, QueryStatus.SUCCESS, procTime);
            ServiceDetail serviceDetail = result;
            return serviceDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.SAVE_SERVICE, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public TModelDetail saveTModel(SaveTModel body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateSaveTModel(em, body, null);
            TModelDetail result = new TModelDetail();
            List apiTModelList = body.getTModel();
            for (TModel apiTModel : apiTModelList) {
                Tmodel modelTModel = new Tmodel();
                MappingApiToModel.mapTModel((TModel)apiTModel, (Tmodel)modelTModel);
                this.setOperationalInfo(em, modelTModel, publisher);
                em.persist((Object)modelTModel);
                result.getTModel().add(apiTModel);
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.SAVE_TMODEL, QueryStatus.SUCCESS, procTime);
            TModelDetail tModelDetail = result;
            return tModelDetail;
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.SAVE_TMODEL, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public void setPublisherAssertions(String authInfo, Holder<List<org.uddi.api_v3.PublisherAssertion>> publisherAssertion) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            new ValidatePublish(publisher).validateSetPublisherAssertions(em, publisherAssertion);
            List businessKeysFound = null;
            businessKeysFound = FindBusinessByPublisherQuery.select((EntityManager)em, null, (UddiEntityPublisher)publisher, businessKeysFound);
            DeletePublisherAssertionByBusinessQuery.delete((EntityManager)em, (List)businessKeysFound);
            List apiPubAssertionList = (List)publisherAssertion.value;
            for (org.uddi.api_v3.PublisherAssertion apiPubAssertion : apiPubAssertionList) {
                PublisherAssertion modelPubAssertion = new PublisherAssertion();
                MappingApiToModel.mapPublisherAssertion((org.uddi.api_v3.PublisherAssertion)apiPubAssertion, (PublisherAssertion)modelPubAssertion);
                BusinessEntity beFrom = (BusinessEntity)em.find(BusinessEntity.class, (Object)modelPubAssertion.getId().getFromKey());
                BusinessEntity beTo = (BusinessEntity)em.find(BusinessEntity.class, (Object)modelPubAssertion.getId().getToKey());
                modelPubAssertion.setBusinessEntityByFromKey(beFrom);
                modelPubAssertion.setBusinessEntityByToKey(beTo);
                modelPubAssertion.setFromCheck("false");
                modelPubAssertion.setToCheck("false");
                em.persist((Object)modelPubAssertion);
                if (publisher.isOwner((UddiEntity)modelPubAssertion.getBusinessEntityByFromKey())) {
                    modelPubAssertion.setFromCheck("true");
                }
                if (!publisher.isOwner((UddiEntity)modelPubAssertion.getBusinessEntityByToKey())) continue;
                modelPubAssertion.setToCheck("true");
            }
            tx.commit();
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.SET_PUBLISHERASSERTIONS, QueryStatus.SUCCESS, procTime);
        }
        catch (DispositionReportFaultMessage drfm) {
            long procTime = System.nanoTime() - startTime;
            this.serviceCounter.update((UDDIQuery)PublicationQuery.SET_PUBLISHERASSERTIONS, QueryStatus.FAILED, procTime);
            throw drfm;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    private void setOperationalInfo(EntityManager em, BusinessEntity uddiEntity, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        uddiEntity.setAuthorizedName(publisher.getAuthorizedName());
        Date now = new Date();
        uddiEntity.setModified(now);
        uddiEntity.setModifiedIncludingChildren(now);
        String nodeId = "";
        try {
            nodeId = AppConfig.getConfiguration().getString("juddi.nodeId");
        }
        catch (ConfigurationException ce) {
            throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval", "juddi.nodeId"));
        }
        uddiEntity.setNodeId(nodeId);
        BusinessEntity existingUddiEntity = (BusinessEntity)em.find(uddiEntity.getClass(), (Object)uddiEntity.getEntityKey());
        if (existingUddiEntity != null) {
            uddiEntity.setCreated(existingUddiEntity.getCreated());
        } else {
            uddiEntity.setCreated(now);
        }
        List serviceList = uddiEntity.getBusinessServices();
        for (BusinessService service : serviceList) {
            this.setOperationalInfo(em, service, publisher, true);
        }
        if (existingUddiEntity != null) {
            em.remove((Object)existingUddiEntity);
        }
    }

    private void setOperationalInfo(EntityManager em, BusinessService uddiEntity, UddiEntityPublisher publisher, boolean isChild) throws DispositionReportFaultMessage {
        uddiEntity.setAuthorizedName(publisher.getAuthorizedName());
        Date now = new Date();
        uddiEntity.setModified(now);
        uddiEntity.setModifiedIncludingChildren(now);
        if (!isChild) {
            BusinessEntity parent = (BusinessEntity)em.find(BusinessEntity.class, (Object)uddiEntity.getBusinessEntity().getEntityKey());
            parent.setModifiedIncludingChildren(now);
            em.persist((Object)parent);
        }
        String nodeId = "";
        try {
            nodeId = AppConfig.getConfiguration().getString("juddi.nodeId");
        }
        catch (ConfigurationException ce) {
            throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval", "juddi.nodeId"));
        }
        uddiEntity.setNodeId(nodeId);
        BusinessService existingUddiEntity = (BusinessService)em.find(uddiEntity.getClass(), (Object)uddiEntity.getEntityKey());
        if (existingUddiEntity != null) {
            uddiEntity.setCreated(existingUddiEntity.getCreated());
        } else {
            uddiEntity.setCreated(now);
        }
        List bindingList = uddiEntity.getBindingTemplates();
        for (BindingTemplate binding : bindingList) {
            this.setOperationalInfo(em, binding, publisher, true);
        }
        if (existingUddiEntity != null) {
            em.remove((Object)existingUddiEntity);
        }
    }

    private void setOperationalInfo(EntityManager em, BindingTemplate uddiEntity, UddiEntityPublisher publisher, boolean isChild) throws DispositionReportFaultMessage {
        uddiEntity.setAuthorizedName(publisher.getAuthorizedName());
        Date now = new Date();
        uddiEntity.setModified(now);
        uddiEntity.setModifiedIncludingChildren(now);
        if (!isChild) {
            BusinessService parent = (BusinessService)em.find(BusinessService.class, (Object)uddiEntity.getBusinessService().getEntityKey());
            parent.setModifiedIncludingChildren(now);
            em.persist((Object)parent);
            BusinessEntity businessParent = (BusinessEntity)em.find(BusinessEntity.class, (Object)parent.getBusinessEntity().getEntityKey());
            businessParent.setModifiedIncludingChildren(now);
            em.persist((Object)businessParent);
        }
        String nodeId = "";
        try {
            nodeId = AppConfig.getConfiguration().getString("juddi.nodeId");
        }
        catch (ConfigurationException ce) {
            throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval", "juddi.nodeId"));
        }
        uddiEntity.setNodeId(nodeId);
        BindingTemplate existingUddiEntity = (BindingTemplate)em.find(uddiEntity.getClass(), (Object)uddiEntity.getEntityKey());
        if (existingUddiEntity != null) {
            uddiEntity.setCreated(existingUddiEntity.getCreated());
        } else {
            uddiEntity.setCreated(now);
        }
        if (existingUddiEntity != null) {
            em.remove((Object)existingUddiEntity);
        }
    }

    private void setOperationalInfo(EntityManager em, Tmodel uddiEntity, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        uddiEntity.setAuthorizedName(publisher.getAuthorizedName());
        Date now = new Date();
        uddiEntity.setModified(now);
        uddiEntity.setModifiedIncludingChildren(now);
        String nodeId = "";
        try {
            nodeId = AppConfig.getConfiguration().getString("juddi.nodeId");
        }
        catch (ConfigurationException ce) {
            throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval", "juddi.nodeId"));
        }
        uddiEntity.setNodeId(nodeId);
        Tmodel existingUddiEntity = (Tmodel)em.find(uddiEntity.getClass(), (Object)uddiEntity.getEntityKey());
        if (existingUddiEntity != null) {
            uddiEntity.setCreated(existingUddiEntity.getCreated());
        } else {
            uddiEntity.setCreated(now);
        }
        if (existingUddiEntity != null) {
            em.remove((Object)existingUddiEntity);
        }
    }
}

