/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.math.BigInteger;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.ServiceCounterLifecycleResource;
import org.apache.juddi.api.impl.UDDIServiceCounter;
import org.apache.juddi.api.util.QueryStatus;
import org.apache.juddi.api.util.ReplicationQuery;
import org.apache.juddi.api.util.UDDIQuery;
import org.apache.juddi.validation.ValidateReplication;
import org.uddi.repl_v3.ChangeRecord;
import org.uddi.repl_v3.ChangeRecordIDType;
import org.uddi.repl_v3.DoPing;
import org.uddi.repl_v3.HighWaterMarkVectorType;
import org.uddi.repl_v3.NotifyChangeRecordsAvailable;
import org.uddi.repl_v3.TransferCustody;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDIReplicationPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDDIReplicationImpl
extends AuthenticatedService
implements UDDIReplicationPortType {
    private static Log log = LogFactory.getLog(UDDIReplicationImpl.class);
    private UDDIServiceCounter serviceCounter = ServiceCounterLifecycleResource.getServiceCounter(this.getClass());

    public String doPing(DoPing body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        long procTime = System.nanoTime() - startTime;
        this.serviceCounter.update((UDDIQuery)ReplicationQuery.DO_PING, QueryStatus.SUCCESS, procTime);
        ValidateReplication.unsupportedAPICall();
        return null;
    }

    public List<ChangeRecord> getChangeRecords(String requestingNode, HighWaterMarkVectorType changesAlreadySeen, BigInteger responseLimitCount, HighWaterMarkVectorType responseLimitVector) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        long procTime = System.nanoTime() - startTime;
        this.serviceCounter.update((UDDIQuery)ReplicationQuery.GET_CHANGERECORDS, QueryStatus.SUCCESS, procTime);
        ValidateReplication.unsupportedAPICall();
        return null;
    }

    public List<ChangeRecordIDType> getHighWaterMarks() throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        long procTime = System.nanoTime() - startTime;
        this.serviceCounter.update((UDDIQuery)ReplicationQuery.GET_HIGHWATERMARKS, QueryStatus.SUCCESS, procTime);
        ValidateReplication.unsupportedAPICall();
        return null;
    }

    public void notifyChangeRecordsAvailable(NotifyChangeRecordsAvailable body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        long procTime = System.nanoTime() - startTime;
        this.serviceCounter.update((UDDIQuery)ReplicationQuery.NOTIFY_CHANGERECORDSAVAILABLE, QueryStatus.SUCCESS, procTime);
        ValidateReplication.unsupportedAPICall();
    }

    public void transferCustody(TransferCustody body) throws DispositionReportFaultMessage {
        long startTime = System.nanoTime();
        long procTime = System.nanoTime() - startTime;
        this.serviceCounter.update((UDDIQuery)ReplicationQuery.TRANSFER_CUSTODY, QueryStatus.SUCCESS, procTime);
        ValidateReplication.unsupportedAPICall();
    }
}

