/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.query.BusinessEntityQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.uddi.api_v3.TModelBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FindBusinessByTModelKeyQuery
extends BusinessEntityQuery {
    private static Log log = LogFactory.getLog(FindBusinessByTModelKeyQuery.class);
    public static final String ENTITY_NAME_CHILD = "TmodelInstanceInfo";
    protected static String entityAliasChild = FindBusinessByTModelKeyQuery.buildAlias((String)"TmodelInstanceInfo");

    public static List<?> select(EntityManager em, FindQualifiers fq, TModelBag tModels, List<?> keysIn, DynamicQuery.Parameter ... restrictions) {
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        if (tModels == null) {
            return keysIn;
        }
        List tmodelKeys = tModels.getTModelKey();
        if (tmodelKeys == null || tmodelKeys.size() == 0) {
            return keysIn;
        }
        DynamicQuery dynamicQry = new DynamicQuery(selectSQL);
        FindBusinessByTModelKeyQuery.appendConditions((DynamicQuery)dynamicQry, (FindQualifiers)fq, (List)tmodelKeys);
        if (restrictions != null && restrictions.length > 0) {
            dynamicQry.AND().pad().appendGroupedAnd(restrictions);
        }
        return FindBusinessByTModelKeyQuery.getQueryResult((EntityManager)em, (DynamicQuery)dynamicQry, keysIn, (String)"be.entityKey");
    }

    public static void appendConditions(DynamicQuery qry, FindQualifiers fq, List<String> tmodelKeys) {
        FindBusinessByTModelKeyQuery.appendJoinTables((DynamicQuery)qry, (FindQualifiers)fq, tmodelKeys);
        qry.AND().pad().openParen().pad();
        int count = 0;
        int tblCount = -1;
        for (String tmodelKey : tmodelKeys) {
            String tmodelKeyTerm = (fq.isOrAllKeys() ? entityAliasChild + "0" : entityAliasChild + ++tblCount) + ".tmodelKey";
            qry.appendGroupedAnd(new DynamicQuery.Parameter[]{new DynamicQuery.Parameter(tmodelKeyTerm, (Object)tmodelKey, DynamicQuery.PREDICATE_EQUALS)});
            if (count + 1 < tmodelKeys.size()) {
                if (fq.isOrAllKeys()) {
                    qry.OR().pad();
                } else {
                    qry.AND().pad();
                }
            }
            ++count;
        }
        qry.closeParen().pad();
    }

    public static void appendJoinTables(DynamicQuery qry, FindQualifiers fq, List<String> tmodelKeys) {
        if (tmodelKeys != null & tmodelKeys.size() > 0) {
            qry.comma().pad().append("BusinessService bs").pad();
            qry.comma().pad().append("BindingTemplate bt").pad();
            StringBuffer thetaJoins = new StringBuffer(200);
            int tblCount = 0;
            for (int count = 0; count < tmodelKeys.size(); ++count) {
                if (count != 0) {
                    if (fq.isOrAllKeys()) continue;
                    qry.comma().pad().append("TmodelInstanceInfo " + entityAliasChild + ++tblCount).pad();
                    thetaJoins.append(entityAliasChild + (tblCount - 1) + "." + "bindingTemplate" + "." + "entityKey" + " = " + entityAliasChild + tblCount + "." + "bindingTemplate" + "." + "entityKey" + " ");
                    thetaJoins.append(DynamicQuery.OPERATOR_AND + " ");
                    continue;
                }
                qry.comma().pad().append("TmodelInstanceInfo " + entityAliasChild + tblCount).pad();
                thetaJoins.append("bt.entityKey = " + entityAliasChild + tblCount + "." + "bindingTemplate" + "." + "entityKey" + " ");
                thetaJoins.append(DynamicQuery.OPERATOR_AND + " ");
            }
            qry.WHERE().pad().openParen().pad();
            qry.append("be.entityKey = bs.businessEntity.entityKey").pad();
            qry.AND().pad().append("bs.entityKey = bt.businessService.entityKey").pad();
            qry.AND().pad();
            String thetaJoinsStr = thetaJoins.toString();
            if (thetaJoinsStr.endsWith(DynamicQuery.OPERATOR_AND + " ")) {
                thetaJoinsStr = thetaJoinsStr.substring(0, thetaJoinsStr.length() - (DynamicQuery.OPERATOR_AND + " ").length());
            }
            qry.append(thetaJoinsStr);
            qry.closeParen().pad();
        }
    }
}

