/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.rmi;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.rmi.JUDDIApiService;
import org.apache.juddi.rmi.UDDICustodyTransferService;
import org.apache.juddi.rmi.UDDIInquiryService;
import org.apache.juddi.rmi.UDDIPublicationService;
import org.apache.juddi.rmi.UDDISecurityService;
import org.apache.juddi.rmi.UDDISubscriptionListenerService;
import org.apache.juddi.rmi.UDDISubscriptionService;

public class RMIRegistration {
    public static String JUDDI = "/juddiv3";
    public static String UDDI_SECURITY_SERVICE = JUDDI + "/UDDISecurityService";
    public static String UDDI_PUBLICATION_SERVICE = JUDDI + "/UDDIPublicationService";
    public static String UDDI_INQUIRY_SERVICE = JUDDI + "/UDDIInquiryService";
    public static String UDDI_SUBSCRIPTION_SERVICE = JUDDI + "/UDDISubscriptionService";
    public static String UDDI_SUBSCRIPTION_LISTENER_SERVICE = JUDDI + "/UDDISubscriptionListenerService";
    public static String UDDI_CUSTODY_TRANSFER_SERVICE = JUDDI + "/UDDICustodyTransferService";
    public static String JUDDI_PUBLISHER_SERVICE = JUDDI + "/JUDDIApiService";
    private UDDISecurityService securityService = null;
    private UDDIPublicationService publicationService = null;
    private UDDIInquiryService inquiryService = null;
    private UDDISubscriptionService subscriptionService = null;
    private UDDISubscriptionListenerService subscriptionListenerService = null;
    private UDDICustodyTransferService custodyTransferService = null;
    private JUDDIApiService publisherService = null;
    private Log log = LogFactory.getLog(this.getClass());
    Registry registry = null;
    private static RMIRegistration registration = null;

    public static RMIRegistration getInstance(int port) throws NamingException, RemoteException {
        if (registration == null) {
            registration = new RMIRegistration(port);
        }
        return registration;
    }

    private RMIRegistration(int port) throws NamingException, RemoteException {
        this.registry = LocateRegistry.createRegistry(port);
    }

    public void register(int port) {
        try {
            this.securityService = new UDDISecurityService(port);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting " + UDDI_SECURITY_SERVICE + ", " + this.securityService.getClass()));
            }
            this.registry.bind(UDDI_SECURITY_SERVICE, (Remote)this.securityService);
            this.publicationService = new UDDIPublicationService(port);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting " + UDDI_PUBLICATION_SERVICE + ", " + this.publicationService.getClass()));
            }
            this.registry.bind(UDDI_PUBLICATION_SERVICE, (Remote)this.publicationService);
            this.inquiryService = new UDDIInquiryService(port);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting " + UDDI_INQUIRY_SERVICE + ", " + this.inquiryService.getClass()));
            }
            this.registry.bind(UDDI_INQUIRY_SERVICE, (Remote)this.inquiryService);
            this.subscriptionService = new UDDISubscriptionService(port);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting " + UDDI_SUBSCRIPTION_SERVICE + ", " + this.subscriptionService.getClass()));
            }
            this.registry.bind(UDDI_SUBSCRIPTION_SERVICE, (Remote)this.subscriptionService);
            this.subscriptionListenerService = new UDDISubscriptionListenerService(port);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting " + UDDI_SUBSCRIPTION_LISTENER_SERVICE + ", " + this.subscriptionListenerService.getClass()));
            }
            this.registry.bind(UDDI_SUBSCRIPTION_LISTENER_SERVICE, (Remote)this.subscriptionListenerService);
            this.custodyTransferService = new UDDICustodyTransferService(port);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting " + UDDI_CUSTODY_TRANSFER_SERVICE + ", " + this.custodyTransferService.getClass()));
            }
            this.registry.bind(UDDI_CUSTODY_TRANSFER_SERVICE, (Remote)this.custodyTransferService);
            this.publisherService = new JUDDIApiService(port);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting " + JUDDI_PUBLISHER_SERVICE + ", " + this.publisherService.getClass()));
            }
            this.registry.bind(JUDDI_PUBLISHER_SERVICE, (Remote)this.publisherService);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void unregister() {
        try {
            this.registry.unbind(UDDI_SECURITY_SERVICE);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.securityService = null;
        try {
            this.registry.unbind(UDDI_PUBLICATION_SERVICE);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.publicationService = null;
        try {
            this.registry.unbind(UDDI_INQUIRY_SERVICE);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.inquiryService = null;
        try {
            this.registry.unbind(UDDI_SUBSCRIPTION_SERVICE);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.subscriptionService = null;
        try {
            this.registry.unbind(UDDI_SUBSCRIPTION_LISTENER_SERVICE);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.subscriptionListenerService = null;
        try {
            this.registry.unbind(UDDI_CUSTODY_TRANSFER_SERVICE);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.custodyTransferService = null;
        try {
            this.registry.unbind(JUDDI_PUBLISHER_SERVICE);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.publisherService = null;
    }
}

