/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.auth;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.bind.JAXBException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.cryptor.Cryptor;
import org.apache.juddi.cryptor.CryptorFactory;
import org.apache.juddi.v3.auth.User;
import org.apache.juddi.v3.auth.XMLDocAuthenticator;
import org.apache.juddi.v3.error.AuthenticationException;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.UnknownUserException;

public class CryptedXMLDocAuthenticator
extends XMLDocAuthenticator {
    private Log logger = LogFactory.getLog(this.getClass());

    protected String getFilename() throws ConfigurationException {
        return AppConfig.getConfiguration().getString("juddi.usersfile", "juddi-users-encrypted.xml");
    }

    public String authenticate(String userID, String credential) throws AuthenticationException, FatalErrorException {
        this.preProcess(userID, credential);
        String encryptedCredential = this.encrypt(credential);
        return this.postProcess(userID, encryptedCredential);
    }

    private String encrypt(String str) throws FatalErrorException {
        try {
            Cryptor cryptor = CryptorFactory.getCryptor();
            return cryptor.encrypt(str);
        }
        catch (InvalidKeyException e) {
            this.logger.error((Object)"Invalid Key Exception in crypting the password", (Throwable)e);
            throw new FatalErrorException(new ErrorMessage("errors.auth.cryptor.InvalidKey", e.getMessage()));
        }
        catch (NoSuchPaddingException e) {
            this.logger.error((Object)"Padding Exception in crypting the password", (Throwable)e);
            throw new FatalErrorException(new ErrorMessage("errors.auth.cryptor.Padding", e.getMessage()));
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error((Object)"Algorithm Exception in crypting the password", (Throwable)e);
            throw new FatalErrorException(new ErrorMessage("errors.auth.cryptor.Algorithm", e.getMessage()));
        }
        catch (InvalidAlgorithmParameterException e) {
            this.logger.error((Object)"Algorithm parameter Exception in crypting the password", (Throwable)e);
            throw new FatalErrorException(new ErrorMessage("errors.auth.cryptor.AlgorithmParam", e.getMessage()));
        }
        catch (IllegalBlockSizeException e) {
            this.logger.error((Object)"Block size Exception in crypting the password", (Throwable)e);
            throw new FatalErrorException(new ErrorMessage("errors.auth.cryptor.BlockSize", e.getMessage()));
        }
        catch (BadPaddingException e) {
            this.logger.error((Object)"Bad Padding Exception in crypting the password", (Throwable)e);
            throw new FatalErrorException(new ErrorMessage("errors.auth.cryptor.BadPadding", e.getMessage()));
        }
    }

    private void preProcess(String userID, String credential) throws AuthenticationException {
        if (userID == null) {
            throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidUserId", userID));
        }
        if (credential == null) {
            throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidCredentials"));
        }
    }

    private String postProcess(String userID, String encryptedCredential) throws AuthenticationException {
        if (this.userTable.containsKey(userID)) {
            User user = (User)this.userTable.get(userID);
            if (user.getPassword() == null || !encryptedCredential.equals(user.getPassword())) {
                throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidCredentials", userID));
            }
        } else {
            throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidUserId", userID));
        }
        return userID;
    }
}

