/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.samples.buildutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class Txt2Html
extends Task {
    private File todir;
    private List<FileSet> filesets = new LinkedList<FileSet>();

    public void setTodir(File file) {
        this.todir = file;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void execute() throws BuildException {
        int n = 0;
        for (FileSet fileSet : this.filesets) {
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
            File file = directoryScanner.getBasedir();
            String[] stringArray = directoryScanner.getIncludedFiles();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                File file3 = new File(this.todir, stringArray[i] + ".html");
                if (file3.exists() && file2.lastModified() <= file3.lastModified()) continue;
                this.log("Converting file '" + file2.getAbsolutePath() + "' to '" + file3.getAbsolutePath(), 3);
                try {
                    this.convert(file2, file3);
                }
                catch (IOException iOException) {
                    throw new BuildException("Could not convert '" + file2.getAbsolutePath() + "' to '" + file3.getAbsolutePath() + "'", (Throwable)iOException);
                }
                ++n;
            }
            if (n <= 0) continue;
            this.log("Converted " + n + " file" + (n > 1 ? "s" : "") + " to " + this.todir.getAbsolutePath());
        }
    }

    private void convert(File file, File file2) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
        printWriter.println("<html><body><pre>");
        while ((string = bufferedReader.readLine()) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = string.length();
            block5: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        continue block5;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block5;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
            printWriter.println(stringBuffer.toString());
        }
        printWriter.println("</pre></body></html>");
        printWriter.close();
        bufferedReader.close();
    }
}

