/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.samples.javaee6.webfragment.fragment2;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.samples.javaee6.webfragment.fragment2.BuyRecordItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoppingCart
extends HttpServlet {
    ArrayList<BuyRecordItem> shoppingList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        this.shoppingList = null == request.getSession().getAttribute("shoppingList") ? new ArrayList() : (ArrayList)request.getSession().getAttribute("shoppingList");
        BuyRecordItem recordItem = new BuyRecordItem(Integer.parseInt(request.getParameter("ID")), Integer.parseInt(request.getParameter("quantity")));
        this.addToCart(recordItem, this.shoppingList);
        request.getSession().setAttribute("shoppingList", this.shoppingList);
        try {
            out.println("<html>");
            out.println("<head>");
            out.println("<title>Servlet ShoppingCart</title>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h1>You have already bought:</h1>");
            out.println("<table border=1>");
            out.println("<tr><th>ID</th><th>Name</th><th>Price</th><th>Quantity</th><th>Cost</th></tr>");
            int totalCost = 0;
            for (BuyRecordItem record : this.shoppingList) {
                int ID = record.getID();
                int quantity = record.getQuantity();
                int cost = ID * 10 * quantity;
                totalCost += cost;
                out.println("<tr><td>" + ID + "</td><td>Item" + ID + "</td><td>" + ID * 10 + "</td><td>" + quantity + "</td><td>" + cost + "</td></tr>");
            }
            out.println("<tr><h2>The total cost is:<font color=green>" + totalCost + "</font><h2></tr>");
            out.println("</table>");
            out.println("<a href=\"QueryAll\"><h2>>>Continue shopping!<h2></a><br>");
            out.println("<a href=\"Payment?totalCost=" + totalCost + "\">>>Go to pay!</a>");
            out.println("</body>");
            out.println("</html>");
        }
        finally {
            out.close();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    private void addToCart(BuyRecordItem currentRecordItem, ArrayList<BuyRecordItem> shoppingList) {
        int currentID = currentRecordItem.getID();
        int currentQuantity = currentRecordItem.getQuantity();
        boolean exist = false;
        for (BuyRecordItem record : shoppingList) {
            if (currentID != record.getID()) continue;
            record.setQuantity(record.getQuantity() + currentQuantity);
            exist = true;
            break;
        }
        if (!exist) {
            this.shoppingList.add(currentRecordItem);
        }
    }
}

