/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.extensions.config.converter.secure;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Optional;
import javax.annotation.Priority;
import javax.enterprise.inject.Vetoed;
import org.apache.geronimo.microprofile.extensions.config.converter.secure.MasterKey;
import org.apache.geronimo.microprofile.extensions.config.converter.secure.PBECipher;
import org.eclipse.microprofile.config.spi.Converter;

@Vetoed
@Priority(value=100)
public class CipheredStringConverter
implements Converter<String> {
    private static final String SECURE_PREFIX = "secure:";
    private final byte[] masterPassword;

    public CipheredStringConverter() {
        this(CipheredStringConverter.readMasterPassword());
    }

    protected CipheredStringConverter(byte[] pass) {
        this.masterPassword = pass;
    }

    public String convert(String value) {
        if (value == null || !value.startsWith(SECURE_PREFIX) || !this.isActive()) {
            return value;
        }
        return new PBECipher().decrypt64(value.substring(SECURE_PREFIX.length()), this.masterPassword);
    }

    public String cipher(String value) {
        try {
            return SECURE_PREFIX + new PBECipher().encrypt64(value, this.masterPassword);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean isActive() {
        return this.masterPassword != null;
    }

    private static byte[] readMasterPassword() {
        return Optional.ofNullable(System.getProperty("geronimo.microprofile.extensions.config.converter.secure.master_key.location", new File(System.getProperty("meecrowave.base", System.getProperty("catalina.base", "")), "conf/master_key").getAbsolutePath())).map(path -> Paths.get(path, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(it -> MasterKey.read(it.toAbsolutePath().toString())).orElse(null);
    }
}

