/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.extensions.config.converter.secure;

import java.util.UUID;
import java.util.stream.IntStream;
import org.apache.geronimo.microprofile.extensions.config.converter.secure.MasterKey;
import org.apache.geronimo.microprofile.extensions.config.converter.secure.PBECipher;

public class ConfigurationMain {
    private ConfigurationMain() {
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            ConfigurationMain.usage();
        }
        switch (args[0].trim()) {
            case "--encrypt": {
                ConfigurationMain.ensureArgs(args, 3);
                System.out.println("Value: 'secure:" + new PBECipher().encrypt64(args[2], MasterKey.read(args[1])) + "'");
                break;
            }
            case "--decrypt": {
                ConfigurationMain.ensureArgs(args, 3);
                System.out.println("Value: '" + new PBECipher().decrypt64(args[2], MasterKey.read(args[1])) + "'");
                break;
            }
            case "--master-key": {
                ConfigurationMain.ensureArgs(args, 2, 3);
                MasterKey.write(args[1], args.length == 2 ? UUID.randomUUID().toString() : args[2]);
                System.out.println("Generated '" + args[1] + "'");
                break;
            }
            default: {
                ConfigurationMain.usage();
            }
        }
    }

    private static void ensureArgs(String[] args, int ... len) {
        if (IntStream.of(len).noneMatch(v -> args.length == v)) {
            ConfigurationMain.usage();
        }
    }

    private static void usage() {
        throw new IllegalArgumentException("Usage:\n  java -cp secured-string-converter.jar " + ConfigurationMain.class.getName() + " \n --encrypt master_key_path value_to_encrypt\n --decrypt master_key_path value_to_decrypt\n --master-key master_key_path key_value_or_generate_an_uuid\n");
    }
}

