/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.extensions.config.converter.secure;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.Random;
import java.util.stream.IntStream;

class MasterKey {
    private static final int SIZE = Integer.getInteger("geronimo.microprofile.extensions.config.converter.secure.master_key.size", 0x200000);

    private MasterKey() {
    }

    static void write(String location, String masterKey) {
        byte[] key = masterKey.getBytes(StandardCharsets.UTF_8);
        try (DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(Paths.get(location, new String[0]), new OpenOption[0])));){
            int[] indices = new int[key.length];
            byte[] data = new byte[SIZE];
            SecureRandom secureRandom = new SecureRandom();
            new Random(System.currentTimeMillis()).nextBytes(data);
            for (int i = 0; i < key.length; ++i) {
                int index;
                indices[i] = index = secureRandom.nextInt(SIZE);
                data[index] = key[i];
            }
            stream.writeInt(key.length);
            for (int keyByte : indices) {
                stream.writeInt(keyByte);
            }
            stream.write(data);
            byte[] footer = new byte[secureRandom.nextInt(key.length)];
            secureRandom.nextBytes(footer);
            stream.write(footer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] read(String location) {
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(Files.newInputStream(Paths.get(location, new String[0]), new OpenOption[0])));){
            int len = in.readInt();
            byte[] masterKey = new byte[len];
            int[] keyIndices = new int[len];
            for (int i = 0; i < len; ++i) {
                keyIndices[i] = in.readInt();
            }
            int maxIdx = IntStream.of(keyIndices).max().orElse(0) + 1;
            byte[] data = new byte[maxIdx];
            int nbRead = in.read(data);
            if (nbRead != maxIdx) {
                throw new IllegalStateException("Corrupted master_key: '" + location + "'");
            }
            for (int i = 0; i < masterKey.length; ++i) {
                masterKey[i] = data[keyIndices[i]];
            }
            byte[] byArray = masterKey;
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

