/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.accumulo;

import java.io.IOException;
import java.util.List;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexReader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class AccumuloVertexInputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexInputFormat<I, V, E> {
    protected AccumuloInputFormat accumuloInputFormat = new AccumuloInputFormat();

    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        List splits;
        block2: {
            splits = null;
            try {
                splits = this.accumuloInputFormat.getSplits(context);
            }
            catch (IOException e) {
                if (!e.getMessage().contains("Input info has not been set")) break block2;
                throw new IOException(e.getMessage() + " Make sure you initialized" + " AccumuloInputFormat static setters " + "before passing the config to GiraphJob.");
            }
        }
        return splits;
    }

    public static abstract class AccumuloVertexReader<I extends WritableComparable, V extends Writable, E extends Writable>
    extends VertexReader<I, V, E> {
        private ImmutableClassesGiraphConfiguration<I, V, E> configuration;
        private final RecordReader<Key, Value> reader;
        private TaskAttemptContext context;

        public AccumuloVertexReader(RecordReader<Key, Value> reader) {
            this.reader = reader;
        }

        public ImmutableClassesGiraphConfiguration<I, V, E> getConfiguration() {
            return this.configuration;
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            this.reader.initialize(inputSplit, context);
            this.context = context;
            this.configuration = new ImmutableClassesGiraphConfiguration(context.getConfiguration());
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.reader.getProgress();
        }

        protected RecordReader<Key, Value> getRecordReader() {
            return this.reader;
        }

        protected TaskAttemptContext getContext() {
            return this.context;
        }
    }
}

