/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.accumulo;

import java.io.IOException;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.data.Mutation;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.VertexWriter;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class AccumuloVertexOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexOutputFormat<I, V, E> {
    public static final String OUTPUT_TABLE = "OUTPUT_TABLE";
    protected AccumuloOutputFormat accumuloOutputFormat = new AccumuloOutputFormat();

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        block2: {
            try {
                this.accumuloOutputFormat.checkOutputSpecs(context);
            }
            catch (IOException e) {
                if (!e.getMessage().contains("Output info has not been set")) break block2;
                throw new IOException(e.getMessage() + " Make sure you initialized" + " AccumuloOutputFormat static setters " + "before passing the config to GiraphJob.");
            }
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return this.accumuloOutputFormat.getOutputCommitter(context);
    }

    public static abstract class AccumuloVertexWriter<I extends WritableComparable, V extends Writable, E extends Writable>
    extends VertexWriter<I, V, E> {
        private TaskAttemptContext context;
        private RecordWriter<Text, Mutation> recordWriter;

        public AccumuloVertexWriter(RecordWriter<Text, Mutation> recordWriter) {
            this.recordWriter = recordWriter;
        }

        public void initialize(TaskAttemptContext context) throws IOException {
            this.context = context;
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.recordWriter.close(context);
        }

        public RecordWriter<Text, Mutation> getRecordWriter() {
            return this.recordWriter;
        }

        public TaskAttemptContext getContext() {
            return this.context;
        }
    }
}

