/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;

public class DDBPathMetadata
extends PathMetadata {
    private boolean isAuthoritativeDir;

    public DDBPathMetadata(PathMetadata pmd, boolean isAuthoritativeDir) {
        super(pmd.getFileStatus(), pmd.isEmptyDirectory(), pmd.isDeleted());
        this.isAuthoritativeDir = isAuthoritativeDir;
    }

    public DDBPathMetadata(PathMetadata pmd) {
        super(pmd.getFileStatus(), pmd.isEmptyDirectory(), pmd.isDeleted());
        this.isAuthoritativeDir = false;
    }

    public DDBPathMetadata(FileStatus fileStatus) {
        super(fileStatus);
        this.isAuthoritativeDir = false;
    }

    public DDBPathMetadata(FileStatus fileStatus, Tristate isEmptyDir, boolean isDeleted) {
        super(fileStatus, isEmptyDir, isDeleted);
        this.isAuthoritativeDir = false;
    }

    public DDBPathMetadata(FileStatus fileStatus, Tristate isEmptyDir, boolean isDeleted, boolean isAuthoritativeDir) {
        super(fileStatus, isEmptyDir, isDeleted);
        this.isAuthoritativeDir = isAuthoritativeDir;
    }

    public boolean isAuthoritativeDir() {
        return this.isAuthoritativeDir;
    }

    public void setAuthoritativeDir(boolean authoritativeDir) {
        this.isAuthoritativeDir = authoritativeDir;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

