/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.s3guard.DDBPathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.DynamoDBMetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;

@InterfaceAudience.Private
@InterfaceStability.Evolving
final class PathMetadataDynamoDBTranslation {
    @VisibleForTesting
    static final String PARENT = "parent";
    @VisibleForTesting
    static final String CHILD = "child";
    @VisibleForTesting
    static final String IS_DIR = "is_dir";
    @VisibleForTesting
    static final String MOD_TIME = "mod_time";
    @VisibleForTesting
    static final String FILE_LENGTH = "file_length";
    @VisibleForTesting
    static final String BLOCK_SIZE = "block_size";
    static final String IS_DELETED = "is_deleted";
    static final String IS_AUTHORITATIVE = "is_authoritative";
    @VisibleForTesting
    static final String TABLE_VERSION = "table_version";
    @VisibleForTesting
    static final String TABLE_CREATED = "table_created";
    static final String E_NOT_VERSION_MARKER = "Not a version marker: ";

    static Collection<KeySchemaElement> keySchema() {
        return Arrays.asList(new KeySchemaElement(PARENT, KeyType.HASH), new KeySchemaElement(CHILD, KeyType.RANGE));
    }

    static Collection<AttributeDefinition> attributeDefinitions() {
        return Arrays.asList(new AttributeDefinition(PARENT, ScalarAttributeType.S), new AttributeDefinition(CHILD, ScalarAttributeType.S));
    }

    static DDBPathMetadata itemToPathMetadata(Item item, String username) throws IOException {
        return PathMetadataDynamoDBTranslation.itemToPathMetadata(item, username, false);
    }

    static DDBPathMetadata itemToPathMetadata(Item item, String username, boolean ignoreIsAuthFlag) throws IOException {
        FileStatus fileStatus;
        if (item == null) {
            return null;
        }
        String parentStr = item.getString(PARENT);
        Preconditions.checkNotNull((Object)parentStr, (Object)String.format("No parent entry in item %s", item));
        String childStr = item.getString(CHILD);
        Preconditions.checkNotNull((Object)childStr, (Object)String.format("No child entry in item %s", item));
        Path rawPath = new Path(parentStr, childStr);
        if (!rawPath.isAbsoluteAndSchemeAuthorityNull()) {
            return null;
        }
        Path parent = new Path("s3a:/" + parentStr + "/");
        Path path = new Path(parent, childStr);
        boolean isDir = item.hasAttribute(IS_DIR) && item.getBoolean(IS_DIR);
        boolean isAuthoritativeDir = false;
        if (isDir) {
            if (!ignoreIsAuthFlag) {
                isAuthoritativeDir = item.hasAttribute(IS_AUTHORITATIVE) && item.getBoolean(IS_AUTHORITATIVE);
            }
            fileStatus = DynamoDBMetadataStore.makeDirStatus(path, username);
        } else {
            long len = item.hasAttribute(FILE_LENGTH) ? item.getLong(FILE_LENGTH) : 0L;
            long modTime = item.hasAttribute(MOD_TIME) ? item.getLong(MOD_TIME) : 0L;
            long block = item.hasAttribute(BLOCK_SIZE) ? item.getLong(BLOCK_SIZE) : 0L;
            fileStatus = new FileStatus(len, false, 1, block, modTime, 0L, null, username, username, path);
        }
        boolean isDeleted = item.hasAttribute(IS_DELETED) && item.getBoolean(IS_DELETED);
        return new DDBPathMetadata(fileStatus, Tristate.UNKNOWN, isDeleted, isAuthoritativeDir);
    }

    static Item pathMetadataToItem(DDBPathMetadata meta) {
        return PathMetadataDynamoDBTranslation.pathMetadataToItem(meta, false);
    }

    static Item pathMetadataToItem(DDBPathMetadata meta, boolean ignoreIsAuthFlag) {
        Preconditions.checkNotNull((Object)meta);
        FileStatus status = meta.getFileStatus();
        Item item = new Item().withPrimaryKey(PathMetadataDynamoDBTranslation.pathToKey(status.getPath()));
        if (status.isDirectory()) {
            item.withBoolean(IS_DIR, true);
            if (!ignoreIsAuthFlag) {
                item.withBoolean(IS_AUTHORITATIVE, meta.isAuthoritativeDir());
            }
        } else {
            item.withLong(FILE_LENGTH, status.getLen()).withLong(MOD_TIME, status.getModificationTime()).withLong(BLOCK_SIZE, status.getBlockSize());
        }
        item.withBoolean(IS_DELETED, meta.isDeleted());
        return item;
    }

    static Item createVersionMarker(String name, int version, long timestamp) {
        return new Item().withPrimaryKey(PathMetadataDynamoDBTranslation.createVersionMarkerPrimaryKey(name)).withInt(TABLE_VERSION, version).withLong(TABLE_CREATED, timestamp);
    }

    static PrimaryKey createVersionMarkerPrimaryKey(String name) {
        return new PrimaryKey(PARENT, (Object)name, CHILD, (Object)name);
    }

    static int extractVersionFromMarker(Item marker) throws IOException {
        if (marker.hasAttribute(TABLE_VERSION)) {
            return marker.getInt(TABLE_VERSION);
        }
        throw new IOException(E_NOT_VERSION_MARKER + marker);
    }

    static Long extractCreationTimeFromMarker(Item marker) throws IOException {
        if (marker.hasAttribute(TABLE_CREATED)) {
            return marker.getLong(TABLE_CREATED);
        }
        return null;
    }

    static Item[] pathMetadataToItem(Collection<DDBPathMetadata> metas) {
        if (metas == null) {
            return null;
        }
        Item[] items = new Item[metas.size()];
        int i = 0;
        for (DDBPathMetadata meta : metas) {
            items[i++] = PathMetadataDynamoDBTranslation.pathMetadataToItem(meta);
        }
        return items;
    }

    static KeyAttribute pathToParentKeyAttribute(Path path) {
        return new KeyAttribute(PARENT, (Object)PathMetadataDynamoDBTranslation.pathToParentKey(path));
    }

    static String pathToParentKey(Path path) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((boolean)path.isUriPathAbsolute(), (Object)"Path not absolute");
        URI uri = path.toUri();
        String bucket = uri.getHost();
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)bucket) ? 1 : 0) != 0, (Object)"Path missing bucket");
        String pKey = "/" + bucket + uri.getPath();
        if (pKey.endsWith("/")) {
            pKey = pKey.substring(0, pKey.length() - 1);
        }
        return pKey;
    }

    static PrimaryKey pathToKey(Path path) {
        Preconditions.checkArgument((!path.isRoot() ? 1 : 0) != 0, (Object)"Root path is not mapped to any PrimaryKey");
        return new PrimaryKey(PARENT, (Object)PathMetadataDynamoDBTranslation.pathToParentKey(path.getParent()), CHILD, (Object)path.getName());
    }

    static PrimaryKey[] pathToKey(Collection<Path> paths) {
        if (paths == null) {
            return null;
        }
        PrimaryKey[] keys = new PrimaryKey[paths.size()];
        int i = 0;
        for (Path p : paths) {
            keys[i++] = PathMetadataDynamoDBTranslation.pathToKey(p);
        }
        return keys;
    }

    private PathMetadataDynamoDBTranslation() {
    }

    static List<DDBPathMetadata> pathMetaToDDBPathMeta(Collection<PathMetadata> pathMetadatas) {
        return pathMetadatas.stream().map(p -> new DDBPathMetadata((PathMetadata)p)).collect(Collectors.toList());
    }
}

