/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth.delegation;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3ARetryPolicy;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentialBinding;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentialProvider;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentials;
import org.apache.hadoop.fs.s3a.auth.RoleModel;
import org.apache.hadoop.fs.s3a.auth.STSClientFactory;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractDelegationTokenBinding;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractS3ATokenIdentifier;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationConstants;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationTokenIOException;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.fs.s3a.auth.delegation.SessionTokenIdentifier;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTokenBinding
extends AbstractDelegationTokenBinding {
    private static final Logger LOG = LoggerFactory.getLogger(SessionTokenBinding.class);
    private static final String NAME = "SessionTokens/001";
    @VisibleForTesting
    public static final String CREDENTIALS_CONVERTED_TO_DELEGATION_TOKEN = "Existing session credentials converted to Delegation Token";
    public static final String SESSION_TOKEN = "Session Delegation Token";
    private Invoker invoker;
    private final AtomicBoolean stsInitAttempted = new AtomicBoolean(false);
    private Optional<STSClientFactory.STSClient> stsClient = Optional.empty();
    private long duration;
    private boolean hasSessionCreds;
    private AWSCredentialProviderList parentAuthChain;
    private final AtomicBoolean forwardMessageLogged = new AtomicBoolean(false);
    private String endpoint;
    private String region;
    private Optional<OffsetDateTime> expirationDateTime;
    private Optional<SessionTokenIdentifier> tokenIdentifier = Optional.empty();
    public static final Invoker.Retried LOG_EVENT = (text, exception, retries, idempotent) -> {
        LOG.info("{}: " + exception, (Object)text);
        if (retries == 1) {
            LOG.debug("{}: " + exception, (Object)text, (Object)exception);
        }
    };

    public SessionTokenBinding() {
        this(NAME, DelegationConstants.SESSION_TOKEN_KIND);
    }

    protected SessionTokenBinding(String name, Text kind) {
        super(name, kind);
    }

    @Override
    protected void serviceStart() throws Exception {
        super.serviceStart();
        Configuration conf = this.getConfig();
        this.duration = conf.getTimeDuration("fs.s3a.assumed.role.session.duration", "1h", TimeUnit.SECONDS);
        this.endpoint = conf.getTrimmed("fs.s3a.assumed.role.sts.endpoint", "");
        this.region = conf.getTrimmed("fs.s3a.assumed.role.sts.endpoint.region", "");
        this.parentAuthChain = S3AUtils.buildAWSProviderList(this.getCanonicalUri(), conf, "fs.s3a.aws.credentials.provider", S3AUtils.STANDARD_AWS_PROVIDERS, new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceStop() throws Exception {
        super.serviceStop();
        SessionTokenBinding sessionTokenBinding = this;
        synchronized (sessionTokenBinding) {
            this.stsClient.ifPresent(IOUtils::closeStream);
            this.stsClient = Optional.empty();
        }
    }

    @Override
    public AWSCredentialProviderList deployUnbonded() throws IOException {
        this.requireServiceStarted();
        return this.parentAuthChain;
    }

    protected Invoker getInvoker() {
        return this.invoker;
    }

    @Override
    public AWSCredentialProviderList bindToTokenIdentifier(AbstractS3ATokenIdentifier retrievedIdentifier) throws IOException {
        SessionTokenIdentifier identifier = this.convertTokenIdentifier(retrievedIdentifier, SessionTokenIdentifier.class);
        this.setTokenIdentifier(Optional.of(identifier));
        MarshalledCredentials marshalledCredentials = identifier.getMarshalledCredentials();
        this.setExpirationDateTime(marshalledCredentials.getExpirationDateTime());
        return new AWSCredentialProviderList("Session Token Binding", new MarshalledCredentialProvider(SESSION_TOKEN, this.getStoreContext().getFsURI(), this.getConfig(), marshalledCredentials, MarshalledCredentials.CredentialTypeRequired.SessionOnly));
    }

    @Override
    public String getDescription() {
        return String.format("%s token binding for user %s, with STS endpoint \"%s\", region \"%s\" and token duration %d:%02d", this.bindingName(), this.getOwner().getShortUserName(), this.endpoint, this.region, TimeUnit.SECONDS.toMinutes(this.duration), this.duration % 60L);
    }

    protected String bindingName() {
        return "Session";
    }

    @Override
    public String getUserAgentField() {
        if (this.tokenIdentifier.isPresent()) {
            return "; session ID " + this.tokenIdentifier.get().getUuid();
        }
        return "";
    }

    private synchronized Optional<STSClientFactory.STSClient> maybeInitSTS() throws IOException {
        if (this.stsInitAttempted.getAndSet(true)) {
            return this.stsClient;
        }
        Configuration conf = this.getConfig();
        URI uri = this.getCanonicalUri();
        AWSCredentials parentCredentials = Invoker.once("get credentials", "", () -> this.parentAuthChain.getCredentials());
        this.hasSessionCreds = parentCredentials instanceof AWSSessionCredentials;
        if (!this.hasSessionCreds) {
            LOG.debug("Creating STS client for {}", (Object)this.getDescription());
            this.invoker = new Invoker(new S3ARetryPolicy(conf), LOG_EVENT);
            ClientConfiguration awsConf = S3AUtils.createAwsConf(conf, uri.getHost(), "STS");
            AWSSecurityTokenService tokenService = (AWSSecurityTokenService)STSClientFactory.builder(this.parentAuthChain, awsConf, this.endpoint, this.region).build();
            this.stsClient = Optional.of(STSClientFactory.createClientConnection(tokenService, this.invoker));
        } else {
            LOG.debug("Parent-provided session credentials will be propagated");
            this.stsClient = Optional.empty();
        }
        return this.stsClient;
    }

    protected Optional<STSClientFactory.STSClient> prepareSTSClient() throws IOException {
        return this.maybeInitSTS();
    }

    public long getDuration() {
        return this.duration;
    }

    @Override
    public SessionTokenIdentifier createTokenIdentifier(Optional<RoleModel.Policy> policy, EncryptionSecrets encryptionSecrets, Text renewer) throws IOException {
        MarshalledCredentials marshalledCredentials;
        this.requireServiceStarted();
        String origin = AbstractS3ATokenIdentifier.createDefaultOriginMessage();
        Optional<STSClientFactory.STSClient> client = this.prepareSTSClient();
        if (client.isPresent()) {
            marshalledCredentials = MarshalledCredentialBinding.fromSTSCredentials(client.get().requestSessionCredentials(this.duration, TimeUnit.SECONDS));
        } else {
            if (!this.forwardMessageLogged.getAndSet(true)) {
                LOG.warn("Forwarding existing session credentials to {} -duration unknown", (Object)this.getCanonicalUri());
            }
            origin = origin + " Existing session credentials converted to Delegation Token";
            AWSCredentials awsCredentials = this.parentAuthChain.getCredentials();
            if (awsCredentials instanceof AWSSessionCredentials) {
                marshalledCredentials = MarshalledCredentialBinding.fromAWSCredentials((AWSSessionCredentials)awsCredentials);
            } else {
                throw new DelegationTokenIOException("AWS Authentication chain is no longer supplying session secrets");
            }
        }
        return new SessionTokenIdentifier(this.getKind(), this.getOwnerText(), renewer, this.getCanonicalUri(), marshalledCredentials, encryptionSecrets, origin);
    }

    @Override
    public SessionTokenIdentifier createEmptyIdentifier() {
        return new SessionTokenIdentifier();
    }

    protected Optional<OffsetDateTime> getExpirationDateTime() {
        return this.expirationDateTime;
    }

    protected void setExpirationDateTime(Optional<OffsetDateTime> expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
    }

    protected Optional<SessionTokenIdentifier> getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    protected void setTokenIdentifier(Optional<SessionTokenIdentifier> tokenIdentifier) {
        this.tokenIdentifier = tokenIdentifier;
    }
}

