/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.staging;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.commit.AbstractS3ACommitter;
import org.apache.hadoop.fs.s3a.commit.PathCommitException;
import org.apache.hadoop.fs.s3a.commit.Tasks;
import org.apache.hadoop.fs.s3a.commit.files.PendingSet;
import org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.hadoop.fs.s3a.commit.staging.ConflictResolution;
import org.apache.hadoop.fs.s3a.commit.staging.Paths;
import org.apache.hadoop.fs.s3a.commit.staging.StagingCommitter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.DurationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionedStagingCommitter
extends StagingCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionedStagingCommitter.class);
    public static final String NAME = "partitioned";

    public PartitionedStagingCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PartitionedStagingCommitter{");
        sb.append(super.toString());
        sb.append('}');
        return sb.toString();
    }

    @Override
    protected int commitTaskInternal(TaskAttemptContext context, List<? extends FileStatus> taskOutput) throws IOException {
        Path attemptPath = this.getTaskAttemptPath(context);
        Set<String> partitions = Paths.getPartitions(attemptPath, taskOutput);
        FileSystem fs = this.getDestFS();
        if (this.getConflictResolutionMode((JobContext)context, fs.getConf()) == ConflictResolution.FAIL) {
            for (String partition : partitions) {
                Path partitionPath = this.getFinalPath(partition + "/file", (JobContext)context).getParent();
                if (!fs.exists(partitionPath)) continue;
                throw this.failDestinationExists(partitionPath, "Committing task " + context.getTaskAttemptID());
            }
        }
        return super.commitTaskInternal(context, taskOutput);
    }

    @Override
    public void preCommitJob(JobContext context, AbstractS3ACommitter.ActiveCommit pending) throws IOException {
        FileSystem fs = this.getDestFS();
        Configuration fsConf = fs.getConf();
        boolean shouldPrecheckPendingFiles = true;
        switch (this.getConflictResolutionMode(context, fsConf)) {
            case FAIL: {
                break;
            }
            case APPEND: {
                break;
            }
            case REPLACE: {
                this.replacePartitions(context, pending);
                shouldPrecheckPendingFiles = false;
                break;
            }
            default: {
                throw new PathCommitException("", this.getRole() + ": unknown conflict resolution mode: " + (Object)((Object)this.getConflictResolutionMode(context, fsConf)));
            }
        }
        if (shouldPrecheckPendingFiles) {
            this.precommitCheckPendingFiles(context, pending);
        }
    }

    private void replacePartitions(JobContext context, AbstractS3ACommitter.ActiveCommit pending) throws IOException {
        ConcurrentHashMap partitions = new ConcurrentHashMap();
        FileSystem sourceFS = pending.getSourceFS();
        ExecutorService pool = this.buildThreadPool(context);
        try (DurationInfo ignored = new DurationInfo(LOG, "Replacing partitions", new Object[0]);){
            Tasks.foreach(pending.getSourceFiles()).stopOnFailure().suppressExceptions(false).executeWith(pool).run(path -> {
                PendingSet pendingSet = PendingSet.load(sourceFS, path);
                Path lastParent = null;
                for (SinglePendingCommit commit : pendingSet.getCommits()) {
                    Path parent = commit.destinationPath().getParent();
                    if (parent == null || parent.equals(lastParent)) continue;
                    partitions.put(parent, "");
                    lastParent = parent;
                }
            });
        }
        FileSystem fs = this.getDestFS();
        Tasks.foreach(partitions.keySet()).stopOnFailure().suppressExceptions(false).executeWith(pool).run(partitionPath -> {
            LOG.debug("{}: removing partition path to be replaced: " + this.getRole(), partitionPath);
            fs.delete(partitionPath, true);
        });
    }
}

