/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.S3AFileStatus;

final class InternalIterators {
    private InternalIterators() {
    }

    static final class RemoteIteratorFromIterator<T>
    implements RemoteIterator<T> {
        private final Iterator<T> source;

        RemoteIteratorFromIterator(Iterator<T> source) {
            this.source = source;
        }

        public boolean hasNext() {
            return this.source.hasNext();
        }

        public T next() {
            return this.source.next();
        }
    }

    static final class PathFromRemoteStatusIterator
    implements RemoteIterator<Path> {
        private final RemoteIterator<S3AFileStatus> source;

        PathFromRemoteStatusIterator(RemoteIterator<S3AFileStatus> source) {
            this.source = source;
        }

        public boolean hasNext() throws IOException {
            return this.source.hasNext();
        }

        public Path next() throws IOException {
            return ((S3AFileStatus)((Object)this.source.next())).getPath();
        }
    }
}

