/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.s3guard.ExpirableMetadata;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class PathMetadata
extends ExpirableMetadata {
    private S3AFileStatus fileStatus;
    private Tristate isEmptyDirectory;
    private boolean isDeleted;

    public static PathMetadata tombstone(Path path, long lastUpdated) {
        S3AFileStatus s3aStatus = new S3AFileStatus(0L, System.currentTimeMillis(), path, 0L, null, null, null);
        return new PathMetadata(s3aStatus, Tristate.UNKNOWN, true, lastUpdated);
    }

    public PathMetadata(S3AFileStatus fileStatus) {
        this(fileStatus, Tristate.UNKNOWN, false, 0L);
    }

    public PathMetadata(S3AFileStatus fileStatus, long lastUpdated) {
        this(fileStatus, Tristate.UNKNOWN, false, lastUpdated);
    }

    public PathMetadata(S3AFileStatus fileStatus, Tristate isEmptyDir) {
        this(fileStatus, isEmptyDir, false, 0L);
    }

    public PathMetadata(S3AFileStatus fileStatus, Tristate isEmptyDir, boolean isDeleted) {
        this(fileStatus, isEmptyDir, isDeleted, 0L);
    }

    public PathMetadata(S3AFileStatus fileStatus, Tristate isEmptyDir, boolean isDeleted, long lastUpdated) {
        Preconditions.checkNotNull((Object)((Object)fileStatus), (Object)"fileStatus must be non-null");
        Preconditions.checkNotNull((Object)fileStatus.getPath(), (Object)"fileStatus path must be non-null");
        Preconditions.checkArgument((boolean)fileStatus.getPath().isAbsolute(), (Object)"path must be absolute");
        Preconditions.checkArgument((lastUpdated >= 0L ? 1 : 0) != 0, (Object)"lastUpdated parameter must be greater or equal to 0.");
        this.fileStatus = fileStatus;
        this.isEmptyDirectory = isEmptyDir;
        this.isDeleted = isDeleted;
        this.setLastUpdated(lastUpdated);
    }

    public final S3AFileStatus getFileStatus() {
        return this.fileStatus;
    }

    public Tristate isEmptyDirectory() {
        return this.isEmptyDirectory;
    }

    void setIsEmptyDirectory(Tristate isEmptyDirectory) {
        this.isEmptyDirectory = isEmptyDirectory;
        this.fileStatus.setIsEmptyDirectory(isEmptyDirectory);
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    void setIsDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PathMetadata)) {
            return false;
        }
        return this.fileStatus.equals((Object)((PathMetadata)o).fileStatus);
    }

    public int hashCode() {
        return this.fileStatus.hashCode();
    }

    public String toString() {
        return "PathMetadata{fileStatus=" + (Object)((Object)this.fileStatus) + "; isEmptyDirectory=" + (Object)((Object)this.isEmptyDirectory) + "; isDeleted=" + this.isDeleted + "; lastUpdated=" + super.getLastUpdated() + '}';
    }

    public void prettyPrint(StringBuilder sb) {
        sb.append(String.format("%-5s %-20s %-7d %-8s %-6s %-20s %-20s", this.fileStatus.isDirectory() ? "dir" : "file", this.fileStatus.getPath().toString(), this.fileStatus.getLen(), this.isEmptyDirectory.name(), this.isDeleted, this.fileStatus.getETag(), this.fileStatus.getVersionId()));
        sb.append((Object)this.fileStatus);
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        this.prettyPrint(sb);
        return sb.toString();
    }
}

