/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit;

import com.amazonaws.services.s3.model.MultipartUpload;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.commit.CommitOperations;
import org.apache.hadoop.fs.s3a.commit.CommitUtils;
import org.apache.hadoop.fs.s3a.commit.CommitUtilsWithMR;
import org.apache.hadoop.fs.s3a.commit.PathCommitException;
import org.apache.hadoop.fs.s3a.commit.Tasks;
import org.apache.hadoop.fs.s3a.commit.files.PendingSet;
import org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.hadoop.fs.s3a.commit.files.SuccessData;
import org.apache.hadoop.fs.s3a.statistics.CommitterStatistics;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractS3ACommitter
extends PathOutputCommitter
implements IOStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractS3ACommitter.class);
    public static final String THREAD_PREFIX = "s3a-committer-pool-";
    @VisibleForTesting
    public static final String E_SELF_GENERATED_JOB_UUID = "has a self-generated job UUID";
    private final String uuid;
    private final JobUUIDSource uuidSource;
    private boolean jobSetup;
    private ExecutorService threadPool;
    private final CommitOperations commitOperations;
    private Path outputPath;
    private final String role;
    private Path workPath;
    private Configuration conf;
    private FileSystem destFS;
    private final JobContext jobContext;
    private final boolean createJobMarker;
    private final CommitterStatistics committerStatistics;

    protected AbstractS3ACommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        Preconditions.checkArgument((outputPath != null ? 1 : 0) != 0, (Object)"null output path");
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"null job context");
        this.jobContext = context;
        this.role = "Task committer " + context.getTaskAttemptID();
        this.setConf(context.getConfiguration());
        Pair<String, JobUUIDSource> id = AbstractS3ACommitter.buildJobUUID(this.conf, context.getJobID());
        this.uuid = (String)id.getLeft();
        this.uuidSource = (JobUUIDSource)((Object)id.getRight());
        LOG.info("Job UUID {} source {}", (Object)this.getUUID(), (Object)this.getUUIDSource().getText());
        this.initOutput(outputPath);
        LOG.debug("{} instantiated for job \"{}\" ID {} with destination {}", new Object[]{this.role, CommitUtilsWithMR.jobName((JobContext)context), CommitUtilsWithMR.jobIdString((JobContext)context), outputPath});
        S3AFileSystem fs = this.getDestS3AFS();
        this.createJobMarker = context.getConfiguration().getBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", true);
        this.committerStatistics = fs.newCommitterStatistics();
        this.commitOperations = new CommitOperations(fs, this.committerStatistics);
    }

    @VisibleForTesting
    protected void initOutput(Path out) throws IOException {
        FileSystem fs = this.getDestinationFS(out, this.getConf());
        this.setDestFS(fs);
        this.setOutputPath(fs.makeQualified(out));
    }

    public final JobContext getJobContext() {
        return this.jobContext;
    }

    public final Path getOutputPath() {
        return this.outputPath;
    }

    protected final void setOutputPath(Path outputPath) {
        Preconditions.checkNotNull((Object)outputPath, (Object)"Null output path");
        this.outputPath = outputPath;
    }

    public final Path getWorkPath() {
        return this.workPath;
    }

    protected final void setWorkPath(Path workPath) {
        LOG.debug("Setting work path to {}", (Object)workPath);
        this.workPath = workPath;
    }

    public final Configuration getConf() {
        return this.conf;
    }

    protected final void setConf(Configuration conf) {
        this.conf = conf;
    }

    public FileSystem getDestFS() throws IOException {
        if (this.destFS == null) {
            FileSystem fs = this.getDestinationFS(this.outputPath, this.getConf());
            this.setDestFS(fs);
        }
        return this.destFS;
    }

    public S3AFileSystem getDestS3AFS() throws IOException {
        return (S3AFileSystem)this.getDestFS();
    }

    protected void setDestFS(FileSystem destFS) {
        this.destFS = destFS;
    }

    public Path getJobAttemptPath(JobContext context) {
        return this.getJobAttemptPath(CommitUtilsWithMR.getAppAttemptId(context));
    }

    protected abstract Path getJobAttemptPath(int var1);

    public Path getTaskAttemptPath(TaskAttemptContext context) {
        return this.getBaseTaskAttemptPath(context);
    }

    protected abstract Path getBaseTaskAttemptPath(TaskAttemptContext var1);

    public abstract Path getTempTaskAttemptPath(TaskAttemptContext var1);

    public abstract String getName();

    @VisibleForTesting
    public final String getUUID() {
        return this.uuid;
    }

    @VisibleForTesting
    public final JobUUIDSource getUUIDSource() {
        return this.uuidSource;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AbstractS3ACommitter{");
        sb.append("role=").append(this.role);
        sb.append(", name=").append(this.getName());
        sb.append(", outputPath=").append(this.getOutputPath());
        sb.append(", workPath=").append(this.workPath);
        sb.append(", uuid='").append(this.getUUID()).append('\'');
        sb.append(", uuid source=").append((Object)this.getUUIDSource());
        sb.append('}');
        return sb.toString();
    }

    protected FileSystem getDestinationFS(Path out, Configuration config) throws IOException {
        return CommitUtils.getS3AFileSystem(out, config, this.requiresDelayedCommitOutputInFileSystem());
    }

    protected boolean requiresDelayedCommitOutputInFileSystem() {
        return false;
    }

    public void recoverTask(TaskAttemptContext taskContext) throws IOException {
        LOG.warn("Cannot recover task {}", (Object)taskContext.getTaskAttemptID());
        throw new PathCommitException(this.outputPath, String.format("Unable to recover task %s", taskContext.getTaskAttemptID()));
    }

    protected void maybeCreateSuccessMarkerFromCommits(JobContext context, ActiveCommit pending) throws IOException {
        ArrayList<String> filenames = new ArrayList<String>(pending.size());
        filenames.addAll(pending.committedObjects);
        IOStatisticsSnapshot snapshot = new IOStatisticsSnapshot((IOStatistics)pending.getIOStatistics());
        snapshot.aggregate(this.getIOStatistics());
        this.maybeCreateSuccessMarker(context, filenames, snapshot);
    }

    protected void maybeCreateSuccessMarker(JobContext context, List<String> filenames, IOStatisticsSnapshot ioStatistics) throws IOException {
        if (this.createJobMarker) {
            SuccessData successData = new SuccessData();
            successData.setCommitter(this.getName());
            successData.setJobId(this.uuid);
            successData.setJobIdSource(this.uuidSource.getText());
            successData.setDescription(this.getRole());
            successData.setHostname(NetUtils.getLocalHostname());
            Date now = new Date();
            successData.setTimestamp(now.getTime());
            successData.setDate(now.toString());
            successData.setFilenames(filenames);
            successData.getIOStatistics().aggregate((IOStatistics)ioStatistics);
            this.commitOperations.createSuccessMarker(this.getOutputPath(), successData, true);
        }
    }

    public void setupJob(JobContext context) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Job %s setting up", new Object[]{this.getUUID()});){
            this.jobSetup = true;
            Configuration c = context.getConfiguration();
            c.set("fs.s3a.committer.uuid", this.getUUID());
            c.set("fs.s3a.committer.uuid.source", this.getUUIDSource().getText());
            Path dest = this.getOutputPath();
            if (this.createJobMarker) {
                this.commitOperations.deleteSuccessMarker(dest);
            }
            this.getDestFS().mkdirs(dest);
            this.warnOnActiveUploads(dest);
        }
    }

    public void setupTask(TaskAttemptContext context) throws IOException {
        TaskAttemptID attemptID = context.getTaskAttemptID();
        try (DurationInfo d = new DurationInfo(LOG, "Setup Task %s", new Object[]{attemptID});){
            if (!this.jobSetup && this.getUUIDSource() == JobUUIDSource.GeneratedLocally) {
                throw new PathCommitException(this.getOutputPath().toString(), "Task attempt " + attemptID + " " + E_SELF_GENERATED_JOB_UUID);
            }
            Path taskAttemptPath = this.getTaskAttemptPath(context);
            FileSystem fs = taskAttemptPath.getFileSystem(this.getConf());
            fs.mkdirs(taskAttemptPath);
        }
    }

    protected FileSystem getTaskAttemptFilesystem(TaskAttemptContext context) throws IOException {
        return this.getTaskAttemptPath(context).getFileSystem(this.getConf());
    }

    protected void commitPendingUploads(JobContext context, ActiveCommit pending) throws IOException {
        if (pending.isEmpty()) {
            LOG.warn("{}: No pending uploads to commit", (Object)this.getRole());
        }
        try (DurationInfo ignored = new DurationInfo(LOG, "committing the output of %s task(s)", new Object[]{pending.size()});
             CommitOperations.CommitContext commitContext = this.initiateCommitOperation();){
            Tasks.foreach(pending.getSourceFiles()).stopOnFailure().suppressExceptions(false).executeWith(this.buildSubmitter(context)).abortWith(status -> this.loadAndAbort(commitContext, pending, (FileStatus)status, true, false)).revertWith(status -> this.loadAndRevert(commitContext, pending, (FileStatus)status)).run(status -> this.loadAndCommit(commitContext, pending, (FileStatus)status));
        }
    }

    protected void precommitCheckPendingFiles(JobContext context, ActiveCommit pending) throws IOException {
        FileSystem sourceFS = pending.getSourceFS();
        try (DurationInfo ignored = new DurationInfo(LOG, "Preflight Load of pending files", new Object[0]);){
            Tasks.foreach(pending.getSourceFiles()).stopOnFailure().suppressExceptions(false).executeWith(this.buildSubmitter(context)).run(status -> PendingSet.load(sourceFS, status));
        }
    }

    private void loadAndCommit(CommitOperations.CommitContext commitContext, ActiveCommit activeCommit, FileStatus status) throws IOException {
        Path path = status.getPath();
        try (DurationInfo ignored = new DurationInfo(LOG, "Loading and committing files in pendingset %s", new Object[]{path});){
            PendingSet pendingSet = PendingSet.load(activeCommit.getSourceFS(), status);
            String jobId = pendingSet.getJobId();
            if (!StringUtils.isEmpty((CharSequence)jobId) && !this.getUUID().equals(jobId)) {
                throw new PathCommitException(path, String.format("Mismatch in Job ID (%s) and commit job ID (%s)", this.getUUID(), jobId));
            }
            Tasks.foreach(pendingSet.getCommits()).stopOnFailure().suppressExceptions(false).executeWith(this.singleThreadSubmitter()).onFailure((commit, exception) -> commitContext.abortSingleCommit((SinglePendingCommit)commit)).abortWith(commitContext::abortSingleCommit).revertWith(commitContext::revertCommit).run(commit -> {
                commitContext.commitOrFail((SinglePendingCommit)commit);
                activeCommit.uploadCommitted(commit.getDestinationKey(), commit.getLength());
            });
            activeCommit.pendingsetCommitted((IOStatistics)pendingSet.getIOStatistics());
        }
    }

    private void loadAndRevert(CommitOperations.CommitContext commitContext, ActiveCommit activeCommit, FileStatus status) throws IOException {
        Path path = status.getPath();
        try (DurationInfo ignored = new DurationInfo(LOG, false, "Committing %s", new Object[]{path});){
            PendingSet pendingSet = PendingSet.load(activeCommit.getSourceFS(), status);
            Tasks.foreach(pendingSet.getCommits()).suppressExceptions(true).run(commitContext::revertCommit);
        }
    }

    private void loadAndAbort(CommitOperations.CommitContext commitContext, ActiveCommit activeCommit, FileStatus status, boolean suppressExceptions, boolean deleteRemoteFiles) throws IOException {
        Path path = status.getPath();
        try (DurationInfo ignored = new DurationInfo(LOG, false, "Aborting %s", new Object[]{path});){
            PendingSet pendingSet = PendingSet.load(activeCommit.getSourceFS(), status);
            FileSystem fs = this.getDestFS();
            Tasks.foreach(pendingSet.getCommits()).executeWith(this.singleThreadSubmitter()).suppressExceptions(suppressExceptions).run(commit -> {
                block2: {
                    try {
                        commitContext.abortSingleCommit((SinglePendingCommit)commit);
                    }
                    catch (FileNotFoundException e) {
                        if (!deleteRemoteFiles) break block2;
                        fs.delete(commit.destinationPath(), false);
                    }
                }
            });
        }
    }

    protected CommitOperations.CommitContext initiateCommitOperation() throws IOException {
        return this.getCommitOperations().initiateCommitOperation(this.getOutputPath());
    }

    protected void commitJobInternal(JobContext context, ActiveCommit pending) throws IOException {
        IOStatisticsBinding.trackDurationOfInvocation((DurationTrackerFactory)this.committerStatistics, (String)Statistic.COMMITTER_COMMIT_JOB.getSymbol(), () -> this.commitPendingUploads(context, pending));
    }

    public void abortJob(JobContext context, JobStatus.State state) throws IOException {
        LOG.info("{}: aborting job {} in state {}", new Object[]{this.getRole(), CommitUtilsWithMR.jobIdString(context), state});
        this.abortJobInternal(context, false);
    }

    protected void abortJobInternal(JobContext context, boolean suppressExceptions) throws IOException {
        this.cleanup(context, suppressExceptions);
    }

    protected void abortPendingUploadsInCleanup(boolean suppressExceptions) throws IOException {
        if (!this.shouldAbortUploadsInCleanup()) {
            LOG.debug("Not cleanup up pending uploads to {} as {} is false ", (Object)this.getOutputPath(), (Object)"fs.s3a.committer.abort.pending.uploads");
            return;
        }
        Path dest = this.getOutputPath();
        try (DurationInfo ignored = new DurationInfo(LOG, "Aborting all pending commits under %s", new Object[]{dest});
             CommitOperations.CommitContext commitContext = this.initiateCommitOperation();){
            List<MultipartUpload> pending;
            CommitOperations ops = this.getCommitOperations();
            try {
                pending = ops.listPendingUploadsUnderPath(dest);
            }
            catch (IOException e) {
                this.maybeIgnore(suppressExceptions, "aborting pending uploads", e);
                if (commitContext != null) {
                    if (var6_8 != null) {
                        try {
                            commitContext.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        commitContext.close();
                    }
                }
                if (ignored != null) {
                    if (var4_4 != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        ignored.close();
                    }
                }
                return;
            }
            if (!pending.isEmpty()) {
                LOG.warn("{} pending uploads were found -aborting", (Object)pending.size());
                LOG.warn("If other tasks/jobs are writing to {},this action may cause them to fail", (Object)dest);
                Tasks.foreach(pending).executeWith(this.buildSubmitter(this.getJobContext())).suppressExceptions(suppressExceptions).run(u -> commitContext.abortMultipartCommit(u.getKey(), u.getUploadId()));
            } else {
                LOG.info("No pending uploads were found");
            }
        }
    }

    private boolean shouldAbortUploadsInCleanup() {
        return this.getConf().getBoolean("fs.s3a.committer.abort.pending.uploads", true);
    }

    @VisibleForTesting
    public void preCommitJob(JobContext context, ActiveCommit pending) throws IOException {
    }

    public void commitJob(JobContext context) throws IOException {
        String id = CommitUtilsWithMR.jobIdString(context);
        try (DurationInfo d = new DurationInfo(LOG, "%s: commitJob(%s)", new Object[]{this.getRole(), id});){
            ActiveCommit pending = this.listPendingUploadsToCommit(context);
            this.preCommitJob(context, pending);
            this.commitJobInternal(context, pending);
            this.jobCompleted(true);
            this.maybeCreateSuccessMarkerFromCommits(context, pending);
            this.cleanup(context, false);
        }
        catch (IOException e) {
            LOG.warn("Commit failure for job {}", (Object)id, (Object)e);
            this.jobCompleted(false);
            this.abortJobInternal(context, true);
            throw e;
        }
    }

    protected void jobCompleted(boolean success) {
        this.getCommitOperations().jobCompleted(success);
    }

    public abstract void cleanupStagingDirs();

    protected abstract ActiveCommit listPendingUploadsToCommit(JobContext var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup(JobContext context, boolean suppressExceptions) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Cleanup job %s", new Object[]{CommitUtilsWithMR.jobIdString(context)});){
            this.abortPendingUploadsInCleanup(suppressExceptions);
        }
        finally {
            this.destroyThreadPool();
            this.cleanupStagingDirs();
        }
    }

    public void cleanupJob(JobContext context) throws IOException {
        String r = this.getRole();
        String id = CommitUtilsWithMR.jobIdString(context);
        LOG.warn("{}: using deprecated cleanupJob call for {}", (Object)r, (Object)id);
        try (DurationInfo d = new DurationInfo(LOG, "%s: cleanup Job %s", new Object[]{r, id});){
            this.cleanup(context, true);
        }
    }

    protected void maybeIgnore(boolean suppress, String action, Invoker.VoidOperation operation) throws IOException {
        if (suppress) {
            Invoker.ignoreIOExceptions(LOG, action, "", operation);
        } else {
            operation.execute();
        }
    }

    protected void maybeIgnore(boolean suppress, String action, IOException ex) throws IOException {
        if (!suppress) {
            throw ex;
        }
        LOG.debug(action, (Throwable)ex);
    }

    protected CommitOperations getCommitOperations() {
        return this.commitOperations;
    }

    protected String getRole() {
        return this.role;
    }

    protected Tasks.Submitter buildSubmitter(JobContext context) {
        if (this.getThreadCount(context) > 0) {
            return new PoolSubmitter(context);
        }
        return null;
    }

    private synchronized ExecutorService buildThreadPool(JobContext context, int numThreads) {
        Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0, (Object)"Cannot create a thread pool with no threads");
        if (this.threadPool == null) {
            LOG.debug("{}: creating thread pool of size {}", (Object)this.getRole(), (Object)numThreads);
            this.threadPool = HadoopExecutors.newFixedThreadPool((int)numThreads, (ThreadFactory)new ThreadFactoryBuilder().setDaemon(true).setNameFormat(THREAD_PREFIX + context.getJobID() + "-%d").build());
        }
        return this.threadPool;
    }

    private int getThreadCount(JobContext context) {
        return context.getConfiguration().getInt("fs.s3a.committer.threads", 8);
    }

    private synchronized Future<?> submitRunnable(JobContext context, Runnable task) {
        return this.buildThreadPool(context, this.getThreadCount(context)).submit(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyThreadPool() {
        ExecutorService pool;
        AbstractS3ACommitter abstractS3ACommitter = this;
        synchronized (abstractS3ACommitter) {
            pool = this.threadPool;
            this.threadPool = null;
        }
        if (pool != null) {
            LOG.debug("Destroying thread pool");
            HadoopExecutors.shutdown((ExecutorService)pool, (Logger)LOG, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    protected final synchronized Tasks.Submitter singleThreadSubmitter() {
        return null;
    }

    public synchronized boolean hasThreadPool() {
        return this.threadPool != null;
    }

    protected void deleteTaskAttemptPathQuietly(TaskAttemptContext context) {
        Path attemptPath = this.getBaseTaskAttemptPath(context);
        Invoker.ignoreIOExceptions(LOG, "Delete task attempt path", attemptPath.toString(), () -> S3AUtils.deleteQuietly(this.getTaskAttemptFilesystem(context), attemptPath, true));
    }

    protected void abortPendingUploads(JobContext context, List<SinglePendingCommit> pending, boolean suppressExceptions) throws IOException {
        if (pending == null || pending.isEmpty()) {
            LOG.info("{}: no pending commits to abort", (Object)this.getRole());
        } else {
            try (DurationInfo d = new DurationInfo(LOG, "Aborting %s uploads", new Object[]{pending.size()});
                 CommitOperations.CommitContext commitContext = this.initiateCommitOperation();){
                Tasks.foreach(pending).executeWith(this.buildSubmitter(context)).suppressExceptions(suppressExceptions).run(commitContext::abortSingleCommit);
            }
        }
    }

    protected void abortPendingUploads(JobContext context, ActiveCommit pending, boolean suppressExceptions, boolean deleteRemoteFiles) throws IOException {
        if (pending.isEmpty()) {
            LOG.info("{}: no pending commits to abort", (Object)this.getRole());
        } else {
            try (DurationInfo d = new DurationInfo(LOG, "Aborting %s uploads", new Object[]{pending.size()});
                 CommitOperations.CommitContext commitContext = this.initiateCommitOperation();){
                Tasks.foreach(pending.getSourceFiles()).executeWith(this.buildSubmitter(context)).suppressExceptions(suppressExceptions).run(path -> this.loadAndAbort(commitContext, pending, (FileStatus)path, suppressExceptions, deleteRemoteFiles));
            }
        }
    }

    public IOStatistics getIOStatistics() {
        return this.committerStatistics.getIOStatistics();
    }

    protected void warnOnActiveUploads(Path path) {
        List<MultipartUpload> pending;
        try {
            pending = this.getCommitOperations().listPendingUploadsUnderPath(path);
        }
        catch (IOException e) {
            LOG.debug("Failed to list uploads under {}", (Object)path, (Object)e);
            return;
        }
        if (!pending.isEmpty()) {
            LOG.warn("{} active upload(s) in progress under {}", (Object)pending.size(), (Object)path);
            LOG.warn("Either jobs are running concurrently or failed jobs are not being cleaned up");
            DateFormat df = DateFormat.getDateTimeInstance();
            pending.forEach(u -> LOG.info("[{}] {}", (Object)df.format(u.getInitiated()), (Object)u.getKey()));
            if (this.shouldAbortUploadsInCleanup()) {
                LOG.warn("This committer will abort these uploads in job cleanup");
            }
        }
    }

    public static Pair<String, JobUUIDSource> buildJobUUID(Configuration conf, JobID jobId) throws PathCommitException {
        String jobUUID = conf.getTrimmed("fs.s3a.committer.uuid", "");
        if (!jobUUID.isEmpty()) {
            return Pair.of((Object)jobUUID, (Object)((Object)JobUUIDSource.CommitterUUIDProperty));
        }
        jobUUID = conf.getTrimmed("spark.sql.sources.writeJobUUID", "");
        if (!jobUUID.isEmpty()) {
            return Pair.of((Object)jobUUID, (Object)((Object)JobUUIDSource.SparkWriteUUID));
        }
        if (conf.getBoolean("fs.s3a.committer.require.uuid", false)) {
            throw new PathCommitException("", "Job/task context does not contain a unique ID in spark.sql.sources.writeJobUUID");
        }
        if (conf.getBoolean("fs.s3a.committer.generate.uuid", false)) {
            String newId = UUID.randomUUID().toString();
            LOG.warn("No job ID in configuration; generating a random ID: {}", (Object)newId);
            return Pair.of((Object)newId, (Object)((Object)JobUUIDSource.GeneratedLocally));
        }
        return Pair.of((Object)jobId.toString(), (Object)((Object)JobUUIDSource.JobID));
    }

    public static class ActiveCommit {
        private static final ActiveCommit EMPTY = new ActiveCommit(null, new ArrayList());
        private final List<FileStatus> sourceFiles;
        private final FileSystem sourceFS;
        private final List<String> committedObjects = new ArrayList<String>();
        private int committedObjectCount;
        private long committedBytes;
        private final IOStatisticsSnapshot ioStatistics = new IOStatisticsSnapshot();

        public ActiveCommit(FileSystem sourceFS, List<? extends FileStatus> sourceFiles) {
            this.sourceFiles = sourceFiles;
            this.sourceFS = sourceFS;
        }

        public static ActiveCommit fromStatusList(FileSystem pendingFS, List<? extends FileStatus> statuses) {
            return new ActiveCommit(pendingFS, statuses);
        }

        public static ActiveCommit empty() {
            return EMPTY;
        }

        public List<FileStatus> getSourceFiles() {
            return this.sourceFiles;
        }

        public FileSystem getSourceFS() {
            return this.sourceFS;
        }

        public synchronized void uploadCommitted(String key, long size) {
            if (this.committedObjects.size() < 100) {
                this.committedObjects.add(key.startsWith("/") ? key : "/" + key);
            }
            ++this.committedObjectCount;
            this.committedBytes += size;
        }

        public void pendingsetCommitted(IOStatistics sourceStatistics) {
            this.ioStatistics.aggregate(sourceStatistics);
        }

        public IOStatisticsSnapshot getIOStatistics() {
            return this.ioStatistics;
        }

        public synchronized List<String> getCommittedObjects() {
            return this.committedObjects;
        }

        public synchronized int getCommittedFileCount() {
            return this.committedObjectCount;
        }

        public synchronized long getCommittedBytes() {
            return this.committedBytes;
        }

        public int size() {
            return this.sourceFiles.size();
        }

        public boolean isEmpty() {
            return this.sourceFiles.isEmpty();
        }

        public void add(FileStatus status) {
            this.sourceFiles.add(status);
        }
    }

    public static enum JobUUIDSource {
        SparkWriteUUID("spark.sql.sources.writeJobUUID"),
        CommitterUUIDProperty("fs.s3a.committer.uuid"),
        JobID("JobID"),
        GeneratedLocally("Generated Locally");

        private final String text;

        private JobUUIDSource(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("JobUUIDSource{");
            sb.append("text='").append(this.text).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    private final class PoolSubmitter
    implements Tasks.Submitter {
        private final JobContext context;
        private final int numThreads;

        private PoolSubmitter(JobContext context) {
            this.numThreads = AbstractS3ACommitter.this.getThreadCount(context);
            Preconditions.checkArgument((this.numThreads > 0 ? 1 : 0) != 0, (Object)"Cannot create a thread pool with no threads");
            this.context = context;
        }

        @Override
        public Future<?> submit(Runnable task) {
            return AbstractS3ACommitter.this.submitRunnable(this.context, task);
        }
    }
}

