/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.IOException;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.auth.AbstractSessionCredentialsProvider;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentialBinding;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentials;
import org.apache.hadoop.fs.s3a.auth.NoAwsCredentialsException;
import software.amazon.awssdk.auth.credentials.AwsCredentials;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TemporaryAWSCredentialsProvider
extends AbstractSessionCredentialsProvider {
    public static final String NAME = "org.apache.hadoop.fs.s3a.TemporaryAWSCredentialsProvider";
    public static final String COMPONENT = "Session credentials in Hadoop configuration";

    public TemporaryAWSCredentialsProvider(Configuration conf) throws IOException {
        this(null, conf);
    }

    public TemporaryAWSCredentialsProvider(@Nullable URI uri, Configuration conf) throws IOException {
        super(uri, conf);
    }

    @Override
    protected AwsCredentials createCredentials(Configuration config) throws IOException {
        MarshalledCredentials.CredentialTypeRequired sessionOnly;
        MarshalledCredentials creds = MarshalledCredentialBinding.fromFileSystem(this.getUri(), config);
        if (!creds.isValid(sessionOnly = MarshalledCredentials.CredentialTypeRequired.SessionOnly)) {
            throw new NoAwsCredentialsException(COMPONENT);
        }
        return MarshalledCredentialBinding.toAWSCredentials(creds, sessionOnly, COMPONENT);
    }
}

