/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.azure.datalake.store.ADLStoreClient;
import com.microsoft.azure.datalake.store.ADLStoreOptions;
import com.microsoft.azure.datalake.store.DirectoryEntry;
import com.microsoft.azure.datalake.store.DirectoryEntryType;
import com.microsoft.azure.datalake.store.IfExists;
import com.microsoft.azure.datalake.store.LatencyTracker;
import com.microsoft.azure.datalake.store.UserGroupRepresentation;
import com.microsoft.azure.datalake.store.acl.AclEntry;
import com.microsoft.azure.datalake.store.acl.AclStatus;
import com.microsoft.azure.datalake.store.oauth2.AccessTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.ClientCredsTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.RefreshTokenBasedTokenProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.AdlFsInputStream;
import org.apache.hadoop.fs.adl.AdlFsOutputStream;
import org.apache.hadoop.fs.adl.AdlPermission;
import org.apache.hadoop.fs.adl.SdkTokenProviderAdapter;
import org.apache.hadoop.fs.adl.TokenProviderType;
import org.apache.hadoop.fs.adl.oauth2.AzureADTokenProvider;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.VersionInfo;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AdlFileSystem
extends FileSystem {
    static final String SCHEME = "adl";
    static final int DEFAULT_PORT = 443;
    private URI uri;
    private String userName;
    private boolean overrideOwner;
    private ADLStoreClient adlClient;
    private Path workingDirectory;
    private boolean aclBitStatus;
    private UserGroupRepresentation oidOrUpn;
    private AccessTokenProvider tokenProvider;
    private AzureADTokenProvider azureTokenProvider;

    public String getScheme() {
        return SCHEME;
    }

    public URI getUri() {
        return this.uri;
    }

    public int getDefaultPort() {
        return 443;
    }

    public boolean supportsSymlinks() {
        return false;
    }

    public void initialize(URI storeUri, Configuration conf) throws IOException {
        boolean enableUPN;
        super.initialize(storeUri, conf);
        this.setConf(conf);
        this.uri = URI.create(storeUri.getScheme() + "://" + storeUri.getAuthority());
        try {
            this.userName = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException e) {
            this.userName = "hadoop";
        }
        this.setWorkingDirectory(this.getHomeDirectory());
        this.overrideOwner = this.getConf().getBoolean("adl.debug.override.localuserasfileowner", false);
        this.aclBitStatus = conf.getBoolean("adl.feature.support.acl.bit", true);
        String accountFQDN = null;
        String mountPoint = null;
        String hostname = storeUri.getHost();
        if (!hostname.contains(".") && !hostname.equalsIgnoreCase("localhost")) {
            String hostNameProperty = "dfs.adls." + hostname + ".hostname";
            String mountPointProperty = "dfs.adls." + hostname + ".mountpoint";
            accountFQDN = AdlFileSystem.getNonEmptyVal(conf, hostNameProperty);
            mountPoint = AdlFileSystem.getNonEmptyVal(conf, mountPointProperty);
        } else {
            accountFQDN = hostname;
        }
        if (storeUri.getPort() > 0) {
            accountFQDN = accountFQDN + ":" + storeUri.getPort();
        }
        this.adlClient = ADLStoreClient.createClient((String)accountFQDN, (AccessTokenProvider)this.getAccessTokenProvider(conf));
        ADLStoreOptions options = new ADLStoreOptions();
        options.enableThrowingRemoteExceptions();
        if (this.getTransportScheme().equalsIgnoreCase("http")) {
            options.setInsecureTransport();
        }
        if (mountPoint != null) {
            options.setFilePathPrefix(mountPoint);
        }
        String clusterName = conf.get("adl.events.tracking.clustername", "UNKNOWN");
        String clusterType = conf.get("adl.events.tracking.clustertype", "UNKNOWN");
        String clientVersion = "hadoop-azure-datalake-" + (StringUtils.isEmpty((String)VersionInfo.getVersion().trim()) ? "2.0.0-SNAPSHOT".trim() : VersionInfo.getVersion().trim());
        options.setUserAgentSuffix(clientVersion + "/" + VersionInfo.getVersion().trim() + "/" + clusterName + "/" + clusterType);
        this.adlClient.setOptions(options);
        boolean trackLatency = conf.getBoolean("adl.dfs.enable.client.latency.tracker", true);
        if (!trackLatency) {
            LatencyTracker.disable();
        }
        this.oidOrUpn = (enableUPN = conf.getBoolean("adl.feature.ownerandgroup.enableupn", false)) ? UserGroupRepresentation.UPN : UserGroupRepresentation.OID;
    }

    protected synchronized AzureADTokenProvider getCustomAccessTokenProvider(Configuration conf) throws IOException {
        String className = AdlFileSystem.getNonEmptyVal(conf, "dfs.adls.oauth2.access.token.provider");
        Class azureADTokenProviderClass = conf.getClass("dfs.adls.oauth2.access.token.provider", null, AzureADTokenProvider.class);
        if (azureADTokenProviderClass == null) {
            throw new IllegalArgumentException("Configuration  " + className + " " + "not defined/accessible.");
        }
        this.azureTokenProvider = (AzureADTokenProvider)ReflectionUtils.newInstance((Class)azureADTokenProviderClass, (Configuration)conf);
        if (this.azureTokenProvider == null) {
            throw new IllegalArgumentException("Failed to initialize " + className);
        }
        this.azureTokenProvider.initialize(conf);
        return this.azureTokenProvider;
    }

    private AccessTokenProvider getAccessTokenProvider(Configuration config) throws IOException {
        Configuration conf = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)config, AdlFileSystem.class);
        TokenProviderType type = (TokenProviderType)conf.getEnum("dfs.adls.oauth2.access.token.provider.type", (Enum)TokenProviderType.Custom);
        switch (type) {
            case RefreshToken: {
                this.tokenProvider = this.getConfRefreshTokenBasedTokenProvider(conf);
                break;
            }
            case ClientCredential: {
                this.tokenProvider = this.getConfCredentialBasedTokenProvider(conf);
                break;
            }
            default: {
                AzureADTokenProvider azureADTokenProvider = this.getCustomAccessTokenProvider(conf);
                this.tokenProvider = new SdkTokenProviderAdapter(azureADTokenProvider);
            }
        }
        return this.tokenProvider;
    }

    private AccessTokenProvider getConfCredentialBasedTokenProvider(Configuration conf) throws IOException {
        String clientId = AdlFileSystem.getPasswordString(conf, "dfs.adls.oauth2.client.id");
        String refreshUrl = AdlFileSystem.getPasswordString(conf, "dfs.adls.oauth2.refresh.url");
        String clientSecret = AdlFileSystem.getPasswordString(conf, "dfs.adls.oauth2.credential");
        return new ClientCredsTokenProvider(refreshUrl, clientId, clientSecret);
    }

    private AccessTokenProvider getConfRefreshTokenBasedTokenProvider(Configuration conf) throws IOException {
        String clientId = AdlFileSystem.getPasswordString(conf, "dfs.adls.oauth2.client.id");
        String refreshToken = AdlFileSystem.getPasswordString(conf, "dfs.adls.oauth2.refresh.token");
        return new RefreshTokenBasedTokenProvider(clientId, refreshToken);
    }

    @VisibleForTesting
    AccessTokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    @VisibleForTesting
    AzureADTokenProvider getAzureTokenProvider() {
        return this.azureTokenProvider;
    }

    public Path getHomeDirectory() {
        return this.makeQualified(new Path("/user/" + this.userName));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        IfExists overwriteRule = overwrite ? IfExists.OVERWRITE : IfExists.FAIL;
        return new FSDataOutputStream((OutputStream)new AdlFsOutputStream(this.adlClient.createFile(this.toRelativeFilePath(f), overwriteRule, Integer.toOctalString(this.applyUMask(permission).toShort()), true), this.getConf()), this.statistics);
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        IfExists overwriteRule = IfExists.FAIL;
        for (CreateFlag flag : flags) {
            if (flag != CreateFlag.OVERWRITE) continue;
            overwriteRule = IfExists.OVERWRITE;
            break;
        }
        return new FSDataOutputStream((OutputStream)new AdlFsOutputStream(this.adlClient.createFile(this.toRelativeFilePath(f), overwriteRule, Integer.toOctalString(this.applyUMask(permission).toShort()), false), this.getConf()), this.statistics);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        return new FSDataOutputStream((OutputStream)new AdlFsOutputStream(this.adlClient.getAppendStream(this.toRelativeFilePath(f)), this.getConf()), this.statistics);
    }

    public boolean setReplication(Path p, short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        return true;
    }

    public FSDataInputStream open(Path f, int buffersize) throws IOException {
        this.statistics.incrementReadOps(1);
        return new FSDataInputStream((InputStream)((Object)new AdlFsInputStream(this.adlClient.getReadStream(this.toRelativeFilePath(f)), this.statistics, this.getConf())));
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        DirectoryEntry entry = this.adlClient.getDirectoryEntry(this.toRelativeFilePath(f), this.oidOrUpn);
        return this.toFileStatus(entry, f);
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        List entries = this.adlClient.enumerateDirectory(this.toRelativeFilePath(f), this.oidOrUpn);
        return this.toFileStatuses(entries, f);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        if (this.toRelativeFilePath(src).equals("/")) {
            return false;
        }
        return this.adlClient.rename(this.toRelativeFilePath(src), this.toRelativeFilePath(dst));
    }

    @Deprecated
    public void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        this.statistics.incrementWriteOps(1);
        boolean overwrite = false;
        for (Options.Rename renameOption : options) {
            if (renameOption != Options.Rename.OVERWRITE) continue;
            overwrite = true;
            break;
        }
        this.adlClient.rename(this.toRelativeFilePath(src), this.toRelativeFilePath(dst), overwrite);
    }

    public void concat(Path trg, Path[] srcs) throws IOException {
        this.statistics.incrementWriteOps(1);
        ArrayList<String> sourcesList = new ArrayList<String>();
        for (Path entry : srcs) {
            sourcesList.add(this.toRelativeFilePath(entry));
        }
        this.adlClient.concatenateFiles(this.toRelativeFilePath(trg), sourcesList);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        this.statistics.incrementWriteOps(1);
        String relativePath = this.toRelativeFilePath(path);
        if (relativePath.equals("/")) {
            if (!recursive && this.adlClient.enumerateDirectory(this.toRelativeFilePath(path), 1).size() > 0) {
                throw new IOException("Delete on root is not supported.");
            }
            return false;
        }
        return recursive ? this.adlClient.deleteRecursive(relativePath) : this.adlClient.delete(relativePath);
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.adlClient.createDirectory(this.toRelativeFilePath(path), Integer.toOctalString(this.applyUMask(permission).toShort()));
    }

    private FileStatus[] toFileStatuses(List<DirectoryEntry> entries, Path parent) {
        FileStatus[] fileStatuses = new FileStatus[entries.size()];
        int index = 0;
        for (DirectoryEntry entry : entries) {
            FileStatus status = this.toFileStatus(entry, parent);
            if (entry.name != null && entry.name != "") {
                status.setPath(new Path(parent.makeQualified(this.uri, this.workingDirectory), entry.name));
            }
            fileStatuses[index++] = status;
        }
        return fileStatuses;
    }

    private FsPermission applyUMask(FsPermission permission) {
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        return permission.applyUMask(FsPermission.getUMask((Configuration)this.getConf()));
    }

    private FileStatus toFileStatus(DirectoryEntry entry, Path f) {
        boolean isDirectory = entry.type == DirectoryEntryType.DIRECTORY;
        long lastModificationData = entry.lastModifiedTime.getTime();
        long lastAccessTime = entry.lastAccessTime.getTime();
        boolean aclBit = this.aclBitStatus ? entry.aclBit : false;
        AdlPermission permission = new AdlPermission(aclBit, Short.valueOf(entry.permission, 8));
        String user = entry.user;
        String group = entry.group;
        FileStatus status = this.overrideOwner ? new FileStatus(entry.length, isDirectory, 1, 0x10000000L, lastModificationData, lastAccessTime, (FsPermission)permission, this.userName, "hdfs", this.makeQualified(f)) : new FileStatus(entry.length, isDirectory, 1, 0x10000000L, lastModificationData, lastAccessTime, (FsPermission)permission, user, group, this.makeQualified(f));
        return status;
    }

    public void setOwner(Path path, String owner, String group) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.adlClient.setOwner(this.toRelativeFilePath(path), owner, group);
    }

    public void setPermission(Path path, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.adlClient.setPermission(this.toRelativeFilePath(path), Integer.toOctalString(permission.toShort()));
    }

    public void modifyAclEntries(Path path, List<org.apache.hadoop.fs.permission.AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        ArrayList<AclEntry> msAclEntries = new ArrayList<AclEntry>();
        for (org.apache.hadoop.fs.permission.AclEntry aclEntry : aclSpec) {
            msAclEntries.add(AclEntry.parseAclEntry((String)aclEntry.toString()));
        }
        this.adlClient.modifyAclEntries(this.toRelativeFilePath(path), msAclEntries);
    }

    public void removeAclEntries(Path path, List<org.apache.hadoop.fs.permission.AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        ArrayList<AclEntry> msAclEntries = new ArrayList<AclEntry>();
        for (org.apache.hadoop.fs.permission.AclEntry aclEntry : aclSpec) {
            msAclEntries.add(AclEntry.parseAclEntry((String)aclEntry.toString(), (boolean)true));
        }
        this.adlClient.removeAclEntries(this.toRelativeFilePath(path), msAclEntries);
    }

    public void removeDefaultAcl(Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.adlClient.removeDefaultAcls(this.toRelativeFilePath(path));
    }

    public void removeAcl(Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.adlClient.removeAllAcls(this.toRelativeFilePath(path));
    }

    public void setAcl(Path path, List<org.apache.hadoop.fs.permission.AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        ArrayList<AclEntry> msAclEntries = new ArrayList<AclEntry>();
        for (org.apache.hadoop.fs.permission.AclEntry aclEntry : aclSpec) {
            msAclEntries.add(AclEntry.parseAclEntry((String)aclEntry.toString()));
        }
        this.adlClient.setAcl(this.toRelativeFilePath(path), msAclEntries);
    }

    public org.apache.hadoop.fs.permission.AclStatus getAclStatus(Path path) throws IOException {
        this.statistics.incrementReadOps(1);
        AclStatus adlStatus = this.adlClient.getAclStatus(this.toRelativeFilePath(path), this.oidOrUpn);
        AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
        aclStatusBuilder.owner(adlStatus.owner);
        aclStatusBuilder.group(adlStatus.group);
        aclStatusBuilder.setPermission(new FsPermission(Short.valueOf(adlStatus.octalPermissions, 8).shortValue()));
        aclStatusBuilder.stickyBit(adlStatus.stickyBit);
        String aclListString = AclEntry.aclListToString((List)adlStatus.aclSpec);
        List aclEntries = org.apache.hadoop.fs.permission.AclEntry.parseAclSpec((String)aclListString, (boolean)true);
        aclStatusBuilder.addEntries((Iterable)aclEntries);
        return aclStatusBuilder.build();
    }

    public void access(Path path, FsAction mode) throws IOException {
        this.statistics.incrementReadOps(1);
        if (!this.adlClient.checkAccess(this.toRelativeFilePath(path), mode.SYMBOL)) {
            throw new AccessControlException("Access Denied : " + path.toString());
        }
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        com.microsoft.azure.datalake.store.ContentSummary msSummary = this.adlClient.getContentSummary(this.toRelativeFilePath(f));
        return new ContentSummary.Builder().length(msSummary.length).directoryCount(msSummary.directoryCount).fileCount(msSummary.fileCount).spaceConsumed(msSummary.spaceConsumed).build();
    }

    @VisibleForTesting
    protected String getTransportScheme() {
        return "https";
    }

    @VisibleForTesting
    String toRelativeFilePath(Path path) {
        return path.makeQualified(this.uri, this.workingDirectory).toUri().getPath();
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(Path dir) {
        if (dir == null) {
            throw new InvalidPathException("Working directory cannot be set to NULL");
        }
        this.workingDirectory = this.makeAbsolute(dir);
    }

    @Deprecated
    public long getDefaultBlockSize() {
        return 0x10000000L;
    }

    public long getDefaultBlockSize(Path f) {
        return this.getDefaultBlockSize();
    }

    @Deprecated
    public long getBlockSize(Path f) throws IOException {
        return 0x10000000L;
    }

    public BlockLocation[] getFileBlockLocations(FileStatus status, long offset, long length) throws IOException {
        if (status == null) {
            return null;
        }
        if (offset < 0L || length < 0L) {
            throw new IllegalArgumentException("Invalid start or len parameter");
        }
        if (status.getLen() < offset) {
            return new BlockLocation[0];
        }
        String[] name = new String[]{"localhost"};
        String[] host = new String[]{"localhost"};
        long blockSize = 0x10000000L;
        int numberOfLocations = (int)(length / blockSize) + (length % blockSize == 0L ? 0 : 1);
        BlockLocation[] locations = new BlockLocation[numberOfLocations];
        for (int i = 0; i < locations.length; ++i) {
            long currentOffset = offset + (long)i * blockSize;
            long currentLength = Math.min(blockSize, offset + length - currentOffset);
            locations[i] = new BlockLocation(name, host, currentOffset, currentLength);
        }
        return locations;
    }

    public BlockLocation[] getFileBlockLocations(Path p, long offset, long length) throws IOException {
        FileStatus fileStatus = this.getFileStatus(p);
        return this.getFileBlockLocations(fileStatus, offset, length);
    }

    @Deprecated
    public short getReplication(Path src) {
        return 1;
    }

    private Path makeAbsolute(Path path) {
        return path.isAbsolute() ? path : new Path(this.workingDirectory, path);
    }

    private static String getNonEmptyVal(Configuration conf, String key) {
        String value = conf.get(key);
        if (StringUtils.isEmpty((String)value)) {
            throw new IllegalArgumentException("No value for " + key + " found in conf file.");
        }
        return value;
    }

    private static String getPasswordString(Configuration conf, String key) throws IOException {
        char[] passchars = conf.getPassword(key);
        if (passchars == null) {
            throw new IOException("Password " + key + " not found");
        }
        return new String(passchars);
    }

    @VisibleForTesting
    public void setUserGroupRepresentationAsUPN(boolean enableUPN) {
        this.oidOrUpn = enableUPN ? UserGroupRepresentation.UPN : UserGroupRepresentation.OID;
    }
}

