/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestResult;
import com.microsoft.azure.storage.RetryExponentialRetry;
import com.microsoft.azure.storage.RetryNoRetry;
import com.microsoft.azure.storage.RetryPolicyFactory;
import com.microsoft.azure.storage.SendingRequestEvent;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.StorageEvent;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobListingDetails;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.BlobType;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CopyStatus;
import com.microsoft.azure.storage.blob.DeleteSnapshotsOption;
import com.microsoft.azure.storage.blob.ListBlobItem;
import com.microsoft.azure.storage.core.BaseRequest;
import com.microsoft.azure.storage.core.Utility;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.AzureLinkedStack;
import org.apache.hadoop.fs.azure.BlobMaterialization;
import org.apache.hadoop.fs.azure.BlockBlobAppendStream;
import org.apache.hadoop.fs.azure.BlockBlobInputStream;
import org.apache.hadoop.fs.azure.ClientThrottlingIntercept;
import org.apache.hadoop.fs.azure.FileMetadata;
import org.apache.hadoop.fs.azure.KeyProvider;
import org.apache.hadoop.fs.azure.KeyProviderException;
import org.apache.hadoop.fs.azure.NativeAzureFileSystemHelper;
import org.apache.hadoop.fs.azure.NativeFileSystemStore;
import org.apache.hadoop.fs.azure.PageBlobInputStream;
import org.apache.hadoop.fs.azure.PageBlobOutputStream;
import org.apache.hadoop.fs.azure.SecureStorageInterfaceImpl;
import org.apache.hadoop.fs.azure.SelfRenewingLease;
import org.apache.hadoop.fs.azure.SelfThrottlingIntercept;
import org.apache.hadoop.fs.azure.SendRequestIntercept;
import org.apache.hadoop.fs.azure.SimpleKeyProvider;
import org.apache.hadoop.fs.azure.StorageInterface;
import org.apache.hadoop.fs.azure.StorageInterfaceImpl;
import org.apache.hadoop.fs.azure.SyncableDataOutputStream;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemInstrumentation;
import org.apache.hadoop.fs.azure.metrics.BandwidthGaugeUpdater;
import org.apache.hadoop.fs.azure.metrics.ErrorMetricUpdater;
import org.apache.hadoop.fs.azure.metrics.ResponseReceivedMetricUpdater;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.VersionInfo;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@VisibleForTesting
public class AzureNativeFileSystemStore
implements NativeFileSystemStore {
    static final String KEY_CHECK_BLOCK_MD5 = "fs.azure.check.block.md5";
    static final String KEY_STORE_BLOB_MD5 = "fs.azure.store.blob.md5";
    static final String DEFAULT_STORAGE_EMULATOR_ACCOUNT_NAME = "storageemulator";
    static final String STORAGE_EMULATOR_ACCOUNT_NAME_PROPERTY_NAME = "fs.azure.storage.emulator.account.name";
    static final String USER_AGENT_ID_KEY = "fs.azure.user.agent.prefix";
    static final String USER_AGENT_ID_DEFAULT = "unknown";
    public static final Logger LOG = LoggerFactory.getLogger(AzureNativeFileSystemStore.class);
    private StorageInterface storageInteractionLayer;
    private StorageInterface.CloudBlobDirectoryWrapper rootDirectory;
    private StorageInterface.CloudBlobContainerWrapper container;
    private static final String KEY_ACCOUNT_KEYPROVIDER_PREFIX = "fs.azure.account.keyprovider.";
    private static final String KEY_ACCOUNT_SAS_PREFIX = "fs.azure.sas.";
    private static final String KEY_CONCURRENT_CONNECTION_VALUE_OUT = "fs.azure.concurrentRequestCount.out";
    private static final String HADOOP_BLOCK_SIZE_PROPERTY_NAME = "fs.azure.block.size";
    private static final String KEY_STREAM_MIN_READ_SIZE = "fs.azure.read.request.size";
    private static final String KEY_STORAGE_CONNECTION_TIMEOUT = "fs.azure.storage.timeout";
    private static final String KEY_WRITE_BLOCK_SIZE = "fs.azure.write.request.size";
    @VisibleForTesting
    static final String KEY_INPUT_STREAM_VERSION = "fs.azure.input.stream.version.for.internal.use.only";
    private static final String KEY_READ_TOLERATE_CONCURRENT_APPEND = "fs.azure.io.read.tolerate.concurrent.append";
    private static final String KEY_MIN_BACKOFF_INTERVAL = "fs.azure.io.retry.min.backoff.interval";
    private static final String KEY_MAX_BACKOFF_INTERVAL = "fs.azure.io.retry.max.backoff.interval";
    private static final String KEY_BACKOFF_INTERVAL = "fs.azure.io.retry.backoff.interval";
    private static final String KEY_MAX_IO_RETRIES = "fs.azure.io.retry.max.retries";
    private static final String KEY_COPYBLOB_MIN_BACKOFF_INTERVAL = "fs.azure.io.copyblob.retry.min.backoff.interval";
    private static final String KEY_COPYBLOB_MAX_BACKOFF_INTERVAL = "fs.azure.io.copyblob.retry.max.backoff.interval";
    private static final String KEY_COPYBLOB_BACKOFF_INTERVAL = "fs.azure.io.copyblob.retry.backoff.interval";
    private static final String KEY_COPYBLOB_MAX_IO_RETRIES = "fs.azure.io.copyblob.retry.max.retries";
    private static final String KEY_SELF_THROTTLE_ENABLE = "fs.azure.selfthrottling.enable";
    private static final String KEY_SELF_THROTTLE_READ_FACTOR = "fs.azure.selfthrottling.read.factor";
    private static final String KEY_SELF_THROTTLE_WRITE_FACTOR = "fs.azure.selfthrottling.write.factor";
    private static final String KEY_AUTO_THROTTLE_ENABLE = "fs.azure.autothrottling.enable";
    private static final String KEY_ENABLE_STORAGE_CLIENT_LOGGING = "fs.azure.storage.client.logging";
    @VisibleForTesting
    public static final String KEY_USE_SECURE_MODE = "fs.azure.secure.mode";
    public static final String KEY_USE_LOCAL_SAS_KEY_MODE = "fs.azure.local.sas.key.mode";
    private static final String PERMISSION_METADATA_KEY = "hdi_permission";
    private static final String OLD_PERMISSION_METADATA_KEY = "asv_permission";
    private static final String IS_FOLDER_METADATA_KEY = "hdi_isfolder";
    private static final String OLD_IS_FOLDER_METADATA_KEY = "asv_isfolder";
    static final String VERSION_METADATA_KEY = "hdi_version";
    static final String OLD_VERSION_METADATA_KEY = "asv_version";
    static final String FIRST_WASB_VERSION = "2013-01-01";
    static final String CURRENT_WASB_VERSION = "2013-09-01";
    static final String LINK_BACK_TO_UPLOAD_IN_PROGRESS_METADATA_KEY = "hdi_tmpupload";
    static final String OLD_LINK_BACK_TO_UPLOAD_IN_PROGRESS_METADATA_KEY = "asv_tmpupload";
    public static final String KEY_PAGE_BLOB_DIRECTORIES = "fs.azure.page.blob.dir";
    private Set<String> pageBlobDirs;
    public static final String KEY_BLOCK_BLOB_WITH_COMPACTION_DIRECTORIES = "fs.azure.block.blob.with.compaction.dir";
    private Set<String> blockBlobWithCompationDirs;
    public static final String KEY_ATOMIC_RENAME_DIRECTORIES = "fs.azure.atomic.rename.dir";
    public static final String KEY_ENABLE_FLAT_LISTING = "fs.azure.flatlist.enable";
    private Set<String> atomicRenameDirs;
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final String WASB_AUTHORITY_DELIMITER = "@";
    private static final char ASTERISK_SYMBOL = '*';
    private static final String AZURE_ROOT_CONTAINER = "$root";
    private static final int DEFAULT_CONCURRENT_WRITES = 8;
    private static final boolean DEFAULT_READ_TOLERATE_CONCURRENT_APPEND = false;
    public static final int DEFAULT_DOWNLOAD_BLOCK_SIZE = 0x400000;
    public static final int DEFAULT_UPLOAD_BLOCK_SIZE = 0x400000;
    public static final long DEFAULT_HADOOP_BLOCK_SIZE = 0x20000000L;
    private static final int DEFAULT_INPUT_STREAM_VERSION = 2;
    private static final int DEFAULT_MIN_BACKOFF_INTERVAL = 3000;
    private static final int DEFAULT_MAX_BACKOFF_INTERVAL = 30000;
    private static final int DEFAULT_BACKOFF_INTERVAL = 3000;
    private static final int DEFAULT_MAX_RETRY_ATTEMPTS = 30;
    private static final int DEFAULT_COPYBLOB_MIN_BACKOFF_INTERVAL = 3000;
    private static final int DEFAULT_COPYBLOB_MAX_BACKOFF_INTERVAL = 90000;
    private static final int DEFAULT_COPYBLOB_BACKOFF_INTERVAL = 30000;
    private static final int DEFAULT_COPYBLOB_MAX_RETRY_ATTEMPTS = 15;
    private static final boolean DEFAULT_SELF_THROTTLE_ENABLE = true;
    private static final float DEFAULT_SELF_THROTTLE_READ_FACTOR = 1.0f;
    private static final float DEFAULT_SELF_THROTTLE_WRITE_FACTOR = 1.0f;
    private static final boolean DEFAULT_AUTO_THROTTLE_ENABLE = false;
    private static final int STORAGE_CONNECTION_TIMEOUT_DEFAULT = 90;
    public static final boolean DEFAULT_USE_SECURE_MODE = false;
    private static final boolean DEFAULT_USE_LOCAL_SAS_KEY_MODE = false;
    public static final boolean DEFAULT_ENABLE_FLAT_LISTING = false;
    private URI sessionUri;
    private Configuration sessionConfiguration;
    private int concurrentWrites = 8;
    private boolean isAnonymousCredentials = false;
    private boolean connectingUsingSAS = false;
    private AzureFileSystemInstrumentation instrumentation;
    private BandwidthGaugeUpdater bandwidthGaugeUpdater;
    private static final JSON PERMISSION_JSON_SERIALIZER = AzureNativeFileSystemStore.createPermissionJsonSerializer();
    private boolean suppressRetryPolicy = false;
    private boolean canCreateOrModifyContainer = false;
    private ContainerState currentKnownContainerState = ContainerState.Unknown;
    private final Object containerStateLock = new Object();
    private boolean tolerateOobAppends = false;
    private long hadoopBlockSize = 0x20000000L;
    private int downloadBlockSizeBytes = 0x400000;
    private int uploadBlockSizeBytes = 0x400000;
    private int inputStreamVersion = 2;
    private int minBackoff;
    private int maxBackoff;
    private int deltaBackoff;
    private int maxRetries;
    private boolean selfThrottlingEnabled;
    private float selfThrottlingReadFactor;
    private float selfThrottlingWriteFactor;
    private boolean autoThrottlingEnabled;
    private TestHookOperationContext testHookOperationContext = null;
    private boolean isStorageEmulator = false;
    private boolean useSecureMode = false;
    private boolean useLocalSasKeyMode = false;
    private String userAgentId;
    private String delegationToken;
    public static final String NO_ACCESS_TO_CONTAINER_MSG = "No credentials found for account %s in the configuration, and its container %s is not accessible using anonymous credentials. Please check if the container exists first. If it is not publicly available, you have to provide account credentials.";

    @VisibleForTesting
    void suppressRetryPolicy() {
        this.suppressRetryPolicy = true;
    }

    @VisibleForTesting
    void addTestHookToOperationContext(TestHookOperationContext testHook) {
        this.testHookOperationContext = testHook;
    }

    private void suppressRetryPolicyInClientIfNeeded() {
        if (this.suppressRetryPolicy) {
            this.storageInteractionLayer.setRetryPolicyFactory((RetryPolicyFactory)new RetryNoRetry());
        }
    }

    private static JSON createPermissionJsonSerializer() {
        Log.getProperties().setProperty("org.eclipse.jetty.util.log.announce", "false");
        JSON serializer = new JSON();
        serializer.addConvertor(PermissionStatus.class, (JSON.Convertor)new PermissionStatusJsonSerializer());
        return serializer;
    }

    @VisibleForTesting
    void setAzureStorageInteractionLayer(StorageInterface storageInteractionLayer) {
        this.storageInteractionLayer = storageInteractionLayer;
    }

    @VisibleForTesting
    public BandwidthGaugeUpdater getBandwidthGaugeUpdater() {
        return this.bandwidthGaugeUpdater;
    }

    private boolean isConcurrentOOBAppendAllowed() {
        return this.tolerateOobAppends;
    }

    @Override
    public void initialize(URI uri, Configuration conf, AzureFileSystemInstrumentation instrumentation) throws IllegalArgumentException, AzureException, IOException {
        if (null == instrumentation) {
            throw new IllegalArgumentException("Null instrumentation");
        }
        this.instrumentation = instrumentation;
        if (null == uri) {
            throw new IllegalArgumentException("Cannot initialize WASB file system, URI is null");
        }
        if (null == conf) {
            throw new IllegalArgumentException("Cannot initialize WASB file system, conf is null");
        }
        if (!conf.getBoolean("fs.azure.skip.metrics", false)) {
            this.bandwidthGaugeUpdater = new BandwidthGaugeUpdater(instrumentation);
        }
        this.sessionUri = uri;
        this.sessionConfiguration = conf;
        this.useSecureMode = conf.getBoolean(KEY_USE_SECURE_MODE, false);
        this.useLocalSasKeyMode = conf.getBoolean(KEY_USE_LOCAL_SAS_KEY_MODE, false);
        if (null == this.storageInteractionLayer) {
            this.storageInteractionLayer = !this.useSecureMode ? new StorageInterfaceImpl() : new SecureStorageInterfaceImpl(this.useLocalSasKeyMode, conf);
        }
        this.configureAzureStorageSession();
        this.createAzureStorageSession();
        this.pageBlobDirs = this.getDirectorySet(KEY_PAGE_BLOB_DIRECTORIES);
        LOG.debug("Page blob directories:  {}", (Object)this.setToString(this.pageBlobDirs));
        this.userAgentId = conf.get(USER_AGENT_ID_KEY, USER_AGENT_ID_DEFAULT);
        this.blockBlobWithCompationDirs = this.getDirectorySet(KEY_BLOCK_BLOB_WITH_COMPACTION_DIRECTORIES);
        LOG.debug("Block blobs with compaction directories:  {}", (Object)this.setToString(this.blockBlobWithCompationDirs));
        this.atomicRenameDirs = this.getDirectorySet(KEY_ATOMIC_RENAME_DIRECTORIES);
        try {
            String hbaseRoot = this.verifyAndConvertToStandardFormat(this.sessionConfiguration.get("hbase.rootdir", "hbase"));
            if (hbaseRoot != null) {
                this.atomicRenameDirs.add(hbaseRoot);
            }
        }
        catch (URISyntaxException e) {
            LOG.warn("Unable to initialize HBase root as an atomic rename directory.");
        }
        LOG.debug("Atomic rename directories: {} ", (Object)this.setToString(this.atomicRenameDirs));
    }

    private String setToString(Set<String> set) {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        for (String s : set) {
            sb.append("/" + s);
            if (i != set.size()) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    private String getAccountFromAuthority(URI uri) throws URISyntaxException {
        String authority = uri.getRawAuthority();
        if (null == authority) {
            throw new URISyntaxException(uri.toString(), "Expected URI with a valid authority");
        }
        if (!authority.contains(WASB_AUTHORITY_DELIMITER)) {
            return authority;
        }
        String[] authorityParts = authority.split(WASB_AUTHORITY_DELIMITER, 2);
        if (authorityParts.length < 2 || "".equals(authorityParts[0])) {
            String errMsg = String.format("URI '%s' has a malformed WASB authority, expected container name. Authority takes the form wasb://[<container name>@]<account name>", uri.toString());
            throw new IllegalArgumentException(errMsg);
        }
        return authorityParts[1];
    }

    private String getContainerFromAuthority(URI uri) throws URISyntaxException {
        String authority = uri.getRawAuthority();
        if (null == authority) {
            throw new URISyntaxException(uri.toString(), "Expected URI with a valid authority");
        }
        if (!authority.contains(WASB_AUTHORITY_DELIMITER)) {
            return AZURE_ROOT_CONTAINER;
        }
        String[] authorityParts = authority.split(WASB_AUTHORITY_DELIMITER, 2);
        if (authorityParts.length < 2 || "".equals(authorityParts[0])) {
            String errMsg = String.format("URI '%s' has a malformed WASB authority, expected container name.Authority takes the form wasb://[<container name>@]<account name>", uri.toString());
            throw new IllegalArgumentException(errMsg);
        }
        return authorityParts[0];
    }

    private String getHTTPScheme() {
        String sessionScheme = this.sessionUri.getScheme();
        if (sessionScheme != null && (sessionScheme.equalsIgnoreCase("asvs") || sessionScheme.equalsIgnoreCase("wasbs"))) {
            return HTTPS_SCHEME;
        }
        return HTTP_SCHEME;
    }

    private void configureAzureStorageSession() throws AzureException {
        if (this.sessionUri == null) {
            throw new AssertionError((Object)"Expected a non-null session URI when configuring storage session");
        }
        if (this.storageInteractionLayer == null) {
            throw new AssertionError((Object)String.format("Cannot configure storage session for URI '%s' if storage session has not been established.", this.sessionUri.toString()));
        }
        this.tolerateOobAppends = this.sessionConfiguration.getBoolean(KEY_READ_TOLERATE_CONCURRENT_APPEND, false);
        this.downloadBlockSizeBytes = this.sessionConfiguration.getInt(KEY_STREAM_MIN_READ_SIZE, 0x400000);
        this.uploadBlockSizeBytes = this.sessionConfiguration.getInt(KEY_WRITE_BLOCK_SIZE, 0x400000);
        this.hadoopBlockSize = this.sessionConfiguration.getLong(HADOOP_BLOCK_SIZE_PROPERTY_NAME, 0x20000000L);
        this.inputStreamVersion = this.sessionConfiguration.getInt(KEY_INPUT_STREAM_VERSION, 2);
        int storageConnectionTimeout = this.sessionConfiguration.getInt(KEY_STORAGE_CONNECTION_TIMEOUT, 0);
        if (0 < storageConnectionTimeout) {
            this.storageInteractionLayer.setTimeoutInMs(storageConnectionTimeout * 1000);
        }
        int cpuCores = 2 * Runtime.getRuntime().availableProcessors();
        this.concurrentWrites = this.sessionConfiguration.getInt(KEY_CONCURRENT_CONNECTION_VALUE_OUT, Math.min(cpuCores, 8));
        this.minBackoff = this.sessionConfiguration.getInt(KEY_MIN_BACKOFF_INTERVAL, 3000);
        this.maxBackoff = this.sessionConfiguration.getInt(KEY_MAX_BACKOFF_INTERVAL, 30000);
        this.deltaBackoff = this.sessionConfiguration.getInt(KEY_BACKOFF_INTERVAL, 3000);
        this.maxRetries = this.sessionConfiguration.getInt(KEY_MAX_IO_RETRIES, 30);
        this.storageInteractionLayer.setRetryPolicyFactory((RetryPolicyFactory)new RetryExponentialRetry(this.minBackoff, this.deltaBackoff, this.maxBackoff, this.maxRetries));
        this.selfThrottlingEnabled = this.sessionConfiguration.getBoolean(KEY_SELF_THROTTLE_ENABLE, true);
        this.selfThrottlingReadFactor = this.sessionConfiguration.getFloat(KEY_SELF_THROTTLE_READ_FACTOR, 1.0f);
        this.selfThrottlingWriteFactor = this.sessionConfiguration.getFloat(KEY_SELF_THROTTLE_WRITE_FACTOR, 1.0f);
        if (!this.selfThrottlingEnabled) {
            this.autoThrottlingEnabled = this.sessionConfiguration.getBoolean(KEY_AUTO_THROTTLE_ENABLE, false);
            if (this.autoThrottlingEnabled) {
                ClientThrottlingIntercept.initializeSingleton();
            }
        } else {
            this.autoThrottlingEnabled = false;
        }
        OperationContext.setLoggingEnabledByDefault((boolean)this.sessionConfiguration.getBoolean(KEY_ENABLE_STORAGE_CLIENT_LOGGING, false));
        LOG.debug("AzureNativeFileSystemStore init. Settings={},{},{},{{},{},{},{}},{{},{},{}}", new Object[]{this.concurrentWrites, this.tolerateOobAppends, storageConnectionTimeout > 0 ? storageConnectionTimeout : 90, this.minBackoff, this.deltaBackoff, this.maxBackoff, this.maxRetries, this.selfThrottlingEnabled, Float.valueOf(this.selfThrottlingReadFactor), Float.valueOf(this.selfThrottlingWriteFactor)});
    }

    private void connectUsingAnonymousCredentials(URI uri) throws StorageException, IOException, URISyntaxException {
        boolean canAccess;
        String accountName = this.getAccountFromAuthority(uri);
        URI storageUri = new URI(this.getHTTPScheme() + ":" + "/" + "/" + accountName);
        String containerName = this.getContainerFromAuthority(uri);
        this.storageInteractionLayer.createBlobClient(storageUri);
        this.suppressRetryPolicyInClientIfNeeded();
        this.container = this.storageInteractionLayer.getContainerReference(containerName);
        this.rootDirectory = this.container.getDirectoryReference("");
        try {
            canAccess = this.container.exists(this.getInstrumentedContext());
        }
        catch (StorageException ex) {
            LOG.error("Service returned StorageException when checking existence of container {} in account {}", new Object[]{containerName, accountName, ex});
            canAccess = false;
        }
        if (!canAccess) {
            throw new AzureException(String.format(NO_ACCESS_TO_CONTAINER_MSG, accountName, containerName));
        }
        this.isAnonymousCredentials = true;
    }

    private void connectUsingCredentials(String accountName, StorageCredentials credentials, String containerName) throws URISyntaxException, StorageException, AzureException {
        if (this.isStorageEmulatorAccount(accountName)) {
            this.isStorageEmulator = true;
            CloudStorageAccount account = CloudStorageAccount.getDevelopmentStorageAccount();
            this.storageInteractionLayer.createBlobClient(account);
        } else {
            URI blobEndPoint = new URI(this.getHTTPScheme() + "://" + accountName);
            this.storageInteractionLayer.createBlobClient(blobEndPoint, credentials);
        }
        this.suppressRetryPolicyInClientIfNeeded();
        this.container = this.storageInteractionLayer.getContainerReference(containerName);
        this.rootDirectory = this.container.getDirectoryReference("");
        this.canCreateOrModifyContainer = credentials instanceof StorageCredentialsAccountAndKey;
    }

    private void connectToAzureStorageInSecureMode(String accountName, String containerName, URI sessionUri) throws AzureException, StorageException, URISyntaxException {
        LOG.debug("Connecting to Azure storage in Secure Mode");
        if (!(this.storageInteractionLayer instanceof SecureStorageInterfaceImpl)) {
            throw new AssertionError((Object)"connectToAzureStorageInSecureMode() should be called only for SecureStorageInterfaceImpl instances");
        }
        ((SecureStorageInterfaceImpl)this.storageInteractionLayer).setStorageAccountName(accountName);
        this.connectingUsingSAS = true;
        this.container = this.storageInteractionLayer.getContainerReference(containerName);
        this.rootDirectory = this.container.getDirectoryReference("");
        this.canCreateOrModifyContainer = true;
    }

    private void connectUsingConnectionStringCredentials(String accountName, String containerName, String accountKey) throws InvalidKeyException, StorageException, IOException, URISyntaxException {
        String rawAccountName = accountName.split("\\.")[0];
        StorageCredentialsAccountAndKey credentials = new StorageCredentialsAccountAndKey(rawAccountName, accountKey);
        this.connectUsingCredentials(accountName, (StorageCredentials)credentials, containerName);
    }

    private void connectUsingSASCredentials(String accountName, String containerName, String sas) throws InvalidKeyException, StorageException, IOException, URISyntaxException {
        StorageCredentialsSharedAccessSignature credentials = new StorageCredentialsSharedAccessSignature(sas);
        this.connectingUsingSAS = true;
        this.connectUsingCredentials(accountName, (StorageCredentials)credentials, containerName);
    }

    private boolean isStorageEmulatorAccount(String accountName) {
        return accountName.equalsIgnoreCase(this.sessionConfiguration.get(STORAGE_EMULATOR_ACCOUNT_NAME_PROPERTY_NAME, DEFAULT_STORAGE_EMULATOR_ACCOUNT_NAME));
    }

    @VisibleForTesting
    public static String getAccountKeyFromConfiguration(String accountName, Configuration conf) throws KeyProviderException {
        String key = null;
        String keyProviderClass = conf.get(KEY_ACCOUNT_KEYPROVIDER_PREFIX + accountName);
        KeyProvider keyProvider = null;
        if (keyProviderClass == null) {
            keyProvider = new SimpleKeyProvider();
        } else {
            Object keyProviderObject = null;
            try {
                Class clazz = conf.getClassByName(keyProviderClass);
                keyProviderObject = clazz.newInstance();
            }
            catch (Exception e) {
                throw new KeyProviderException("Unable to load key provider class.", e);
            }
            if (!(keyProviderObject instanceof KeyProvider)) {
                throw new KeyProviderException(keyProviderClass + " specified in config is not a valid KeyProvider class.");
            }
            keyProvider = keyProviderObject;
        }
        key = keyProvider.getStorageAccountKey(accountName, conf);
        return key;
    }

    private void createAzureStorageSession() throws AzureException, IOException {
        if (null == this.sessionUri || null == this.sessionConfiguration) {
            throw new AzureException("Filesystem object not initialized properly.Unable to start session with Azure Storage server.");
        }
        try {
            if (this.getContainerFromAuthority(this.sessionUri) == null) {
                throw new AssertionError((Object)String.format("Non-null container expected from session URI: %s.", this.sessionUri.toString()));
            }
            String accountName = this.getAccountFromAuthority(this.sessionUri);
            if (null == accountName) {
                String errMsg = String.format("Cannot load WASB file system account name not specified in URI: %s.", this.sessionUri.toString());
                throw new AzureException(errMsg);
            }
            this.instrumentation.setAccountName(accountName);
            String containerName = this.getContainerFromAuthority(this.sessionUri);
            this.instrumentation.setContainerName(containerName);
            if (this.isStorageEmulatorAccount(accountName)) {
                this.connectUsingCredentials(accountName, null, containerName);
                return;
            }
            if (this.useSecureMode) {
                this.connectToAzureStorageInSecureMode(accountName, containerName, this.sessionUri);
                return;
            }
            String propertyValue = this.sessionConfiguration.get(KEY_ACCOUNT_SAS_PREFIX + containerName + "." + accountName);
            if (propertyValue != null) {
                this.connectUsingSASCredentials(accountName, containerName, propertyValue);
                return;
            }
            propertyValue = AzureNativeFileSystemStore.getAccountKeyFromConfiguration(accountName, this.sessionConfiguration);
            if (StringUtils.isNotEmpty((CharSequence)propertyValue)) {
                this.connectUsingConnectionStringCredentials(this.getAccountFromAuthority(this.sessionUri), this.getContainerFromAuthority(this.sessionUri), propertyValue);
            } else {
                LOG.debug("The account access key is not configured for {}. Now try anonymous access.", (Object)this.sessionUri);
                this.connectUsingAnonymousCredentials(this.sessionUri);
            }
        }
        catch (Exception e) {
            throw new AzureException(e);
        }
    }

    private static String trim(String s, String toTrim) {
        return StringUtils.removeEnd((String)StringUtils.removeStart((String)s, (String)toTrim), (String)toTrim);
    }

    private String verifyAndConvertToStandardFormat(String rawDir) throws URISyntaxException {
        URI asUri = new URI(rawDir);
        if (asUri.getAuthority() == null || asUri.getAuthority().toLowerCase(Locale.ENGLISH).equalsIgnoreCase(this.sessionUri.getAuthority().toLowerCase(Locale.ENGLISH))) {
            return AzureNativeFileSystemStore.trim(asUri.getPath(), "/");
        }
        return null;
    }

    private Set<String> getDirectorySet(String configVar) throws AzureException {
        String[] rawDirs = this.sessionConfiguration.getStrings(configVar, new String[0]);
        HashSet<String> directorySet = new HashSet<String>();
        for (String currentDir : rawDirs) {
            String myDir;
            try {
                myDir = this.verifyAndConvertToStandardFormat(currentDir.trim());
            }
            catch (URISyntaxException ex) {
                throw new AzureException(String.format("The directory %s specified in the configuration entry %s is not a valid URI.", currentDir, configVar));
            }
            if (myDir == null) continue;
            directorySet.add(myDir);
        }
        return directorySet;
    }

    @Override
    public boolean isPageBlobKey(String key) {
        return this.isKeyForDirectorySet(key, this.pageBlobDirs);
    }

    public boolean isBlockBlobWithCompactionKey(String key) {
        return this.isKeyForDirectorySet(key, this.blockBlobWithCompationDirs);
    }

    @Override
    public boolean isAtomicRenameKey(String key) {
        return this.isKeyForDirectorySet(key, this.atomicRenameDirs);
    }

    public boolean isKeyForDirectorySet(String key, Set<String> dirSet) {
        String defaultFS = FileSystem.getDefaultUri((Configuration)this.sessionConfiguration).toString();
        for (String dir : dirSet) {
            if (dir.isEmpty()) {
                return true;
            }
            if (this.matchAsteriskPattern(key, dir)) {
                return true;
            }
            try {
                String dirWithPrefix;
                URI uriPageBlobDir = new URI(dir);
                if (null != uriPageBlobDir.getAuthority() || !this.matchAsteriskPattern(key, dirWithPrefix = AzureNativeFileSystemStore.trim(defaultFS, "/") + "/" + dir)) continue;
                return true;
            }
            catch (URISyntaxException e) {
                LOG.info("URI syntax error creating URI for {}", (Object)dir);
            }
        }
        return false;
    }

    private boolean matchAsteriskPattern(String pathName, String pattern) {
        if (pathName == null || pathName.length() == 0) {
            return false;
        }
        int pathIndex = 0;
        int patternIndex = 0;
        while (pathIndex < pathName.length() && patternIndex < pattern.length()) {
            char charToMatch = pattern.charAt(patternIndex);
            if (charToMatch != '*') {
                if (charToMatch != pathName.charAt(pathIndex)) {
                    return false;
                }
                ++pathIndex;
                ++patternIndex;
                continue;
            }
            if (patternIndex > 0 && pattern.charAt(patternIndex - 1) != '/' || patternIndex + 1 < pattern.length() && pattern.charAt(patternIndex + 1) != '/') {
                if ('*' != pathName.charAt(pathIndex)) {
                    return false;
                }
                ++pathIndex;
                ++patternIndex;
                continue;
            }
            ++patternIndex;
            while (pathIndex < pathName.length() && pathName.charAt(pathIndex) != '/') {
                ++pathIndex;
            }
        }
        return patternIndex == pattern.length() && (pathIndex == pathName.length() || pathName.charAt(pathIndex) == '/');
    }

    @Override
    public long getHadoopBlockSize() {
        return this.hadoopBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerState checkContainer(ContainerAccessType accessType) throws StorageException, AzureException {
        Object object = this.containerStateLock;
        synchronized (object) {
            if (this.isOkContainerState(accessType)) {
                return this.currentKnownContainerState;
            }
            if (this.currentKnownContainerState == ContainerState.ExistsAtWrongVersion) {
                String containerVersion = AzureNativeFileSystemStore.retrieveVersionAttribute(this.container);
                throw this.wrongVersionException(containerVersion);
            }
            if (this.currentKnownContainerState == ContainerState.ExistsAtRightVersion) {
                throw new AssertionError((Object)("Unexpected state: " + (Object)((Object)this.currentKnownContainerState)));
            }
            try {
                this.container.downloadAttributes(this.getInstrumentedContext());
                this.currentKnownContainerState = ContainerState.Unknown;
            }
            catch (StorageException ex) {
                if ("ContainerNotFound".toString().equals(ex.getErrorCode())) {
                    this.currentKnownContainerState = ContainerState.DoesntExist;
                }
                throw ex;
            }
            if (this.currentKnownContainerState == ContainerState.DoesntExist) {
                if (AzureNativeFileSystemStore.needToCreateContainer(accessType)) {
                    AzureNativeFileSystemStore.storeVersionAttribute(this.container);
                    this.container.create(this.getInstrumentedContext());
                    this.currentKnownContainerState = ContainerState.ExistsAtRightVersion;
                }
            } else {
                String containerVersion = AzureNativeFileSystemStore.retrieveVersionAttribute(this.container);
                if (containerVersion != null) {
                    if (containerVersion.equals(FIRST_WASB_VERSION)) {
                        if (this.needToStampVersion(accessType)) {
                            AzureNativeFileSystemStore.storeVersionAttribute(this.container);
                            this.container.uploadMetadata(this.getInstrumentedContext());
                        }
                    } else {
                        if (!containerVersion.equals(CURRENT_WASB_VERSION)) {
                            this.currentKnownContainerState = ContainerState.ExistsAtWrongVersion;
                            throw this.wrongVersionException(containerVersion);
                        }
                        this.currentKnownContainerState = ContainerState.ExistsAtRightVersion;
                    }
                } else {
                    this.currentKnownContainerState = ContainerState.ExistsNoVersion;
                    if (this.needToStampVersion(accessType)) {
                        AzureNativeFileSystemStore.storeVersionAttribute(this.container);
                        this.container.uploadMetadata(this.getInstrumentedContext());
                        this.currentKnownContainerState = ContainerState.ExistsAtRightVersion;
                    }
                }
            }
            return this.currentKnownContainerState;
        }
    }

    private AzureException wrongVersionException(String containerVersion) {
        return new AzureException("The container " + this.container.getName() + " is at an unsupported version: " + containerVersion + ". Current supported version: " + FIRST_WASB_VERSION);
    }

    private boolean needToStampVersion(ContainerAccessType accessType) {
        return accessType != ContainerAccessType.PureRead && this.canCreateOrModifyContainer;
    }

    private static boolean needToCreateContainer(ContainerAccessType accessType) {
        return accessType == ContainerAccessType.PureWrite;
    }

    private boolean isOkContainerState(ContainerAccessType accessType) {
        switch (this.currentKnownContainerState) {
            case Unknown: {
                return this.connectingUsingSAS;
            }
            case DoesntExist: {
                return false;
            }
            case ExistsAtRightVersion: {
                return true;
            }
            case ExistsAtWrongVersion: {
                return false;
            }
            case ExistsNoVersion: {
                return !this.needToStampVersion(accessType);
            }
        }
        throw new AssertionError((Object)("Unknown access type: " + (Object)((Object)accessType)));
    }

    private boolean getUseTransactionalContentMD5() {
        return this.sessionConfiguration.getBoolean(KEY_CHECK_BLOCK_MD5, true);
    }

    private BlobRequestOptions getUploadOptions() {
        BlobRequestOptions options = new BlobRequestOptions();
        options.setStoreBlobContentMD5(Boolean.valueOf(this.sessionConfiguration.getBoolean(KEY_STORE_BLOB_MD5, false)));
        options.setUseTransactionalContentMD5(Boolean.valueOf(this.getUseTransactionalContentMD5()));
        options.setConcurrentRequestCount(Integer.valueOf(this.concurrentWrites));
        options.setRetryPolicyFactory((RetryPolicyFactory)new RetryExponentialRetry(this.minBackoff, this.deltaBackoff, this.maxBackoff, this.maxRetries));
        return options;
    }

    private BlobRequestOptions getDownloadOptions() {
        BlobRequestOptions options = new BlobRequestOptions();
        options.setRetryPolicyFactory((RetryPolicyFactory)new RetryExponentialRetry(this.minBackoff, this.deltaBackoff, this.maxBackoff, this.maxRetries));
        options.setUseTransactionalContentMD5(Boolean.valueOf(this.getUseTransactionalContentMD5()));
        return options;
    }

    @Override
    public DataOutputStream storefile(String keyEncoded, PermissionStatus permissionStatus, String key) throws AzureException {
        try {
            OutputStream outputStream;
            if (null == this.storageInteractionLayer) {
                String errMsg = String.format("Storage session expected for URI '%s' but does not exist.", this.sessionUri);
                throw new AzureException(errMsg);
            }
            if (!this.isAuthenticatedAccess()) {
                throw new AzureException(new IOException("Uploads to public accounts using anonymous access is prohibited."));
            }
            this.checkContainer(ContainerAccessType.PureWrite);
            if (AZURE_ROOT_CONTAINER.equals(this.getContainerFromAuthority(this.sessionUri))) {
                String errMsg = String.format("Writes to '%s' container for URI '%s' are prohibited, only updates on non-root containers permitted.", AZURE_ROOT_CONTAINER, this.sessionUri.toString());
                throw new AzureException(errMsg);
            }
            StorageInterface.CloudBlobWrapper blob = this.getBlobReference(keyEncoded);
            AzureNativeFileSystemStore.storePermissionStatus(blob, permissionStatus);
            if (this.isBlockBlobWithCompactionKey(key)) {
                BlockBlobAppendStream blockBlobOutputStream = new BlockBlobAppendStream((StorageInterface.CloudBlockBlobWrapper)blob, keyEncoded, this.uploadBlockSizeBytes, true, this.getInstrumentedContext());
                outputStream = blockBlobOutputStream;
            } else {
                outputStream = this.openOutputStream(blob);
            }
            SyncableDataOutputStream dataOutStream = new SyncableDataOutputStream(outputStream);
            return dataOutStream;
        }
        catch (Exception e) {
            throw new AzureException(e);
        }
    }

    private OutputStream openOutputStream(StorageInterface.CloudBlobWrapper blob) throws StorageException {
        if (blob instanceof StorageInterface.CloudPageBlobWrapper) {
            return new PageBlobOutputStream((StorageInterface.CloudPageBlobWrapper)blob, this.getInstrumentedContext(), this.sessionConfiguration);
        }
        return ((StorageInterface.CloudBlockBlobWrapper)blob).openOutputStream(this.getUploadOptions(), this.getInstrumentedContext());
    }

    private InputStream openInputStream(StorageInterface.CloudBlobWrapper blob) throws StorageException, IOException {
        if (blob instanceof StorageInterface.CloudBlockBlobWrapper) {
            LOG.debug("Using stream seek algorithm {}", (Object)this.inputStreamVersion);
            switch (this.inputStreamVersion) {
                case 1: {
                    return blob.openInputStream(this.getDownloadOptions(), this.getInstrumentedContext(this.isConcurrentOOBAppendAllowed()));
                }
                case 2: {
                    return new BlockBlobInputStream((StorageInterface.CloudBlockBlobWrapper)blob, this.getDownloadOptions(), this.getInstrumentedContext(this.isConcurrentOOBAppendAllowed()));
                }
            }
            throw new IOException("Unknown seek algorithm: " + this.inputStreamVersion);
        }
        return new PageBlobInputStream((StorageInterface.CloudPageBlobWrapper)blob, this.getInstrumentedContext(this.isConcurrentOOBAppendAllowed()));
    }

    private static PermissionStatus defaultPermissionNoBlobMetadata() {
        return new PermissionStatus("", "", FsPermission.getDefault());
    }

    private static void storeMetadataAttribute(StorageInterface.CloudBlobWrapper blob, String key, String value) {
        HashMap<String, String> metadata = blob.getMetadata();
        if (null == metadata) {
            metadata = new HashMap();
        }
        metadata.put(key, value);
        blob.setMetadata(metadata);
    }

    private static String getMetadataAttribute(StorageInterface.CloudBlobWrapper blob, String ... keyAlternatives) {
        HashMap<String, String> metadata = blob.getMetadata();
        if (null == metadata) {
            return null;
        }
        for (String key : keyAlternatives) {
            if (!metadata.containsKey(key)) continue;
            return metadata.get(key);
        }
        return null;
    }

    private static void removeMetadataAttribute(StorageInterface.CloudBlobWrapper blob, String key) {
        HashMap<String, String> metadata = blob.getMetadata();
        if (metadata != null) {
            metadata.remove(key);
            blob.setMetadata(metadata);
        }
    }

    private static void storePermissionStatus(StorageInterface.CloudBlobWrapper blob, PermissionStatus permissionStatus) {
        AzureNativeFileSystemStore.storeMetadataAttribute(blob, PERMISSION_METADATA_KEY, PERMISSION_JSON_SERIALIZER.toJSON((Object)permissionStatus));
        AzureNativeFileSystemStore.removeMetadataAttribute(blob, OLD_PERMISSION_METADATA_KEY);
    }

    private PermissionStatus getPermissionStatus(StorageInterface.CloudBlobWrapper blob) {
        String permissionMetadataValue = AzureNativeFileSystemStore.getMetadataAttribute(blob, PERMISSION_METADATA_KEY, OLD_PERMISSION_METADATA_KEY);
        if (permissionMetadataValue != null) {
            return PermissionStatusJsonSerializer.fromJSONString(permissionMetadataValue);
        }
        return AzureNativeFileSystemStore.defaultPermissionNoBlobMetadata();
    }

    private static void storeFolderAttribute(StorageInterface.CloudBlobWrapper blob) {
        AzureNativeFileSystemStore.storeMetadataAttribute(blob, IS_FOLDER_METADATA_KEY, "true");
        AzureNativeFileSystemStore.removeMetadataAttribute(blob, OLD_IS_FOLDER_METADATA_KEY);
    }

    private static void storeLinkAttribute(StorageInterface.CloudBlobWrapper blob, String linkTarget) throws UnsupportedEncodingException {
        String encodedLinkTarget = null;
        if (linkTarget != null) {
            encodedLinkTarget = URLEncoder.encode(linkTarget, "UTF-8");
        }
        AzureNativeFileSystemStore.storeMetadataAttribute(blob, LINK_BACK_TO_UPLOAD_IN_PROGRESS_METADATA_KEY, encodedLinkTarget);
        AzureNativeFileSystemStore.removeMetadataAttribute(blob, OLD_LINK_BACK_TO_UPLOAD_IN_PROGRESS_METADATA_KEY);
    }

    private static String getLinkAttributeValue(StorageInterface.CloudBlobWrapper blob) throws UnsupportedEncodingException {
        String encodedLinkTarget = AzureNativeFileSystemStore.getMetadataAttribute(blob, LINK_BACK_TO_UPLOAD_IN_PROGRESS_METADATA_KEY, OLD_LINK_BACK_TO_UPLOAD_IN_PROGRESS_METADATA_KEY);
        String linkTarget = null;
        if (encodedLinkTarget != null) {
            linkTarget = URLDecoder.decode(encodedLinkTarget, "UTF-8");
        }
        return linkTarget;
    }

    private static boolean retrieveFolderAttribute(StorageInterface.CloudBlobWrapper blob) {
        HashMap<String, String> metadata = blob.getMetadata();
        return null != metadata && (metadata.containsKey(IS_FOLDER_METADATA_KEY) || metadata.containsKey(OLD_IS_FOLDER_METADATA_KEY));
    }

    private static void storeVersionAttribute(StorageInterface.CloudBlobContainerWrapper container) {
        HashMap<String, String> metadata = container.getMetadata();
        if (null == metadata) {
            metadata = new HashMap();
        }
        metadata.put(VERSION_METADATA_KEY, CURRENT_WASB_VERSION);
        if (metadata.containsKey(OLD_VERSION_METADATA_KEY)) {
            metadata.remove(OLD_VERSION_METADATA_KEY);
        }
        container.setMetadata(metadata);
    }

    private static String retrieveVersionAttribute(StorageInterface.CloudBlobContainerWrapper container) {
        HashMap<String, String> metadata = container.getMetadata();
        if (metadata == null) {
            return null;
        }
        if (metadata.containsKey(VERSION_METADATA_KEY)) {
            return metadata.get(VERSION_METADATA_KEY);
        }
        if (metadata.containsKey(OLD_VERSION_METADATA_KEY)) {
            return metadata.get(OLD_VERSION_METADATA_KEY);
        }
        return null;
    }

    @Override
    public void storeEmptyFolder(String key, PermissionStatus permissionStatus) throws AzureException {
        if (null == this.storageInteractionLayer) {
            String errMsg = String.format("Storage session expected for URI '%s' but does not exist.", this.sessionUri);
            throw new AssertionError((Object)errMsg);
        }
        if (!this.isAuthenticatedAccess()) {
            throw new AzureException("Uploads to to public accounts using anonymous access is prohibited.");
        }
        try {
            this.checkContainer(ContainerAccessType.PureWrite);
            StorageInterface.CloudBlobWrapper blob = this.getBlobReference(key);
            AzureNativeFileSystemStore.storePermissionStatus(blob, permissionStatus);
            AzureNativeFileSystemStore.storeFolderAttribute(blob);
            this.openOutputStream(blob).close();
        }
        catch (StorageException e) {
            throw new AzureException(e);
        }
        catch (URISyntaxException e) {
            throw new AzureException(e);
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            if (t instanceof StorageException) {
                StorageException se = (StorageException)t;
                if (!"LeaseIdMissing".equals(se.getErrorCode())) {
                    throw new AzureException(e);
                }
            }
            throw new AzureException(e);
        }
    }

    @Override
    public void storeEmptyLinkFile(String key, String tempBlobKey, PermissionStatus permissionStatus) throws AzureException {
        if (null == this.storageInteractionLayer) {
            String errMsg = String.format("Storage session expected for URI '%s' but does not exist.", this.sessionUri);
            throw new AssertionError((Object)errMsg);
        }
        if (!this.isAuthenticatedAccess()) {
            throw new AzureException("Uploads to to public accounts using anonymous access is prohibited.");
        }
        try {
            this.checkContainer(ContainerAccessType.PureWrite);
            StorageInterface.CloudBlobWrapper blob = this.getBlobReference(key);
            AzureNativeFileSystemStore.storePermissionStatus(blob, permissionStatus);
            AzureNativeFileSystemStore.storeLinkAttribute(blob, tempBlobKey);
            this.openOutputStream(blob).close();
        }
        catch (Exception e) {
            throw new AzureException(e);
        }
    }

    @Override
    public String getLinkInFileMetadata(String key) throws AzureException {
        if (null == this.storageInteractionLayer) {
            String errMsg = String.format("Storage session expected for URI '%s' but does not exist.", this.sessionUri);
            throw new AssertionError((Object)errMsg);
        }
        try {
            this.checkContainer(ContainerAccessType.PureRead);
            StorageInterface.CloudBlobWrapper blob = this.getBlobReference(key);
            blob.downloadAttributes(this.getInstrumentedContext());
            return AzureNativeFileSystemStore.getLinkAttributeValue(blob);
        }
        catch (Exception e) {
            throw new AzureException(e);
        }
    }

    private boolean isAuthenticatedAccess() throws AzureException {
        return !this.isAnonymousCredentials;
    }

    private Iterable<ListBlobItem> listRootBlobs(boolean includeMetadata, boolean useFlatBlobListing) throws StorageException, URISyntaxException {
        return this.rootDirectory.listBlobs(null, useFlatBlobListing, includeMetadata ? EnumSet.of(BlobListingDetails.METADATA) : EnumSet.noneOf(BlobListingDetails.class), null, this.getInstrumentedContext());
    }

    private Iterable<ListBlobItem> listRootBlobs(String aPrefix, boolean includeMetadata, boolean useFlatBlobListing) throws StorageException, URISyntaxException {
        Iterable<ListBlobItem> list = this.rootDirectory.listBlobs(aPrefix, useFlatBlobListing, includeMetadata ? EnumSet.of(BlobListingDetails.METADATA) : EnumSet.noneOf(BlobListingDetails.class), null, this.getInstrumentedContext());
        return list;
    }

    private Iterable<ListBlobItem> listRootBlobs(String aPrefix, boolean useFlatBlobListing, EnumSet<BlobListingDetails> listingDetails, BlobRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        StorageInterface.CloudBlobDirectoryWrapper directory = this.container.getDirectoryReference(aPrefix);
        return directory.listBlobs(null, useFlatBlobListing, listingDetails, options, opContext);
    }

    private StorageInterface.CloudBlobWrapper getBlobReference(String aKey) throws StorageException, URISyntaxException {
        StorageInterface.CloudBlobWrapper blob = null;
        if (this.isPageBlobKey(aKey)) {
            blob = this.container.getPageBlobReference(aKey);
        } else {
            blob = this.container.getBlockBlobReference(aKey);
            blob.setStreamMinimumReadSizeInBytes(this.downloadBlockSizeBytes);
            blob.setWriteBlockSizeInBytes(this.uploadBlockSizeBytes);
        }
        return blob;
    }

    private String normalizeKey(URI keyUri) {
        int parts = this.isStorageEmulator ? 4 : 3;
        String normKey = keyUri.getPath().split("/", parts)[parts - 1];
        return normKey;
    }

    private String normalizeKey(StorageInterface.CloudBlobWrapper blob) {
        return this.normalizeKey(blob.getUri());
    }

    private String normalizeKey(StorageInterface.CloudBlobDirectoryWrapper directory) {
        String dirKey = this.normalizeKey(directory.getUri());
        if (dirKey.endsWith("/")) {
            dirKey = dirKey.substring(0, dirKey.length() - 1);
        }
        return dirKey;
    }

    private OperationContext getInstrumentedContext() {
        return this.getInstrumentedContext(false);
    }

    private OperationContext getInstrumentedContext(boolean bindConcurrentOOBIo) {
        OperationContext operationContext = new OperationContext();
        operationContext.getSendingRequestEventHandler().addListener((StorageEvent)new StorageEvent<SendingRequestEvent>(){

            public void eventOccurred(SendingRequestEvent eventArg) {
                HttpURLConnection connection = (HttpURLConnection)eventArg.getConnectionObject();
                String userAgentInfo = String.format(Utility.LOCALE_US, "WASB/%s (%s) %s", VersionInfo.getVersion(), AzureNativeFileSystemStore.this.userAgentId, BaseRequest.getUserAgent());
                connection.setRequestProperty("User-Agent", userAgentInfo);
            }
        });
        if (this.selfThrottlingEnabled) {
            SelfThrottlingIntercept.hook(operationContext, this.selfThrottlingReadFactor, this.selfThrottlingWriteFactor);
        } else if (this.autoThrottlingEnabled) {
            ClientThrottlingIntercept.hook(operationContext);
        }
        if (this.bandwidthGaugeUpdater != null) {
            ResponseReceivedMetricUpdater.hook(operationContext, this.instrumentation, this.bandwidthGaugeUpdater);
        }
        if (bindConcurrentOOBIo) {
            SendRequestIntercept.bind(operationContext);
        }
        if (this.testHookOperationContext != null) {
            operationContext = this.testHookOperationContext.modifyOperationContext(operationContext);
        }
        ErrorMetricUpdater.hook(operationContext, this.instrumentation);
        return operationContext;
    }

    @Override
    public FileMetadata retrieveMetadata(String key) throws IOException {
        if (null == this.storageInteractionLayer) {
            String errMsg = String.format("Storage session expected for URI '%s' but does not exist.", this.sessionUri);
            throw new AssertionError((Object)errMsg);
        }
        LOG.debug("Retrieving metadata for {}", (Object)key);
        try {
            StorageInterface.CloudBlobWrapper blob;
            block10: {
                if (this.checkContainer(ContainerAccessType.PureRead) == ContainerState.DoesntExist) {
                    return null;
                }
                if (key.equals("/")) {
                    return new FileMetadata(key, 0L, AzureNativeFileSystemStore.defaultPermissionNoBlobMetadata(), BlobMaterialization.Implicit, this.hadoopBlockSize);
                }
                blob = this.getBlobReference(key);
                if (null != blob && blob.exists(this.getInstrumentedContext())) {
                    LOG.debug("Found {} as an explicit blob. Checking if it's a file or folder.", (Object)key);
                    try {
                        blob.downloadAttributes(this.getInstrumentedContext());
                        BlobProperties properties = blob.getProperties();
                        if (AzureNativeFileSystemStore.retrieveFolderAttribute(blob)) {
                            LOG.debug("{} is a folder blob.", (Object)key);
                            return new FileMetadata(key, properties.getLastModified().getTime(), this.getPermissionStatus(blob), BlobMaterialization.Explicit, this.hadoopBlockSize);
                        }
                        LOG.debug("{} is a normal blob.", (Object)key);
                        return new FileMetadata(key, this.getDataLength(blob, properties), properties.getLastModified().getTime(), this.getPermissionStatus(blob), this.hadoopBlockSize);
                    }
                    catch (StorageException e) {
                        if (NativeAzureFileSystemHelper.isFileNotFoundException(e)) break block10;
                        throw e;
                    }
                }
            }
            Iterable<ListBlobItem> objects = this.listRootBlobs(key, true, EnumSet.of(BlobListingDetails.METADATA), null, this.getInstrumentedContext());
            for (ListBlobItem blobItem : objects) {
                if (!(blobItem instanceof StorageInterface.CloudBlockBlobWrapper) && !(blobItem instanceof StorageInterface.CloudPageBlobWrapper)) continue;
                LOG.debug("Found blob as a directory-using this file under it to infer its properties {}", (Object)blobItem.getUri());
                blob = (StorageInterface.CloudBlobWrapper)blobItem;
                BlobProperties properties = blob.getProperties();
                return new FileMetadata(key, properties.getLastModified().getTime(), this.getPermissionStatus(blob), BlobMaterialization.Implicit, this.hadoopBlockSize);
            }
            return null;
        }
        catch (Exception e) {
            throw new AzureException(e);
        }
    }

    @Override
    public InputStream retrieve(String key) throws AzureException, IOException {
        return this.retrieve(key, 0L);
    }

    @Override
    public InputStream retrieve(String key, long startByteOffset) throws AzureException, IOException {
        try {
            if (null == this.storageInteractionLayer) {
                String errMsg = String.format("Storage session expected for URI '%s' but does not exist.", this.sessionUri);
                throw new AssertionError((Object)errMsg);
            }
            this.checkContainer(ContainerAccessType.PureRead);
            InputStream inputStream = this.openInputStream(this.getBlobReference(key));
            if (startByteOffset > 0L) {
                inputStream.skip(startByteOffset);
            }
            return inputStream;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AzureException(e);
        }
    }

    @Override
    public FileMetadata[] list(String prefix, int maxListingCount, int maxListingDepth) throws IOException {
        return this.listInternal(prefix, maxListingCount, maxListingDepth);
    }

    private FileMetadata[] listInternal(String prefix, int maxListingCount, int maxListingDepth) throws IOException {
        try {
            this.checkContainer(ContainerAccessType.PureRead);
            if (0 < prefix.length() && !prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            boolean enableFlatListing = false;
            if (maxListingDepth < 0 && this.sessionConfiguration.getBoolean(KEY_ENABLE_FLAT_LISTING, false)) {
                enableFlatListing = true;
            }
            Iterable<ListBlobItem> objects = prefix.equals("/") ? this.listRootBlobs(true, enableFlatListing) : this.listRootBlobs(prefix, true, enableFlatListing);
            HashMap<String, FileMetadata> fileMetadata = new HashMap<String, FileMetadata>(256);
            for (ListBlobItem blobItem : objects) {
                if (0 < maxListingCount && fileMetadata.size() >= maxListingCount) break;
                if (blobItem instanceof StorageInterface.CloudBlockBlobWrapper || blobItem instanceof StorageInterface.CloudPageBlobWrapper) {
                    String blobKey = null;
                    StorageInterface.CloudBlobWrapper blob = (StorageInterface.CloudBlobWrapper)blobItem;
                    BlobProperties properties = blob.getProperties();
                    blobKey = this.normalizeKey(blob);
                    FileMetadata metadata = AzureNativeFileSystemStore.retrieveFolderAttribute(blob) ? new FileMetadata(blobKey, properties.getLastModified().getTime(), this.getPermissionStatus(blob), BlobMaterialization.Explicit, this.hadoopBlockSize) : new FileMetadata(blobKey, this.getDataLength(blob, properties), properties.getLastModified().getTime(), this.getPermissionStatus(blob), this.hadoopBlockSize);
                    fileMetadata.put(blobKey, metadata);
                    continue;
                }
                if (!(blobItem instanceof StorageInterface.CloudBlobDirectoryWrapper)) continue;
                StorageInterface.CloudBlobDirectoryWrapper directory = (StorageInterface.CloudBlobDirectoryWrapper)blobItem;
                String dirKey = this.normalizeKey(directory);
                if (dirKey.endsWith("/")) {
                    dirKey = dirKey.substring(0, dirKey.length() - 1);
                }
                FileMetadata directoryMetadata = new FileMetadata(dirKey, 0L, AzureNativeFileSystemStore.defaultPermissionNoBlobMetadata(), BlobMaterialization.Implicit, this.hadoopBlockSize);
                if (!fileMetadata.containsKey(dirKey)) {
                    fileMetadata.put(dirKey, directoryMetadata);
                }
                if (enableFlatListing) continue;
                this.buildUpList(directory, fileMetadata, maxListingCount, maxListingDepth - 1);
            }
            return fileMetadata.values().toArray(new FileMetadata[fileMetadata.size()]);
        }
        catch (Exception e) {
            throw new AzureException(e);
        }
    }

    private void buildUpList(StorageInterface.CloudBlobDirectoryWrapper aCloudBlobDirectory, HashMap<String, FileMetadata> metadataHashMap, int maxListingCount, int maxListingDepth) throws Exception {
        AzureLinkedStack<Iterator<ListBlobItem>> dirIteratorStack = new AzureLinkedStack<Iterator<ListBlobItem>>();
        Iterable<ListBlobItem> blobItems = aCloudBlobDirectory.listBlobs(null, false, EnumSet.of(BlobListingDetails.METADATA), null, this.getInstrumentedContext());
        Iterator<ListBlobItem> blobItemIterator = blobItems.iterator();
        if (0 == maxListingDepth || 0 == maxListingCount) {
            return;
        }
        boolean isUnboundedDepth = maxListingDepth < 0;
        int listingDepth = 1;
        while (null != blobItemIterator && (maxListingCount <= 0 || metadataHashMap.size() < maxListingCount)) {
            while (blobItemIterator.hasNext() && (0 >= maxListingCount || metadataHashMap.size() < maxListingCount)) {
                ListBlobItem blobItem = blobItemIterator.next();
                if (blobItem instanceof StorageInterface.CloudBlockBlobWrapper || blobItem instanceof StorageInterface.CloudPageBlobWrapper) {
                    String blobKey = null;
                    StorageInterface.CloudBlobWrapper blob = (StorageInterface.CloudBlobWrapper)blobItem;
                    BlobProperties properties = blob.getProperties();
                    blobKey = this.normalizeKey(blob);
                    FileMetadata metadata = AzureNativeFileSystemStore.retrieveFolderAttribute(blob) ? new FileMetadata(blobKey, properties.getLastModified().getTime(), this.getPermissionStatus(blob), BlobMaterialization.Explicit, this.hadoopBlockSize) : new FileMetadata(blobKey, this.getDataLength(blob, properties), properties.getLastModified().getTime(), this.getPermissionStatus(blob), this.hadoopBlockSize);
                    metadataHashMap.put(blobKey, metadata);
                    continue;
                }
                if (!(blobItem instanceof StorageInterface.CloudBlobDirectoryWrapper)) continue;
                StorageInterface.CloudBlobDirectoryWrapper directory = (StorageInterface.CloudBlobDirectoryWrapper)blobItem;
                if (isUnboundedDepth || maxListingDepth > listingDepth) {
                    dirIteratorStack.push(blobItemIterator);
                    ++listingDepth;
                    blobItems = directory.listBlobs(null, false, EnumSet.noneOf(BlobListingDetails.class), null, this.getInstrumentedContext());
                    blobItemIterator = blobItems.iterator();
                    continue;
                }
                String dirKey = this.normalizeKey(directory);
                if (metadataHashMap.containsKey(dirKey)) continue;
                FileMetadata directoryMetadata = new FileMetadata(dirKey, 0L, AzureNativeFileSystemStore.defaultPermissionNoBlobMetadata(), BlobMaterialization.Implicit, this.hadoopBlockSize);
                metadataHashMap.put(dirKey, directoryMetadata);
            }
            if (dirIteratorStack.isEmpty()) {
                blobItemIterator = null;
                continue;
            }
            blobItemIterator = (Iterator<ListBlobItem>)dirIteratorStack.pop();
            if (--listingDepth < 0) {
                throw new AssertionError((Object)"Non-negative listing depth expected");
            }
        }
    }

    private long getDataLength(StorageInterface.CloudBlobWrapper blob, BlobProperties properties) throws AzureException {
        if (blob instanceof StorageInterface.CloudPageBlobWrapper) {
            try {
                return PageBlobInputStream.getPageBlobDataSize((StorageInterface.CloudPageBlobWrapper)blob, this.getInstrumentedContext(this.isConcurrentOOBAppendAllowed()));
            }
            catch (Exception e) {
                throw new AzureException("Unexpected exception getting page blob actual data size.", e);
            }
        }
        return properties.getLength();
    }

    private void safeDelete(StorageInterface.CloudBlobWrapper blob, SelfRenewingLease lease) throws StorageException {
        OperationContext operationContext = this.getInstrumentedContext();
        try {
            blob.delete(operationContext, lease);
        }
        catch (StorageException e) {
            if (!NativeAzureFileSystemHelper.isFileNotFoundException(e)) {
                LOG.error("Encountered Storage Exception for delete on Blob: {}, Exception Details: {} Error Code: {}", new Object[]{blob.getUri(), e.getMessage(), e.getErrorCode()});
            }
            if (e.getErrorCode() != null && "BlobNotFound".equals(e.getErrorCode()) && operationContext.getRequestResults().size() > 1 && ((RequestResult)operationContext.getRequestResults().get(0)).getException() != null) {
                LOG.debug("Swallowing delete exception on retry: {}", (Object)e.getMessage());
                return;
            }
            throw e;
        }
        finally {
            if (lease != null) {
                lease.free();
            }
        }
    }

    @Override
    public boolean delete(String key, SelfRenewingLease lease) throws IOException {
        try {
            if (this.checkContainer(ContainerAccessType.ReadThenWrite) == ContainerState.DoesntExist) {
                return true;
            }
            StorageInterface.CloudBlobWrapper blob = this.getBlobReference(key);
            this.safeDelete(blob, lease);
            return true;
        }
        catch (Exception e) {
            if (e instanceof StorageException && NativeAzureFileSystemHelper.isFileNotFoundException((StorageException)((Object)e))) {
                return false;
            }
            throw new AzureException(e);
        }
    }

    @Override
    public boolean delete(String key) throws IOException {
        try {
            return this.delete(key, null);
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            if (t instanceof StorageException) {
                StorageException se = (StorageException)t;
                if ("LeaseIdMissing".equals(se.getErrorCode())) {
                    SelfRenewingLease lease = null;
                    try {
                        lease = this.acquireLease(key);
                        boolean bl = this.delete(key, lease);
                        return bl;
                    }
                    catch (AzureException e3) {
                        LOG.warn("Got unexpected exception trying to acquire lease on " + key + "." + e3.getMessage());
                        throw e3;
                    }
                    finally {
                        try {
                            if (lease != null) {
                                lease.free();
                            }
                        }
                        catch (Exception e4) {
                            LOG.error("Unable to free lease on " + key, (Throwable)e4);
                        }
                    }
                }
                throw e;
            }
            throw e;
        }
    }

    @Override
    public void rename(String srcKey, String dstKey) throws IOException {
        this.rename(srcKey, dstKey, false, null, true);
    }

    @Override
    public void rename(String srcKey, String dstKey, boolean acquireLease, SelfRenewingLease existingLease) throws IOException {
        this.rename(srcKey, dstKey, acquireLease, existingLease, true);
    }

    @Override
    public void rename(String srcKey, String dstKey, boolean acquireLease, SelfRenewingLease existingLease, boolean overwriteDestination) throws IOException {
        LOG.debug("Moving {} to {}", (Object)srcKey, (Object)dstKey);
        if (acquireLease && existingLease != null) {
            throw new IOException("Cannot acquire new lease if one already exists.");
        }
        StorageInterface.CloudBlobWrapper srcBlob = null;
        StorageInterface.CloudBlobWrapper dstBlob = null;
        SelfRenewingLease lease = null;
        try {
            if (null == this.storageInteractionLayer) {
                String errMsg = String.format("Storage session expected for URI '%s' but does not exist.", this.sessionUri);
                throw new AssertionError((Object)errMsg);
            }
            this.checkContainer(ContainerAccessType.ReadThenWrite);
            srcBlob = this.getBlobReference(srcKey);
            if (!srcBlob.exists(this.getInstrumentedContext())) {
                throw new AzureException("Source blob " + srcKey + " does not exist.");
            }
            if (acquireLease) {
                lease = srcBlob.acquireLease();
            } else if (existingLease != null) {
                lease = existingLease;
            }
            dstBlob = this.getBlobReference(dstKey);
            try {
                dstBlob.startCopyFromBlob(srcBlob, null, this.getInstrumentedContext(), overwriteDestination);
            }
            catch (StorageException se) {
                if (se.getHttpStatusCode() == 503) {
                    int copyBlobMinBackoff = this.sessionConfiguration.getInt(KEY_COPYBLOB_MIN_BACKOFF_INTERVAL, 3000);
                    int copyBlobMaxBackoff = this.sessionConfiguration.getInt(KEY_COPYBLOB_MAX_BACKOFF_INTERVAL, 90000);
                    int copyBlobDeltaBackoff = this.sessionConfiguration.getInt(KEY_COPYBLOB_BACKOFF_INTERVAL, 30000);
                    int copyBlobMaxRetries = this.sessionConfiguration.getInt(KEY_COPYBLOB_MAX_IO_RETRIES, 15);
                    BlobRequestOptions options = new BlobRequestOptions();
                    options.setRetryPolicyFactory((RetryPolicyFactory)new RetryExponentialRetry(copyBlobMinBackoff, copyBlobDeltaBackoff, copyBlobMaxBackoff, copyBlobMaxRetries));
                    dstBlob.startCopyFromBlob(srcBlob, options, this.getInstrumentedContext(), overwriteDestination);
                }
                throw se;
            }
            this.waitForCopyToComplete(dstBlob, this.getInstrumentedContext());
            this.safeDelete(srcBlob, lease);
        }
        catch (StorageException e) {
            if (e.getHttpStatusCode() == 503) {
                LOG.warn("Rename: CopyBlob: StorageException: ServerBusy: Retry complete, will attempt client side copy for page blob");
                InputStream ipStream = null;
                OutputStream opStream = null;
                try {
                    if (srcBlob.getProperties().getBlobType() == BlobType.PAGE_BLOB) {
                        int len;
                        ipStream = this.openInputStream(srcBlob);
                        opStream = this.openOutputStream(dstBlob);
                        byte[] buffer = new byte[512];
                        while ((len = ipStream.read(buffer)) != -1) {
                            opStream.write(buffer, 0, len);
                        }
                    } else {
                        throw new AzureException(e);
                    }
                    opStream.flush();
                    opStream.close();
                    ipStream.close();
                    this.safeDelete(srcBlob, lease);
                }
                catch (StorageException se) {
                    try {
                        LOG.warn("Rename: CopyBlob: StorageException: Failed");
                        throw new AzureException(se);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeStream(ipStream);
                        IOUtils.closeStream(opStream);
                        throw throwable;
                    }
                }
                IOUtils.closeStream((Closeable)ipStream);
                IOUtils.closeStream((Closeable)opStream);
            }
            throw new AzureException(e);
        }
        catch (URISyntaxException e) {
            throw new AzureException(e);
        }
    }

    private void waitForCopyToComplete(StorageInterface.CloudBlobWrapper blob, OperationContext opContext) {
        boolean copyInProgress = true;
        while (copyInProgress) {
            try {
                blob.downloadAttributes(opContext);
            }
            catch (StorageException storageException) {
                // empty catch block
            }
            if (!(copyInProgress = blob.getCopyState() != null && blob.getCopyState().getStatus() == CopyStatus.PENDING)) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean explicitFileExists(String key) throws AzureException {
        try {
            StorageInterface.CloudBlobWrapper blob = this.getBlobReference(key);
            return null != blob && blob.exists(this.getInstrumentedContext());
        }
        catch (StorageException e) {
            throw new AzureException(e);
        }
        catch (URISyntaxException e) {
            throw new AzureException(e);
        }
    }

    @Override
    public void changePermissionStatus(String key, PermissionStatus newPermission) throws AzureException {
        try {
            this.checkContainer(ContainerAccessType.ReadThenWrite);
            StorageInterface.CloudBlobWrapper blob = this.getBlobReference(key);
            blob.downloadAttributes(this.getInstrumentedContext());
            AzureNativeFileSystemStore.storePermissionStatus(blob, newPermission);
            blob.uploadMetadata(this.getInstrumentedContext());
        }
        catch (Exception e) {
            throw new AzureException(e);
        }
    }

    @Override
    public void purge(String prefix) throws IOException {
        try {
            if (null == this.storageInteractionLayer) {
                String errMsg = String.format("Storage session expected for URI '%s' but does not exist.", this.sessionUri);
                throw new AssertionError((Object)errMsg);
            }
            if (this.checkContainer(ContainerAccessType.ReadThenWrite) == ContainerState.DoesntExist) {
                return;
            }
            Iterable<ListBlobItem> objects = this.listRootBlobs(prefix, false, false);
            for (ListBlobItem blobItem : objects) {
                ((CloudBlob)blobItem).delete(DeleteSnapshotsOption.NONE, null, null, this.getInstrumentedContext());
            }
        }
        catch (Exception e) {
            throw new AzureException(e);
        }
    }

    @Override
    public SelfRenewingLease acquireLease(String key) throws AzureException {
        LOG.debug("acquiring lease on {}", (Object)key);
        try {
            this.checkContainer(ContainerAccessType.ReadThenWrite);
            StorageInterface.CloudBlobWrapper blob = this.getBlobReference(key);
            return blob.acquireLease();
        }
        catch (Exception e) {
            throw new AzureException(e);
        }
    }

    @Override
    public void updateFolderLastModifiedTime(String key, Date lastModified, SelfRenewingLease folderLease) throws AzureException {
        try {
            this.checkContainer(ContainerAccessType.ReadThenWrite);
            StorageInterface.CloudBlobWrapper blob = this.getBlobReference(key);
            blob.uploadProperties(this.getInstrumentedContext(), folderLease);
        }
        catch (Exception e) {
            throw new AzureException(e);
        }
    }

    @Override
    public void updateFolderLastModifiedTime(String key, SelfRenewingLease folderLease) throws AzureException {
        Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
        lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
        Date lastModified = lastModifiedCalendar.getTime();
        this.updateFolderLastModifiedTime(key, lastModified, folderLease);
    }

    @Override
    public void dump() throws IOException {
    }

    @Override
    public void close() {
        if (this.bandwidthGaugeUpdater != null) {
            this.bandwidthGaugeUpdater.close();
            this.bandwidthGaugeUpdater = null;
        }
    }

    protected void finalize() throws Throwable {
        LOG.debug("finalize() called");
        this.close();
        super.finalize();
    }

    @Override
    public DataOutputStream retrieveAppendStream(String key, int bufferSize) throws IOException {
        try {
            BlockBlobAppendStream blockBlobOutputStream;
            if (this.isPageBlobKey(key)) {
                throw new UnsupportedOperationException("Append not supported for Page Blobs");
            }
            StorageInterface.CloudBlobWrapper blob = this.container.getBlockBlobReference(key);
            BlockBlobAppendStream outputStream = blockBlobOutputStream = new BlockBlobAppendStream((StorageInterface.CloudBlockBlobWrapper)blob, key, bufferSize, this.isBlockBlobWithCompactionKey(key), this.getInstrumentedContext());
            SyncableDataOutputStream dataOutStream = new SyncableDataOutputStream(outputStream);
            return dataOutStream;
        }
        catch (Exception ex) {
            throw new AzureException(ex);
        }
    }

    private static enum ContainerAccessType {
        PureRead,
        PureWrite,
        ReadThenWrite;

    }

    private static enum ContainerState {
        Unknown,
        DoesntExist,
        ExistsNoVersion,
        ExistsAtWrongVersion,
        ExistsAtRightVersion;

    }

    private static class PermissionStatusJsonSerializer
    implements JSON.Convertor {
        private static final String OWNER_TAG = "owner";
        private static final String GROUP_TAG = "group";
        private static final String PERMISSIONS_TAG = "permissions";

        private PermissionStatusJsonSerializer() {
        }

        public void toJSON(Object obj, JSON.Output out) {
            PermissionStatus permissionStatus = (PermissionStatus)obj;
            String group = permissionStatus.getGroupName() == null ? "" : permissionStatus.getGroupName();
            out.add(OWNER_TAG, (Object)permissionStatus.getUserName());
            out.add(GROUP_TAG, (Object)group);
            out.add(PERMISSIONS_TAG, (Object)permissionStatus.getPermission().toString());
        }

        public Object fromJSON(Map object) {
            return PermissionStatusJsonSerializer.fromJSONMap(object);
        }

        public static PermissionStatus fromJSONString(String jsonString) {
            return PermissionStatusJsonSerializer.fromJSONMap((Map)PERMISSION_JSON_SERIALIZER.fromJSON(jsonString));
        }

        private static PermissionStatus fromJSONMap(Map object) {
            return new PermissionStatus((String)object.get(OWNER_TAG), (String)object.get(GROUP_TAG), FsPermission.valueOf((String)("-" + (String)object.get(PERMISSIONS_TAG))));
        }
    }

    @VisibleForTesting
    static interface TestHookOperationContext {
        public OperationContext modifyOperationContext(OperationContext var1);
    }
}

