/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.openssl.OpenSSLProvider;
import org.wildfly.openssl.SSL;

public final class SSLSocketFactoryEx
extends SSLSocketFactory {
    private static SSLSocketFactoryEx instance = null;
    private static final Logger LOG = LoggerFactory.getLogger(SSLSocketFactoryEx.class);
    private String providerName;
    private SSLContext ctx;
    private String[] ciphers;
    private SSLChannelMode channelMode;

    public static synchronized void initializeDefaultFactory(SSLChannelMode preferredMode) throws IOException {
        if (instance == null) {
            instance = new SSLSocketFactoryEx(preferredMode);
        }
    }

    public static SSLSocketFactoryEx getDefaultFactory() {
        return instance;
    }

    private SSLSocketFactoryEx(SSLChannelMode preferredChannelMode) throws IOException {
        try {
            this.initializeSSLContext(preferredChannelMode);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        catch (KeyManagementException e) {
            throw new IOException(e);
        }
        SSLSocketFactory factory = this.ctx.getSocketFactory();
        String[] defaultCiphers = factory.getSupportedCipherSuites();
        String version = System.getProperty("java.version");
        this.ciphers = this.channelMode == SSLChannelMode.Default_JSSE && version.startsWith("1.8") ? this.alterCipherList(defaultCiphers) : defaultCiphers;
        this.providerName = this.ctx.getProvider().getName() + "-" + this.ctx.getProvider().getVersion();
    }

    private void initializeSSLContext(SSLChannelMode preferredChannelMode) throws NoSuchAlgorithmException, KeyManagementException {
        switch (preferredChannelMode) {
            case Default: {
                try {
                    java.util.logging.Logger logger = java.util.logging.Logger.getLogger(SSL.class.getName());
                    logger.setLevel(Level.WARNING);
                    this.ctx = SSLContext.getInstance("openssl.TLS");
                    this.ctx.init(null, null, null);
                    logger.setLevel(Level.INFO);
                    this.channelMode = SSLChannelMode.OpenSSL;
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.warn("Failed to load OpenSSL. Falling back to the JSSE default.");
                    this.ctx = SSLContext.getDefault();
                    this.channelMode = SSLChannelMode.Default_JSSE;
                }
                break;
            }
            case OpenSSL: {
                this.ctx = SSLContext.getInstance("openssl.TLS");
                this.ctx.init(null, null, null);
                this.channelMode = SSLChannelMode.OpenSSL;
                break;
            }
            case Default_JSSE: {
                this.ctx = SSLContext.getDefault();
                this.channelMode = SSLChannelMode.Default_JSSE;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown channel mode: " + (Object)((Object)preferredChannelMode)));
            }
        }
    }

    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return (String[])this.ciphers.clone();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return (String[])this.ciphers.clone();
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocketFactory factory = this.ctx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket();
        this.configureSocket(ss);
        return ss;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocketFactory factory = this.ctx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(s, host, port, autoClose);
        this.configureSocket(ss);
        return ss;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocketFactory factory = this.ctx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(address, port, localAddress, localPort);
        this.configureSocket(ss);
        return ss;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        SSLSocketFactory factory = this.ctx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port, localHost, localPort);
        this.configureSocket(ss);
        return ss;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocketFactory factory = this.ctx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port);
        this.configureSocket(ss);
        return ss;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocketFactory factory = this.ctx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port);
        this.configureSocket(ss);
        return ss;
    }

    private void configureSocket(SSLSocket ss) throws SocketException {
        ss.setEnabledCipherSuites(this.ciphers);
    }

    private String[] alterCipherList(String[] defaultCiphers) {
        ArrayList<String> preferredSuits = new ArrayList<String>();
        for (int i = 0; i < defaultCiphers.length; ++i) {
            if (defaultCiphers[i].contains("_GCM_")) {
                LOG.debug("Removed Cipher - " + defaultCiphers[i]);
                continue;
            }
            preferredSuits.add(defaultCiphers[i]);
        }
        this.ciphers = preferredSuits.toArray(new String[0]);
        return this.ciphers;
    }

    static {
        OpenSSLProvider.register();
    }

    public static enum SSLChannelMode {
        OpenSSL,
        Default,
        Default_JSSE;

    }
}

