/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.contracts.services;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public enum AzureServiceErrorCode {
    FILE_SYSTEM_ALREADY_EXISTS("FilesystemAlreadyExists", 409, null),
    PATH_ALREADY_EXISTS("PathAlreadyExists", 409, null),
    INTERNAL_OPERATION_ABORT("InternalOperationAbortError", 409, null),
    PATH_CONFLICT("PathConflict", 409, null),
    FILE_SYSTEM_NOT_FOUND("FilesystemNotFound", 404, null),
    PATH_NOT_FOUND("PathNotFound", 404, null),
    PRE_CONDITION_FAILED("PreconditionFailed", 412, null),
    SOURCE_PATH_NOT_FOUND("SourcePathNotFound", 404, null),
    INVALID_SOURCE_OR_DESTINATION_RESOURCE_TYPE("InvalidSourceOrDestinationResourceType", 409, null),
    RENAME_DESTINATION_PARENT_PATH_NOT_FOUND("RenameDestinationParentPathNotFound", 404, null),
    INVALID_RENAME_SOURCE_PATH("InvalidRenameSourcePath", 409, null),
    INGRESS_OVER_ACCOUNT_LIMIT(null, 503, "Ingress is over the account limit."),
    EGRESS_OVER_ACCOUNT_LIMIT(null, 503, "Egress is over the account limit."),
    INVALID_QUERY_PARAMETER_VALUE("InvalidQueryParameterValue", 400, null),
    AUTHORIZATION_PERMISSION_MISS_MATCH("AuthorizationPermissionMismatch", 403, null),
    ACCOUNT_REQUIRES_HTTPS("AccountRequiresHttps", 400, null),
    UNKNOWN(null, -1, null);

    private final String errorCode;
    private final int httpStatusCode;
    private final String errorMessage;

    private AzureServiceErrorCode(String errorCode, int httpStatusCodes, String errorMessage) {
        this.errorCode = errorCode;
        this.httpStatusCode = httpStatusCodes;
        this.errorMessage = errorMessage;
    }

    public int getStatusCode() {
        return this.httpStatusCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public static List<AzureServiceErrorCode> getAzureServiceCode(int httpStatusCode) {
        ArrayList<AzureServiceErrorCode> errorCodes = new ArrayList<AzureServiceErrorCode>();
        if (httpStatusCode == AzureServiceErrorCode.UNKNOWN.httpStatusCode) {
            errorCodes.add(UNKNOWN);
            return errorCodes;
        }
        for (AzureServiceErrorCode azureServiceErrorCode : AzureServiceErrorCode.values()) {
            if (azureServiceErrorCode.httpStatusCode != httpStatusCode) continue;
            errorCodes.add(azureServiceErrorCode);
        }
        return errorCodes;
    }

    public static AzureServiceErrorCode getAzureServiceCode(int httpStatusCode, String errorCode) {
        if (errorCode == null || errorCode.isEmpty() || httpStatusCode == AzureServiceErrorCode.UNKNOWN.httpStatusCode) {
            return UNKNOWN;
        }
        for (AzureServiceErrorCode azureServiceErrorCode : AzureServiceErrorCode.values()) {
            if (!errorCode.equalsIgnoreCase(azureServiceErrorCode.errorCode) || azureServiceErrorCode.httpStatusCode != httpStatusCode) continue;
            return azureServiceErrorCode;
        }
        return UNKNOWN;
    }

    public static AzureServiceErrorCode getAzureServiceCode(int httpStatusCode, String errorCode, String errorMessage) {
        if (errorCode == null || errorCode.isEmpty() || httpStatusCode == AzureServiceErrorCode.UNKNOWN.httpStatusCode || errorMessage == null || errorMessage.isEmpty()) {
            return UNKNOWN;
        }
        for (AzureServiceErrorCode azureServiceErrorCode : AzureServiceErrorCode.values()) {
            if (azureServiceErrorCode.httpStatusCode != httpStatusCode || !errorCode.equalsIgnoreCase(azureServiceErrorCode.errorCode) || !errorMessage.equalsIgnoreCase(azureServiceErrorCode.errorMessage)) continue;
            return azureServiceErrorCode;
        }
        return UNKNOWN;
    }
}

