/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.staging.StagingDirectoryCapable;
import org.apache.hadoop.fs.staging.StagingDirectoryService;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileSystemOptimizedCommitter
extends FileOutputCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemOptimizedCommitter.class);
    private static final String STAGE_NAME_SEGMENT_SEPARATOR = "_";
    private final Object lock = new Object();
    private final Path outputPath;
    private final Configuration conf;
    private final String stageName;
    private volatile Path stagingDirectory;

    public FileSystemOptimizedCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        FileSystemOptimizedCommitter.checkStagingDirectorySupport(outputPath, context);
        this.outputPath = outputPath;
        this.conf = context.getConfiguration();
        this.stageName = FileSystemOptimizedCommitter.getStageName(context);
    }

    @Override
    @Deprecated
    public Path getJobAttemptPath(JobContext context) {
        throw new UnsupportedOperationException("Committer does not use a job attempt directory");
    }

    @Override
    @Deprecated
    protected Path getJobAttemptPath(int appAttemptId) {
        throw new UnsupportedOperationException("Committer does not use a job attempt directory");
    }

    @Override
    @Deprecated
    public Path getTaskAttemptPath(TaskAttemptContext context) {
        throw new UnsupportedOperationException("Committer does not support getting task attempt paths directly");
    }

    @Override
    @Deprecated
    public Path getCommittedTaskPath(TaskAttemptContext context) {
        throw new UnsupportedOperationException("Committer does not use a committed task path");
    }

    @Override
    @Deprecated
    protected Path getCommittedTaskPath(int appAttemptId, TaskAttemptContext context) {
        throw new UnsupportedOperationException("Committer does not use a committed task path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Path getWorkPath() throws IOException {
        if (!this.hasOutputPath() || this.stageName == null) {
            return null;
        }
        if (this.stagingDirectory == null) {
            boolean createDirectory = false;
            Object object = this.lock;
            synchronized (object) {
                if (this.stagingDirectory == null) {
                    StagingDirectoryService stagingService = this.getStagingDirectoryService(this.conf);
                    this.stagingDirectory = stagingService.makeStagingDirectory(this.outputPath, this.stageName);
                    createDirectory = true;
                }
            }
            if (createDirectory) {
                LOG.info("Created staging directory at {} named {} when getting work path", (Object)this.outputPath, (Object)this.stageName);
            }
        }
        return this.stagingDirectory;
    }

    @Override
    public void setupJob(JobContext context) {
        if (this.hasOutputPath()) {
            LOG.info("Nothing to setup as successful task attempt outputs are written directly");
        }
    }

    @Override
    public void commitJob(JobContext context) throws IOException {
        if (this.hasOutputPath() && context.getConfiguration().getBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", true)) {
            Path markerPath = new Path(this.outputPath, "_SUCCESS");
            FileSystem fs = markerPath.getFileSystem(context.getConfiguration());
            fs.create(markerPath, true).close();
        }
    }

    @Override
    @Deprecated
    public void cleanupJob(JobContext context) {
        if (this.hasOutputPath()) {
            LOG.info("Nothing to clean up since no temporary files were written");
        }
    }

    @Override
    public void abortJob(JobContext context, JobStatus.State state) {
        if (this.hasOutputPath()) {
            LOG.info("Nothing to do when job is aborted");
        }
    }

    @Override
    public void setupTask(TaskAttemptContext context) {
    }

    @Override
    public void commitTask(TaskAttemptContext context) throws IOException {
        if (this.hasOutputPath()) {
            String stageNameForContext;
            StagingDirectoryService stagingDirectoryService = this.getStagingDirectoryService(context);
            if (stagingDirectoryService.hasStagingDirectory(this.outputPath, stageNameForContext = FileSystemOptimizedCommitter.getStageName(context))) {
                FileSystemOptimizedCommitter.publishStagingDirectory(stagingDirectoryService, this.outputPath, stageNameForContext);
            } else {
                LOG.info("No staging directory to publish at {} named {}", (Object)this.outputPath, (Object)stageNameForContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void publishStagingDirectory(StagingDirectoryService stagingDirectoryService, Path outputPath, String stageName) throws IOException {
        LOG.info("Publishing staging directory at {} named {}", (Object)outputPath, (Object)stageName);
        try {
            stagingDirectoryService.publishStagingDirectory(outputPath, stageName);
        }
        catch (Throwable throwable) {
            LOG.info("Deleting staging directory at {} named {}", (Object)outputPath, (Object)stageName);
            try {
                stagingDirectoryService.deleteStagingDirectory(outputPath, stageName);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete staging directory (outputPath: {}, stageName: {})", new Object[]{outputPath, stageName, e});
            }
            throw throwable;
        }
        LOG.info("Deleting staging directory at {} named {}", (Object)outputPath, (Object)stageName);
        try {
            stagingDirectoryService.deleteStagingDirectory(outputPath, stageName);
        }
        catch (IOException e) {
            LOG.warn("Failed to delete staging directory (outputPath: {}, stageName: {})", new Object[]{outputPath, stageName, e});
        }
    }

    @Override
    @InterfaceAudience.Private
    @Deprecated
    public void commitTask(TaskAttemptContext context, Path taskAttemptPath) throws IOException {
        if (this.hasOutputPath()) {
            if (taskAttemptPath != null) {
                throw new UnsupportedOperationException("Custom task attempt paths are not supported");
            }
            this.commitTask(context);
        }
    }

    @Override
    public void abortTask(TaskAttemptContext context) throws IOException {
        if (this.hasOutputPath()) {
            String stageNameForContext = FileSystemOptimizedCommitter.getStageName(context);
            LOG.info("Deleting staging directory at {} named {}", (Object)this.outputPath, (Object)stageNameForContext);
            this.getStagingDirectoryService(context).deleteStagingDirectory(this.outputPath, stageNameForContext);
        }
    }

    @Override
    @InterfaceAudience.Private
    @Deprecated
    public void abortTask(TaskAttemptContext context, Path taskAttemptPath) throws IOException {
        if (this.hasOutputPath()) {
            if (taskAttemptPath != null) {
                throw new UnsupportedOperationException("Custom task attempt paths are not supported");
            }
            this.abortTask(context);
        }
    }

    @Override
    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        if (this.hasOutputPath()) {
            StagingDirectoryService stagingDirectoryService = this.getStagingDirectoryService(context);
            return stagingDirectoryService.hasStagingDirectory(this.outputPath, FileSystemOptimizedCommitter.getStageName(context));
        }
        return false;
    }

    @Override
    @InterfaceAudience.Private
    @Deprecated
    public boolean needsTaskCommit(TaskAttemptContext context, Path taskAttemptPath) throws IOException {
        if (this.hasOutputPath()) {
            if (taskAttemptPath != null) {
                throw new UnsupportedOperationException("Custom task attempt paths are not supported");
            }
            return this.needsTaskCommit(context);
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean isRecoverySupported() {
        return false;
    }

    @Override
    public boolean isRecoverySupported(JobContext jobContext) {
        return false;
    }

    @Override
    public void recoverTask(TaskAttemptContext context) {
        if (this.hasOutputPath()) {
            throw new UnsupportedOperationException(String.format("Recovering task is not supported (taskAttemptId: %s)", context.getTaskAttemptID()));
        }
    }

    @Override
    public boolean isCommitJobRepeatable(JobContext context) {
        return true;
    }

    private StagingDirectoryService getStagingDirectoryService(JobContext context) throws IOException {
        return this.getStagingDirectoryService(context.getConfiguration());
    }

    private StagingDirectoryService getStagingDirectoryService(Configuration thisConf) throws IOException {
        FileSystem fs = this.outputPath.getFileSystem(thisConf);
        return ((StagingDirectoryCapable)((Object)fs)).getStagingDirectoryService();
    }

    private static void checkStagingDirectorySupport(Path outputPath, JobContext context) throws IOException {
        if (outputPath != null) {
            FileSystem fs = outputPath.getFileSystem(context.getConfiguration());
            Preconditions.checkArgument((boolean)(fs instanceof StagingDirectoryCapable), (String)"FileSystem %s does not support staging directories (outputPath: %s, jobOrAttemptId: %s)", (Object[])new Object[]{fs, outputPath, FileSystemOptimizedCommitter.getTaskAttemptIdOrJobId(context)});
        }
    }

    private static String getTaskAttemptIdOrJobId(JobContext context) {
        return context instanceof TaskAttemptContext ? ((TaskAttemptContext)context).getTaskAttemptID().toString() : context.getJobID().toString();
    }

    private static String getStageName(TaskAttemptContext context) {
        return Joiner.on((String)STAGE_NAME_SEGMENT_SEPARATOR).join((Object)FileSystemOptimizedCommitter.getAppAttemptId(context), (Object)context.getTaskAttemptID(), new Object[0]);
    }

    private static int getAppAttemptId(JobContext context) {
        return context.getConfiguration().getInt("mapreduce.job.application.attempt.id", 0);
    }
}

