/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.com.google.inject.servlet.RequestScoped;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
@RequestScoped
public class ResponseInfo
implements Iterable<Item> {
    final List<Item> items = Lists.newArrayList();
    String about = "Info";

    public static ResponseInfo $about(String about) {
        ResponseInfo info = new ResponseInfo();
        info.about = about;
        return info;
    }

    public ResponseInfo about(String about) {
        this.about = about;
        return this;
    }

    public String about() {
        return this.about;
    }

    public ResponseInfo __(String key, Object value) {
        this.items.add(Item.of(key, value, false));
        return this;
    }

    public ResponseInfo __(String key, String url, Object anchor) {
        if (url == null) {
            this.items.add(Item.of(key, anchor, false));
        } else {
            this.items.add(Item.of(key, url, anchor));
        }
        return this;
    }

    public ResponseInfo _r(String key, Object value) {
        this.items.add(Item.of(key, value, true));
        return this;
    }

    public void clear() {
        this.items.clear();
    }

    @Override
    public Iterator<Item> iterator() {
        return this.items.iterator();
    }

    public static class Item {
        public final String key;
        public final String url;
        public final Object value;
        public final boolean isRaw;

        Item(String key, String url, Object value, boolean isRaw) {
            this.key = key;
            this.url = url;
            this.value = value;
            this.isRaw = isRaw;
        }

        public static Item of(String key, Object value, boolean isRaw) {
            return new Item(key, null, value, isRaw);
        }

        public static Item of(String key, String url, Object value) {
            return new Item(key, url, value, false);
        }
    }
}

