/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in org.apache.hadoop.shaded.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org.apache.hadoop.shaded.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.shaded.org.apache.hadoop.org.apache.hadoop.shaded.io.org.apache.hadoop.shaded.com.ress;

import java.org.apache.hadoop.shaded.io.IOException;
import java.org.apache.hadoop.shaded.io.OutputStream;

import org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.org.apache.hadoop.org.apache.hadoop.shaded.io.org.apache.hadoop.shaded.com.ress.CompressionOutputStream;
import org.apache.hadoop.shaded.org.apache.hadoop.org.apache.hadoop.shaded.io.org.apache.hadoop.shaded.com.ress.Compressor;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CompressorStream extends CompressionOutputStream {
  protected Compressor org.apache.hadoop.shaded.com.ressor;
  protected byte[] buffer;
  protected boolean closed = false;
  
  public CompressorStream(OutputStream out, Compressor org.apache.hadoop.shaded.com.ressor, int bufferSize) {
    super(out);

    if (out == null || org.apache.hadoop.shaded.com.ressor == null) {
      throw new NullPointerException();
    } else if (bufferSize <= 0) {
      throw new IllegalArgumentException("Illegal bufferSize");
    }

    this.org.apache.hadoop.shaded.com.ressor = org.apache.hadoop.shaded.com.ressor;
    buffer = new byte[bufferSize];
  }

  public CompressorStream(OutputStream out, Compressor org.apache.hadoop.shaded.com.ressor) {
    this(out, org.apache.hadoop.shaded.com.ressor, 512);
  }
  
  /**
   * Allow derived classes to directly set the underlying stream.
   * 
   * @param out Underlying output stream.
   */
  protected CompressorStream(OutputStream out) {
    super(out);
  }

  @Override
  public void write(byte[] b, int off, int len) throws IOException {
    // Sanity checks
    if (org.apache.hadoop.shaded.com.ressor.finished()) {
      throw new IOException("write beyond end of stream");
    }
    if ((off | len | (off + len) | (b.length - (off + len))) < 0) {
      throw new IndexOutOfBoundsException();
    } else if (len == 0) {
      return;
    }

    org.apache.hadoop.shaded.com.ressor.setInput(b, off, len);
    while (!org.apache.hadoop.shaded.com.ressor.needsInput()) {
      org.apache.hadoop.shaded.com.ress();
    }
  }

  protected void org.apache.hadoop.shaded.com.ress() throws IOException {
    int len = org.apache.hadoop.shaded.com.ressor.org.apache.hadoop.shaded.com.ress(buffer, 0, buffer.length);
    if (len > 0) {
      out.write(buffer, 0, len);
    }
  }

  @Override
  public void finish() throws IOException {
    if (!org.apache.hadoop.shaded.com.ressor.finished()) {
      org.apache.hadoop.shaded.com.ressor.finish();
      while (!org.apache.hadoop.shaded.com.ressor.finished()) {
        org.apache.hadoop.shaded.com.ress();
      }
    }
  }

  @Override
  public void resetState() throws IOException {
    org.apache.hadoop.shaded.com.ressor.reset();
  }
  
  @Override
  public void close() throws IOException {
    if (!closed) {
      try {
        super.close();
      }
      finally {
        closed = true;
      }
    }
  }

  private byte[] oneByte = new byte[1];
  @Override
  public void write(int b) throws IOException {
    oneByte[0] = (byte)(b & 0xff);
    write(oneByte, 0, oneByte.length);
  }

}
