/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobIndexInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.util.Records;

public class UnparsedJob
implements Job {
    private final JobIndexInfo jobIndexInfo;
    private final int maxTasksAllowed;
    private JobReport jobReport;
    private final HistoryFileManager.HistoryFileInfo jhfInfo;

    public UnparsedJob(int maxTasksAllowed, JobIndexInfo jobIndexInfo, HistoryFileManager.HistoryFileInfo jhfInfo) throws IOException {
        this.jobIndexInfo = jobIndexInfo;
        this.jhfInfo = jhfInfo;
        this.maxTasksAllowed = maxTasksAllowed;
    }

    public int getMaxTasksAllowed() {
        return this.maxTasksAllowed;
    }

    public JobId getID() {
        return this.jobIndexInfo.getJobId();
    }

    public String getName() {
        return this.jobIndexInfo.getJobName();
    }

    public JobState getState() {
        return JobState.valueOf((String)this.jobIndexInfo.getJobStatus());
    }

    public synchronized JobReport getReport() {
        if (this.jobReport == null) {
            this.jobReport = this.constructJobReport();
        }
        return this.jobReport;
    }

    public JobReport constructJobReport() {
        JobReport report = (JobReport)Records.newRecord(JobReport.class);
        report.setJobId(this.getID());
        report.setJobState(this.getState());
        report.setSubmitTime(this.jobIndexInfo.getSubmitTime());
        report.setStartTime(this.jobIndexInfo.getJobStartTime());
        report.setFinishTime(this.jobIndexInfo.getFinishTime());
        report.setJobName(this.jobIndexInfo.getJobName());
        report.setUser(this.jobIndexInfo.getUser());
        report.setJobFile(this.getConfFile().toString());
        report.setHistoryFile(this.jhfInfo.getHistoryFile().toString());
        return report;
    }

    public Counters getAllCounters() {
        return new Counters();
    }

    public Map<TaskId, Task> getTasks() {
        return new HashMap<TaskId, Task>();
    }

    public Map<TaskId, Task> getTasks(TaskType taskType) {
        return new HashMap<TaskId, Task>();
    }

    public Task getTask(TaskId taskID) {
        return null;
    }

    public List<String> getDiagnostics() {
        return new ArrayList<String>();
    }

    public int getTotalMaps() {
        return this.jobIndexInfo.getNumMaps();
    }

    public int getTotalReduces() {
        return this.jobIndexInfo.getNumReduces();
    }

    public int getCompletedMaps() {
        return -1;
    }

    public int getCompletedReduces() {
        return -1;
    }

    public float getProgress() {
        return 1.0f;
    }

    public boolean isUber() {
        return false;
    }

    public String getUserName() {
        return this.jobIndexInfo.getUser();
    }

    public String getQueueName() {
        return this.jobIndexInfo.getQueueName();
    }

    public Path getConfFile() {
        return this.jhfInfo.getConfFile();
    }

    public Configuration loadConfFile() throws IOException {
        return this.jhfInfo.loadConfFile();
    }

    public Map<JobACL, AccessControlList> getJobACLs() {
        return new HashMap<JobACL, AccessControlList>();
    }

    public TaskAttemptCompletionEvent[] getTaskAttemptCompletionEvents(int fromEventId, int maxEvents) {
        return new TaskAttemptCompletionEvent[0];
    }

    public TaskCompletionEvent[] getMapAttemptCompletionEvents(int startIndex, int maxEvents) {
        return TaskCompletionEvent.EMPTY_ARRAY;
    }

    public List<AMInfo> getAMInfos() {
        return new ArrayList<AMInfo>();
    }

    public boolean checkAccess(UserGroupInformation callerUGI, JobACL jobOperation) {
        return true;
    }

    public void setQueueName(String queueName) {
        throw new UnsupportedOperationException("Can't set job's queue name in history");
    }

    public void setJobPriority(Priority priority) {
        throw new UnsupportedOperationException("Can't set job's priority in history");
    }

    public int getFailedMaps() {
        return -1;
    }

    public int getFailedReduces() {
        return -1;
    }

    public int getKilledMaps() {
        return -1;
    }

    public int getKilledReduces() {
        return -1;
    }
}

