/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.spi;

import java.util.Set;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.inject.Binder;
import org.apache.hadoop.shaded.com.google.inject.ConfigurationException;
import org.apache.hadoop.shaded.com.google.inject.spi.Element;
import org.apache.hadoop.shaded.com.google.inject.spi.ElementVisitor;
import org.apache.hadoop.shaded.com.google.inject.spi.InjectionPoint;

public final class StaticInjectionRequest
implements Element {
    private final Object source;
    private final Class<?> type;

    StaticInjectionRequest(Object source, Class<?> type) {
        this.source = Preconditions.checkNotNull((Object)source, (Object)"source");
        this.type = (Class)Preconditions.checkNotNull(type, (Object)"type");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() throws ConfigurationException {
        return InjectionPoint.forStaticMethodsAndFields(this.type);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).requestStaticInjection(this.type);
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

