/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation.planning;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.PeriodicRLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.ContractValidationException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.ReservationAgent;

public abstract class PlanningAlgorithm
implements ReservationAgent {
    protected boolean allocateUser(ReservationId reservationId, String user, Plan plan, ReservationDefinition contract, ReservationAllocation oldReservation) throws PlanningException, ContractValidationException {
        ReservationDefinition adjustedContract = this.adjustContract(plan, contract);
        RLESparseResourceAllocation allocation = this.computeJobAllocation(plan, reservationId, adjustedContract, user);
        long period = Long.parseLong(contract.getRecurrenceExpression());
        if (contract.getRecurrenceExpression() != null && period > 0L) {
            allocation = new PeriodicRLESparseResourceAllocation(allocation, (Long)period);
        }
        if (allocation == null) {
            throw new PlanningException("The planning algorithm could not find a valid allocation for your request");
        }
        long step = plan.getStep();
        long jobArrival = PlanningAlgorithm.stepRoundUp(adjustedContract.getArrival(), step);
        long jobDeadline = PlanningAlgorithm.stepRoundUp(adjustedContract.getDeadline(), step);
        Map<ReservationInterval, Resource> mapAllocations = this.allocationsToPaddedMap(allocation, jobArrival, jobDeadline, period);
        InMemoryReservationAllocation capReservation = new InMemoryReservationAllocation(reservationId, adjustedContract, user, plan.getQueueName(), adjustedContract.getArrival(), adjustedContract.getDeadline(), mapAllocations, plan.getResourceCalculator(), plan.getMinimumAllocation());
        if (oldReservation != null) {
            return plan.updateReservation(capReservation);
        }
        return plan.addReservation(capReservation, false);
    }

    private Map<ReservationInterval, Resource> allocationsToPaddedMap(RLESparseResourceAllocation allocation, long jobArrival, long jobDeadline, long period) {
        Resource zeroResource = Resource.newInstance((int)0, (int)0);
        if (period > 0L) {
            if (jobDeadline - jobArrival >= period) {
                allocation.addInterval(new ReservationInterval(0L, period), zeroResource);
            }
            if ((jobArrival %= period) <= (jobDeadline %= period)) {
                allocation.addInterval(new ReservationInterval(0L, jobArrival), zeroResource);
                allocation.addInterval(new ReservationInterval(jobDeadline, period), zeroResource);
            } else {
                allocation.addInterval(new ReservationInterval(jobDeadline, jobArrival), zeroResource);
            }
        } else {
            long latestEnd;
            long earliestStart = PlanningAlgorithm.findEarliestTime(allocation.toIntervalMap());
            if (jobArrival < earliestStart) {
                allocation.addInterval(new ReservationInterval(jobArrival, earliestStart), zeroResource);
            }
            if ((latestEnd = PlanningAlgorithm.findLatestTime(allocation.toIntervalMap())) < jobDeadline) {
                allocation.addInterval(new ReservationInterval(latestEnd, jobDeadline), zeroResource);
            }
        }
        return allocation.toIntervalMap();
    }

    public abstract RLESparseResourceAllocation computeJobAllocation(Plan var1, ReservationId var2, ReservationDefinition var3, String var4) throws PlanningException, ContractValidationException;

    @Override
    public boolean createReservation(ReservationId reservationId, String user, Plan plan, ReservationDefinition contract) throws PlanningException {
        return this.allocateUser(reservationId, user, plan, contract, null);
    }

    @Override
    public boolean updateReservation(ReservationId reservationId, String user, Plan plan, ReservationDefinition contract) throws PlanningException {
        ReservationAllocation oldAlloc = plan.getReservationById(reservationId);
        return this.allocateUser(reservationId, user, plan, contract, oldAlloc);
    }

    @Override
    public boolean deleteReservation(ReservationId reservationId, String user, Plan plan) throws PlanningException {
        return plan.deleteReservation(reservationId);
    }

    protected static long findEarliestTime(Map<ReservationInterval, Resource> sesInt) {
        long ret = Long.MAX_VALUE;
        for (Map.Entry<ReservationInterval, Resource> s : sesInt.entrySet()) {
            if (s.getKey().getStartTime() >= ret || s.getValue() == null) continue;
            ret = s.getKey().getStartTime();
        }
        return ret;
    }

    protected static long findLatestTime(Map<ReservationInterval, Resource> sesInt) {
        long ret = Long.MIN_VALUE;
        for (Map.Entry<ReservationInterval, Resource> s : sesInt.entrySet()) {
            if (s.getKey().getEndTime() <= ret || s.getValue() == null) continue;
            ret = s.getKey().getEndTime();
        }
        return ret;
    }

    protected static long stepRoundDown(long t, long step) {
        return t / step * step;
    }

    protected static long stepRoundUp(long t, long step) {
        return (t + step - 1L) / step * step;
    }

    private ReservationDefinition adjustContract(Plan plan, ReservationDefinition originalContract) {
        return originalContract;
    }

    @Override
    public void init(Configuration conf) {
    }
}

