/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jwt;

import java.text.ParseException;
import org.apache.hadoop.shaded.com.nimbusds.jose.Algorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.Header;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.JSONObjectUtils;
import org.apache.hadoop.shaded.com.nimbusds.jwt.EncryptedJWT;
import org.apache.hadoop.shaded.com.nimbusds.jwt.JWT;
import org.apache.hadoop.shaded.com.nimbusds.jwt.PlainJWT;
import org.apache.hadoop.shaded.com.nimbusds.jwt.SignedJWT;
import org.apache.hadoop.shaded.net.minidev.json.JSONObject;

public final class JWTParser {
    public static JWT parse(String s) throws ParseException {
        JSONObject jsonObject;
        int firstDotPos = s.indexOf(".");
        if (firstDotPos == -1) {
            throw new ParseException("Invalid JWT serialization: Missing dot delimiter(s)", 0);
        }
        Base64URL header = new Base64URL(s.substring(0, firstDotPos));
        try {
            jsonObject = JSONObjectUtils.parse(header.decodeToString());
        }
        catch (ParseException e) {
            throw new ParseException("Invalid unsecured/JWS/JWE header: " + e.getMessage(), 0);
        }
        Algorithm alg = Header.parseAlgorithm(jsonObject);
        if (alg.equals(Algorithm.NONE)) {
            return PlainJWT.parse(s);
        }
        if (alg instanceof JWSAlgorithm) {
            return SignedJWT.parse(s);
        }
        if (alg instanceof JWEAlgorithm) {
            return EncryptedJWT.parse(s);
        }
        throw new AssertionError((Object)("Unexpected algorithm type: " + alg));
    }

    private JWTParser() {
    }
}

